/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPDataException;

public final class CPLC {
    private static final Logger logger = LoggerFactory.getLogger(CPLC.class);
    private final LinkedHashMap<Field, byte[]> values = new LinkedHashMap();

    private CPLC(byte[] data) {
        int offset = 0;
        for (Field f : Field.values()) {
            this.values.put(f, Arrays.copyOfRange(data, offset, offset + f.len));
            offset += f.len;
        }
    }

    public static CPLC fromBytes(byte[] data) throws GPDataException {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (data.length < 42) {
            throw new GPDataException("Input can't be valid CPLC if length is only %02X!".formatted(data.length), data);
        }
        if (data[0] == -97 && data[1] == 127 && data[2] == 42) {
            data = Arrays.copyOfRange(data, 3, data.length);
        }
        return new CPLC(data);
    }

    public byte[] get(Field f) {
        return this.values.get((Object)f);
    }

    public String toString() {
        return Arrays.stream(Field.values()).map(i -> i.toString() + "=" + HexUtils.bin2hex(this.values.get(i))).collect(Collectors.joining(", ", "[CPLC: ", "]"));
    }

    public String toPrettyString() {
        return Arrays.stream(Field.values()).map(i -> i.toString() + "=" + HexUtils.bin2hex(this.values.get(i)) + (String)(i.toString().endsWith("Date") ? " (" + CPLC.toDateFailsafe(this.values.get(i)) + ")" : "")).collect(Collectors.joining("\n      ", "CPLC: ", "\n"));
    }

    public static Optional<LocalDate> toRelativeDate(byte[] v, LocalDate now) throws GPDataException {
        if (v[0] == 0 && v[1] == 0 || v[0] == -1 && v[1] == -1) {
            logger.debug("0x0000/0xFFFF does not represent a valid date");
            return Optional.empty();
        }
        String sv = HexUtils.bin2hex(v);
        try {
            int y = Integer.parseInt(sv.substring(0, 1));
            int d = Integer.parseInt(sv.substring(1, 4));
            int base = 2020;
            if (y >= now.getYear() % 10 && d > now.getDayOfYear()) {
                base = 2010;
            }
            LocalDate ld = LocalDate.ofYearDay(base + y, d);
            return Optional.of(ld);
        }
        catch (NumberFormatException | DateTimeException e) {
            logger.warn("Invalid CPLC date: " + sv);
            return Optional.empty();
        }
    }

    public static String toDateFailsafe(byte[] v) {
        return CPLC.toRelativeDate(v, LocalDate.now(ZoneOffset.UTC)).map(e -> e.format(DateTimeFormatter.ISO_LOCAL_DATE)).orElse("invalid date format");
    }

    public static byte[] today() {
        return CPLC.dateToBytes(LocalDate.now(ZoneOffset.UTC));
    }

    public static byte[] dateToBytes(LocalDate d) {
        return HexUtils.hex2bin("%d%03d".formatted(d.getYear() - 2020, d.getDayOfYear()));
    }

    public static enum Field {
        ICFabricator(2),
        ICType(2),
        OperatingSystemID(2),
        OperatingSystemReleaseDate(2),
        OperatingSystemReleaseLevel(2),
        ICFabricationDate(2),
        ICSerialNumber(4),
        ICBatchIdentifier(2),
        ICModuleFabricator(2),
        ICModulePackagingDate(2),
        ICCManufacturer(2),
        ICEmbeddingDate(2),
        ICPrePersonalizer(2),
        ICPrePersonalizationEquipmentDate(2),
        ICPrePersonalizationEquipmentID(4),
        ICPersonalizer(2),
        ICPersonalizationDate(2),
        ICPersonalizationEquipmentID(4);

        private final int len;

        private Field(int len) {
            this.len = len;
        }
    }
}

