/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPSecureChannelVersion;

public abstract class GPCardKeys {
    private static final Logger logger = LoggerFactory.getLogger(GPCardKeys.class);
    protected GPSecureChannelVersion.SCP scp;
    protected byte[] kdd;
    private boolean diversified = false;

    public abstract GPKeyInfo getKeyInfo();

    public abstract byte[] encrypt(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public abstract byte[] encryptKey(GPCardKeys var1, KeyPurpose var2, byte[] var3) throws GeneralSecurityException;

    public abstract byte[] getSessionKey(KeyPurpose var1, byte[] var2);

    public abstract byte[] kcv(KeyPurpose var1);

    public GPCardKeys diversify(GPSecureChannelVersion.SCP scp, byte[] kdd) {
        if (this.diversified) {
            throw new IllegalStateException("Keys already diversified!");
        }
        this.scp = scp;
        if (this.kdd != null && !Arrays.equals(this.kdd, kdd)) {
            logger.warn("KDD-s don't match: {} vs {}", (Object)HexUtils.bin2hex(this.kdd), (Object)HexUtils.bin2hex(kdd));
        }
        this.kdd = (byte[])kdd.clone();
        this.diversified = true;
        return this;
    }

    public Optional<byte[]> getKDD() {
        return Optional.ofNullable(this.kdd == null ? null : (byte[])this.kdd.clone());
    }

    public String toString() {
        return "KCV-s (%s) ENC=%s MAC=%s DEK=%s".formatted(new Object[]{this.scp, HexUtils.bin2hex(this.kcv(KeyPurpose.ENC)), HexUtils.bin2hex(this.kcv(KeyPurpose.MAC)), HexUtils.bin2hex(this.kcv(KeyPurpose.DEK))});
    }

    public abstract byte[] scp3_kdf(KeyPurpose var1, byte[] var2, byte[] var3, int var4);

    public static enum KeyPurpose {
        ENC(1),
        MAC(2),
        DEK(3),
        RMAC(4);

        private final int value;

        private KeyPurpose(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)(this.value & 0xFF);
        }

        public static List<KeyPurpose> cardKeys() {
            return Arrays.asList(ENC, MAC, DEK);
        }
    }
}

