/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.pace;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import pro.javacard.tlv.TLV;

class SCHelpers {
    SCHelpers() {
    }

    static void dump(TLV tlv, int depth, List<String> result) {
        if (tlv.hasChildren()) {
            result.add("%s[%s]".formatted(" ".repeat(depth * 5), Hex.toHexString(tlv.tag().bytes())));
            for (TLV child : tlv.children()) {
                SCHelpers.dump(child, depth + 1, result);
            }
        } else {
            result.add("%s[%s] %s".formatted(" ".repeat(depth * 5), Hex.toHexString(tlv.tag().bytes()), Hex.toHexString(tlv.value())));
        }
    }

    static void dump(List<TLV> list, int depth, List<String> result) {
        for (TLV t : list) {
            SCHelpers.dump(t, depth, result);
        }
    }

    public static List<String> visualize_tlv(byte[] payload) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<TLV> tlvs = TLV.parse(payload);
            SCHelpers.dump(tlvs, 0, result);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not valid TLVs: " + e.getMessage(), e);
        }
        return result;
    }

    static void trace_tlv(byte[] data, Logger l) {
        try {
            for (String s : SCHelpers.visualize_tlv(data)) {
                l.trace(s);
            }
        }
        catch (IllegalArgumentException e) {
            l.error("Invalid TLV data: {}", (Object)Hex.toHexString(data), (Object)e);
        }
    }
}

