/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import pro.javacard.tlv.Tag;

public record BERTag(byte[] bytes) implements Tag
{
    private final byte[] bytes;

    public BERTag {
        bytes = (byte[])BERTag.validate(bytes).clone();
    }

    @Override
    public byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    static byte[] validate(byte[] value) {
        Objects.requireNonNull(value, "tag cannot be null");
        if (value.length == 0 || value.length > 4) {
            throw new IllegalArgumentException("Invalid tag length: " + value.length);
        }
        if (value.length > 1 && (value[0] & 0x1F) != 31) {
            throw new IllegalArgumentException("Multi-byte tag must have first byte with 0x1F");
        }
        for (int i = 1; i < value.length - 1; ++i) {
            if ((value[i] & 0x80) != 0) continue;
            throw new IllegalArgumentException("Tag continuation byte missing 0x80 bit");
        }
        if (value.length > 1 && (value[value.length - 1] & 0x80) != 0) {
            throw new IllegalArgumentException("Tag last byte should not have 0x80 bit");
        }
        return value;
    }

    public boolean isConstructed() {
        return (this.bytes[0] & 0x20) == 32;
    }

    static BERTag parse(ByteBuffer buffer) {
        byte[] bytes = new byte[4];
        int pos = buffer.position();
        int len = 0;
        byte b = buffer.get(pos);
        bytes[len++] = b;
        if ((b & 0x1F) == 31) {
            for (int i = 1; i < 4; ++i) {
                b = buffer.get(pos + i);
                bytes[len++] = b;
                if ((b & 0x80) == 0) break;
            }
        }
        BERTag tag = new BERTag(Arrays.copyOf(bytes, len));
        buffer.position(pos + len);
        return tag;
    }

    @Override
    public String toString() {
        return this.toHex();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BERTag)) return false;
        BERTag other = (BERTag)obj;
        if (!Arrays.equals(this.bytes, other.bytes)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

