/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.palettes;

import java.util.HashMap;
import java.util.Map;
import org.glavo.monetfx.internal.hct.Hct;

public final class TonalPalette {
    final Hct keyColor;
    final double hue;
    final double chroma;

    public static TonalPalette fromInt(int argb) {
        return TonalPalette.fromHct(Hct.fromInt(argb));
    }

    public static TonalPalette fromHct(Hct hct) {
        return new TonalPalette(hct.getHue(), hct.getChroma(), hct);
    }

    public static TonalPalette fromHueAndChroma(double hue, double chroma) {
        Hct keyColor = new KeyColor(hue, chroma).create();
        return new TonalPalette(hue, chroma, keyColor);
    }

    private TonalPalette(double hue, double chroma, Hct keyColor) {
        this.hue = hue;
        this.chroma = chroma;
        this.keyColor = keyColor;
    }

    public int tone(int tone) {
        if (tone == 99 && Hct.isYellow(this.hue)) {
            return this.averageArgb(this.tone(98), this.tone(100));
        }
        return Hct.from(this.hue, this.chroma, tone).toInt();
    }

    public Hct getHct(double tone) {
        return Hct.from(this.hue, this.chroma, tone);
    }

    public double getChroma() {
        return this.chroma;
    }

    public double getHue() {
        return this.hue;
    }

    public Hct getKeyColor() {
        return this.keyColor;
    }

    private int averageArgb(int argb1, int argb2) {
        int red1 = argb1 >>> 16 & 0xFF;
        int green1 = argb1 >>> 8 & 0xFF;
        int blue1 = argb1 & 0xFF;
        int red2 = argb2 >>> 16 & 0xFF;
        int green2 = argb2 >>> 8 & 0xFF;
        int blue2 = argb2 & 0xFF;
        int red = Math.round((float)(red1 + red2) / 2.0f);
        int green = Math.round((float)(green1 + green2) / 2.0f);
        int blue = Math.round((float)(blue1 + blue2) / 2.0f);
        return (0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF) >>> 0;
    }

    private static final class KeyColor {
        private final double hue;
        private final double requestedChroma;
        private final Map<Integer, Double> chromaCache = new HashMap<Integer, Double>();
        private static final double MAX_CHROMA_VALUE = 200.0;

        public KeyColor(double hue, double requestedChroma) {
            this.hue = hue;
            this.requestedChroma = requestedChroma;
        }

        public Hct create() {
            int pivotTone = 50;
            boolean toneStepSize = true;
            double epsilon = 0.01;
            int lowerTone = 0;
            int upperTone = 100;
            while (lowerTone < upperTone) {
                boolean sufficientChroma;
                int midTone = (lowerTone + upperTone) / 2;
                boolean isAscending = this.maxChroma(midTone) < this.maxChroma(midTone + 1);
                boolean bl = sufficientChroma = this.maxChroma(midTone) >= this.requestedChroma - 0.01;
                if (sufficientChroma) {
                    if (Math.abs(lowerTone - 50) < Math.abs(upperTone - 50)) {
                        upperTone = midTone;
                        continue;
                    }
                    if (lowerTone == midTone) {
                        return Hct.from(this.hue, this.requestedChroma, lowerTone);
                    }
                    lowerTone = midTone;
                    continue;
                }
                if (isAscending) {
                    lowerTone = midTone + 1;
                    continue;
                }
                upperTone = midTone;
            }
            return Hct.from(this.hue, this.requestedChroma, lowerTone);
        }

        private double maxChroma(int tone) {
            if (this.chromaCache.get(tone) == null) {
                double newChroma = Hct.from(this.hue, 200.0, tone).getChroma();
                this.chromaCache.put(tone, newChroma);
            }
            return this.chromaCache.get(tone);
        }
    }
}

