/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.logging.Logger;

public class MultipleSourceVersionList
extends VersionList<RemoteVersion> {
    private final VersionList<?>[] backends;

    MultipleSourceVersionList(VersionList<?>[] backends) {
        this.backends = backends;
        assert (backends.length >= 1);
    }

    @Override
    public boolean hasType() {
        boolean hasType = this.backends[0].hasType();
        assert (Arrays.stream(this.backends).allMatch(versionList -> versionList.hasType() == hasType));
        return hasType;
    }

    @Override
    public Task<?> refreshAsync() {
        throw new UnsupportedOperationException("MultipleSourceVersionList does not support loading the entire remote version list.");
    }

    private Task<?> refreshAsync(final String gameVersion, final int sourceIndex) {
        final VersionList<?> versionList = this.backends[sourceIndex];
        final Task<?> refreshTask = versionList.refreshAsync(gameVersion);
        return new Task<Object>(){
            private Task<?> nextTask = null;
            {
                this.setSignificance(Task.TaskSignificance.MODERATE);
                this.setName("MultipleSourceVersionList.refreshAsync(" + sourceIndex + ")");
            }

            @Override
            public Collection<Task<?>> getDependents() {
                return List.of(refreshTask);
            }

            @Override
            public Collection<? extends Task<?>> getDependencies() {
                return this.nextTask != null ? List.of(this.nextTask) : List.of();
            }

            @Override
            public boolean isRelyingOnDependents() {
                return false;
            }

            @Override
            public void execute() throws Exception {
                if (this.isDependentsSucceeded()) {
                    MultipleSourceVersionList.this.lock.writeLock().lock();
                    try {
                        MultipleSourceVersionList.this.versions.putAll(gameVersion, versionList.getVersions(gameVersion));
                    }
                    finally {
                        MultipleSourceVersionList.this.lock.writeLock().unlock();
                    }
                    this.setResult(refreshTask.getResult());
                } else {
                    Exception exception = refreshTask.getException();
                    assert (exception != null);
                    if (sourceIndex == MultipleSourceVersionList.this.backends.length - 1) {
                        Logger.LOG.warning("Failed to fetch versions list from all sources", exception);
                        this.setSignificance(Task.TaskSignificance.MINOR);
                        throw exception;
                    }
                    Logger.LOG.warning("Failed to fetch versions list and try to fetch from other source", exception);
                    this.nextTask = MultipleSourceVersionList.this.refreshAsync(gameVersion, sourceIndex + 1);
                    this.nextTask.storeTo(x$0 -> this.setResult(x$0));
                }
            }
        };
    }

    @Override
    public Task<?> refreshAsync(String gameVersion) {
        this.versions.clear(gameVersion);
        return this.refreshAsync(gameVersion, 0);
    }
}

