/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersionInfo;
import org.jackhuang.hmcl.download.game.GameRemoteVersions;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class GameVersionList
extends VersionList<GameRemoteVersion> {
    private final DownloadProvider downloadProvider;

    public GameVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    @Override
    protected Collection<GameRemoteVersion> getVersionsImpl(String gameVersion) {
        return this.versions.values();
    }

    @Override
    public Task<?> refreshAsync() {
        return new GetTask(this.downloadProvider.getVersionListURLs()).thenGetJsonAsync(GameRemoteVersions.class).thenAcceptAsync(root -> {
            GameRemoteVersions unlistedVersions = null;
            try (InputStreamReader input = new InputStreamReader(GameVersionList.class.getResourceAsStream("/assets/game/unlisted-versions.json"));){
                unlistedVersions = JsonUtils.GSON.fromJson((Reader)input, GameRemoteVersions.class);
            }
            catch (Throwable e) {
                Logger.LOG.error("Failed to load unlisted versions", e);
            }
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                if (unlistedVersions != null) {
                    for (GameRemoteVersionInfo unlistedVersion : unlistedVersions.versions()) {
                        this.versions.put(unlistedVersion.gameVersion(), new GameRemoteVersion(unlistedVersion.gameVersion(), unlistedVersion.gameVersion(), Collections.singletonList(unlistedVersion.url()), unlistedVersion.type(), unlistedVersion.releaseTime()));
                    }
                }
                for (GameRemoteVersionInfo remoteVersion : root.versions()) {
                    this.versions.put(remoteVersion.gameVersion(), new GameRemoteVersion(remoteVersion.gameVersion(), remoteVersion.gameVersion(), Collections.singletonList(remoteVersion.url()), remoteVersion.type(), remoteVersion.releaseTime()));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    public String toString() {
        return "GameVersionList[downloadProvider=%s]".formatted(this.downloadProvider);
    }
}

