/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import java.util.List;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.account.AccountListItem;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.account.CreateAccountPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.ClassTitle;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AccountListPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    static final BooleanProperty RESTRICTED = new SimpleBooleanProperty(true);
    private final ObservableList<AccountListItem> items;
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("account.manage")));
    private final ListProperty<Account> accounts = new SimpleListProperty((Object)this, "accounts", FXCollections.observableArrayList());
    private final ListProperty<AuthlibInjectorServer> authServers = new SimpleListProperty((Object)this, "authServers", FXCollections.observableArrayList());
    private final ObjectProperty<Account> selectedAccount;

    public AccountListPage() {
        this.items = MappedObservableList.create(this.accounts, AccountListItem::new);
        this.selectedAccount = ExtendedProperties.createSelectedItemPropertyFor(this.items, Account.class);
    }

    public ObjectProperty<Account> selectedAccountProperty() {
        return this.selectedAccount;
    }

    public ListProperty<Account> accountsProperty() {
        return this.accounts;
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public ListProperty<AuthlibInjectorServer> authServersProperty() {
        return this.authServers;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new AccountListPageSkin(this);
    }

    static {
        String property = System.getProperty("hmcl.offline.auth.restricted", "auto");
        if ("false".equals(property) || "auto".equals(property) && LocaleUtils.IS_CHINA_MAINLAND || ConfigHolder.globalConfig().isEnableOfflineAccount()) {
            RESTRICTED.set(false);
        } else {
            ConfigHolder.globalConfig().enableOfflineAccountProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> o, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        ConfigHolder.globalConfig().enableOfflineAccountProperty().removeListener((ChangeListener)this);
                        RESTRICTED.set(false);
                    }
                }
            });
        }
    }

    private static class AccountListPageSkin
    extends DecoratorAnimatedPage.DecoratorAnimatedPageSkin<AccountListPage> {
        private final ObservableList<AdvancedListItem> authServerItems;
        private ChangeListener<Boolean> holder;

        public AccountListPageSkin(AccountListPage skinnable) {
            super(skinnable);
            VBox boxMethods = new VBox();
            boxMethods.getStyleClass().add((Object)"advanced-list-box-content");
            FXUtils.setLimitWidth((Region)boxMethods, 200.0);
            AdvancedListItem microsoftItem = new AdvancedListItem();
            microsoftItem.getStyleClass().add((Object)"navigation-drawer-item");
            microsoftItem.setActionButtonVisible(false);
            microsoftItem.setTitle(I18n.i18n("account.methods.microsoft"));
            microsoftItem.setLeftGraphic(VersionPage.wrap(SVG.MICROSOFT));
            microsoftItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.dialog((Region)new CreateAccountPane(Accounts.FACTORY_MICROSOFT))));
            AdvancedListItem offlineItem = new AdvancedListItem();
            offlineItem.getStyleClass().add((Object)"navigation-drawer-item");
            offlineItem.setActionButtonVisible(false);
            offlineItem.setTitle(I18n.i18n("account.methods.offline"));
            offlineItem.setLeftGraphic(VersionPage.wrap(SVG.PERSON));
            offlineItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.dialog((Region)new CreateAccountPane(Accounts.FACTORY_OFFLINE))));
            VBox boxAuthServers = new VBox();
            this.authServerItems = MappedObservableList.create(skinnable.authServersProperty(), server -> {
                AdvancedListItem item = new AdvancedListItem();
                item.getStyleClass().add((Object)"navigation-drawer-item");
                item.setLeftGraphic(VersionPage.wrap(SVG.DRESSER));
                item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.dialog((Region)new CreateAccountPane((AuthlibInjectorServer)server))));
                JFXButton btnRemove = new JFXButton();
                btnRemove.setOnAction(e -> {
                    Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.authServersProperty().remove(server), null);
                    e.consume();
                });
                btnRemove.getStyleClass().add((Object)"toggle-icon4");
                btnRemove.setGraphic(SVG.CLOSE.createIcon(14.0));
                item.setRightGraphic((Node)btnRemove);
                BindingMapping<?, String> title = BindingMapping.of(server, AuthlibInjectorServer::getName);
                item.titleProperty().bind(title);
                String host = "";
                try {
                    host = NetworkUtils.toURI(server.getUrl()).getHost();
                }
                catch (IllegalArgumentException e2) {
                    Logger.LOG.warning("Unparsable authlib-injector server url " + server.getUrl(), e2);
                }
                item.subtitleProperty().set((Object)host);
                Tooltip tooltip = new Tooltip();
                tooltip.textProperty().bind((ObservableValue)Bindings.format((String)"%s (%s)", (Object[])new Object[]{title, server.getUrl()}));
                FXUtils.installFastTooltip((Node)item, tooltip);
                return item;
            });
            Bindings.bindContent((List)boxAuthServers.getChildren(), this.authServerItems);
            ClassTitle title = new ClassTitle(I18n.i18n("account.create").toUpperCase(Locale.ROOT));
            if (RESTRICTED.get()) {
                VBox wrapper = new VBox(new Node[]{offlineItem, boxAuthServers});
                wrapper.setPadding(Insets.EMPTY);
                FXUtils.installFastTooltip((Node)wrapper, I18n.i18n("account.login.restricted"));
                offlineItem.setDisable(true);
                boxAuthServers.setDisable(true);
                boxMethods.getChildren().setAll((Object[])new Node[]{title, microsoftItem, wrapper});
                this.holder = FXUtils.onWeakChange(RESTRICTED, value -> {
                    if (!value.booleanValue()) {
                        this.holder = null;
                        offlineItem.setDisable(false);
                        boxAuthServers.setDisable(false);
                        boxMethods.getChildren().setAll((Object[])new Node[]{title, microsoftItem, offlineItem, boxAuthServers});
                    }
                });
            } else {
                boxMethods.getChildren().setAll((Object[])new Node[]{title, microsoftItem, offlineItem, boxAuthServers});
            }
            AdvancedListItem addAuthServerItem = new AdvancedListItem();
            addAuthServerItem.getStyleClass().add((Object)"navigation-drawer-item");
            addAuthServerItem.setTitle(I18n.i18n("account.injector.add"));
            addAuthServerItem.setSubtitle(I18n.i18n("account.methods.authlib_injector"));
            addAuthServerItem.setActionButtonVisible(false);
            addAuthServerItem.setLeftGraphic(VersionPage.wrap(SVG.ADD_CIRCLE));
            addAuthServerItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.dialog((Region)new AddAuthlibInjectorServerPane())));
            VBox.setMargin((Node)addAuthServerItem, (Insets)new Insets(0.0, 0.0, 12.0, 0.0));
            ScrollPane scrollPane = new ScrollPane((Node)boxMethods);
            VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
            this.setLeft(new Node[]{scrollPane, addAuthServerItem});
            ScrollPane scrollPane2 = new ScrollPane();
            VBox list = new VBox();
            scrollPane2.setFitToWidth(true);
            list.maxWidthProperty().bind((ObservableValue)scrollPane2.widthProperty());
            list.setSpacing(10.0);
            list.getStyleClass().add((Object)"card-list");
            Bindings.bindContent((List)list.getChildren(), skinnable.items);
            scrollPane2.setContent((Node)list);
            FXUtils.smoothScrolling(scrollPane2);
            this.setCenter(new Node[]{scrollPane2});
        }
    }
}

