/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Callable;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.glavo.png.javafx.PNGJavaFXUtils;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DoubleValidator;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.PropertyKey;

public final class WorldInfoPage
extends SpinnerPane {
    private final WorldManagePage worldManagePage;
    private final World world;
    private CompoundTag levelDat;
    ImageView iconImageView = new ImageView();

    public WorldInfoPage(WorldManagePage worldManagePage) {
        this.worldManagePage = worldManagePage;
        this.world = worldManagePage.getWorld();
        this.setLoading(true);
        Task.supplyAsync(this::loadWorldInfo).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.levelDat = result;
                this.updateControls();
                this.setLoading(false);
            } else {
                Logger.LOG.warning("Failed to load level.dat", exception);
                this.setFailedReason(I18n.i18n("world.info.failed"));
            }
        }).start();
    }

    private CompoundTag loadWorldInfo() throws IOException {
        if (!Files.isDirectory(this.world.getFile(), new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        return this.world.getLevelData();
    }

    private void updateControls() {
        CompoundTag dataTag = (CompoundTag)this.levelDat.get("Data");
        CompoundTag worldGenSettings = (CompoundTag)dataTag.get("WorldGenSettings");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.setContent((Node)scrollPane);
        VBox rootPane = new VBox();
        rootPane.setFillWidth(true);
        scrollPane.setContent((Node)rootPane);
        FXUtils.smoothScrolling(scrollPane);
        rootPane.getStyleClass().add((Object)"card-list");
        ComponentList basicInfo = new ComponentList();
        BorderPane worldNamePane = new BorderPane();
        this.setLeftLabel(worldNamePane, "world.name");
        JFXTextField worldNameField = new JFXTextField();
        this.setRightTextField(worldNamePane, worldNameField, 200);
        Object tag = dataTag.get("LevelName");
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            worldNameField.setText(stringTag.getValue());
            worldNameField.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    try {
                        this.world.setWorldName((String)newValue);
                    }
                    catch (Exception e) {
                        Logger.LOG.warning("Failed to set world name", e);
                    }
                }
            });
        } else {
            worldNameField.setDisable(true);
        }
        BorderPane gameVersionPane = new BorderPane();
        this.setLeftLabel(gameVersionPane, "world.info.game_version");
        Label gameVersionLabel = new Label();
        this.setRightTextLabel(gameVersionPane, gameVersionLabel, () -> this.world.getGameVersion() == null ? "" : this.world.getGameVersion().toNormalizedString());
        BorderPane iconPane = new BorderPane();
        this.setLeftLabel(iconPane, "world.icon");
        Runnable onClickAction = () -> Controllers.confirm(I18n.i18n("world.icon.change.tip"), I18n.i18n("world.icon.change"), MessageDialogPane.MessageType.INFO, this::changeWorldIcon, null);
        FXUtils.limitSize(this.iconImageView, 32.0, 32.0);
        this.iconImageView.setImage(this.world.getIcon() == null ? FXUtils.newBuiltinImage("/assets/img/unknown_server.png") : this.world.getIcon());
        JFXButton editIconButton = new JFXButton();
        JFXButton resetIconButton = new JFXButton();
        editIconButton.setGraphic(SVG.EDIT.createIcon(20.0));
        editIconButton.setDisable(this.worldManagePage.isReadOnly());
        FXUtils.onClicked((Node)editIconButton, onClickAction);
        FXUtils.installFastTooltip((Node)editIconButton, I18n.i18n("button.edit"));
        editIconButton.getStyleClass().add((Object)"toggle-icon4");
        resetIconButton.setGraphic(SVG.RESTORE.createIcon(20.0));
        resetIconButton.setDisable(this.worldManagePage.isReadOnly());
        FXUtils.onClicked((Node)resetIconButton, this::clearWorldIcon);
        FXUtils.installFastTooltip((Node)resetIconButton, I18n.i18n("button.reset"));
        resetIconButton.getStyleClass().add((Object)"toggle-icon4");
        HBox hBox = new HBox(8.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Object[])new Node[]{this.iconImageView, editIconButton, resetIconButton});
        iconPane.setRight((Node)hBox);
        BorderPane seedPane = new BorderPane();
        this.setLeftLabel(seedPane, "world.info.random_seed");
        SimpleBooleanProperty visibility = new SimpleBooleanProperty();
        StackPane visibilityButton = new StackPane();
        visibilityButton.setCursor(Cursor.HAND);
        visibilityButton.setAlignment(Pos.BOTTOM_RIGHT);
        FXUtils.setLimitWidth((Region)visibilityButton, 12.0);
        FXUtils.setLimitHeight((Region)visibilityButton, 12.0);
        FXUtils.onClicked((Node)visibilityButton, () -> visibility.set(!visibility.get()));
        Label seedLabel = new Label();
        FXUtils.copyOnDoubleClick((Labeled)seedLabel);
        seedLabel.setAlignment(Pos.CENTER_RIGHT);
        seedLabel.setText(this.world.getSeed() != null ? this.world.getSeed().toString() : "");
        BoxBlur blur = new BoxBlur();
        blur.setIterations(3);
        FXUtils.onChangeAndOperate(visibility, isVisibility -> {
            SVG icon = isVisibility != false ? SVG.VISIBILITY : SVG.VISIBILITY_OFF;
            visibilityButton.getChildren().setAll((Object[])new Node[]{icon.createIcon(12.0)});
            seedLabel.setEffect((Effect)(isVisibility != false ? null : blur));
        });
        HBox right = new HBox(8.0);
        BorderPane.setAlignment((Node)right, (Pos)Pos.CENTER_RIGHT);
        right.getChildren().setAll((Object[])new Node[]{visibilityButton, seedLabel});
        seedPane.setRight((Node)right);
        BorderPane lastPlayedPane = new BorderPane();
        this.setLeftLabel(lastPlayedPane, "world.info.last_played");
        Label lastPlayedLabel = new Label();
        this.setRightTextLabel(lastPlayedPane, lastPlayedLabel, () -> I18n.formatDateTime(Instant.ofEpochMilli(this.world.getLastPlayed())));
        BorderPane timePane = new BorderPane();
        this.setLeftLabel(timePane, "world.info.time");
        Label timeLabel = new Label();
        this.setRightTextLabel(timePane, timeLabel, () -> {
            Object tag = dataTag.get("Time");
            if (tag instanceof LongTag) {
                long days = ((LongTag)tag).getValue() / 24000L;
                return I18n.i18n("world.info.time.format", days);
            }
            return "";
        });
        OptionToggleButton allowCheatsButton = new OptionToggleButton();
        allowCheatsButton.setTitle(I18n.i18n("world.info.allow_cheats"));
        allowCheatsButton.setDisable(this.worldManagePage.isReadOnly());
        Object tag2 = dataTag.get("allowCommands");
        this.checkTagAndSetListener((Tag)tag2, allowCheatsButton);
        OptionToggleButton generateFeaturesButton = new OptionToggleButton();
        generateFeaturesButton.setTitle(I18n.i18n("world.info.generate_features"));
        generateFeaturesButton.setDisable(this.worldManagePage.isReadOnly());
        Object tag3 = worldGenSettings != null ? worldGenSettings.get("generate_features") : dataTag.get("MapFeatures");
        this.checkTagAndSetListener((Tag)tag3, generateFeaturesButton);
        BorderPane difficultyPane = new BorderPane();
        this.setLeftLabel(difficultyPane, "world.info.difficulty");
        JFXComboBox<Difficulty> difficultyBox = new JFXComboBox<Difficulty>(Difficulty.items);
        difficultyBox.setDisable(this.worldManagePage.isReadOnly());
        BorderPane.setAlignment(difficultyBox, (Pos)Pos.CENTER_RIGHT);
        difficultyPane.setRight(difficultyBox);
        Object tag4 = dataTag.get("Difficulty");
        if (tag4 instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag4;
            Difficulty difficulty = Difficulty.of(byteTag.getValue().byteValue());
            if (difficulty != null) {
                difficultyBox.setValue((Object)difficulty);
                difficultyBox.valueProperty().addListener((o, oldValue, newValue) -> {
                    if (newValue != null) {
                        byteTag.setValue((byte)newValue.ordinal());
                        this.saveLevelDat();
                    }
                });
            } else {
                difficultyBox.setDisable(true);
            }
        } else {
            difficultyBox.setDisable(true);
        }
        OptionToggleButton difficultyLockPane = new OptionToggleButton();
        difficultyLockPane.setTitle(I18n.i18n("world.info.difficulty_lock"));
        difficultyLockPane.setDisable(this.worldManagePage.isReadOnly());
        tag4 = dataTag.get("DifficultyLocked");
        this.checkTagAndSetListener((Tag)tag4, difficultyLockPane);
        basicInfo.getContent().setAll((Object[])new Node[]{worldNamePane, gameVersionPane, iconPane, seedPane, lastPlayedPane, timePane, allowCheatsButton, generateFeaturesButton, difficultyPane, difficultyLockPane});
        rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.info.basic")), basicInfo});
        Object playerTag = dataTag.get("Player");
        if (playerTag instanceof CompoundTag) {
            IntTag intTag;
            boolean isHardcore;
            CompoundTag player = (CompoundTag)playerTag;
            ComponentList playerInfo = new ComponentList();
            BorderPane locationPane = new BorderPane();
            this.setLeftLabel(locationPane, "world.info.player.location");
            Label locationLabel = new Label();
            this.setRightTextLabel(locationPane, locationLabel, () -> {
                String posString;
                Dimension dim = Dimension.of(player.get("Dimension"));
                if (dim != null && (posString = dim.formatPosition((Tag)player.get("Pos"))) != null) {
                    return posString;
                }
                return "";
            });
            BorderPane lastDeathLocationPane = new BorderPane();
            this.setLeftLabel(lastDeathLocationPane, "world.info.player.last_death_location");
            Label lastDeathLocationLabel = new Label();
            this.setRightTextLabel(lastDeathLocationPane, lastDeathLocationLabel, () -> {
                String posString;
                CompoundTag compoundTag;
                Dimension dim;
                Object tag = player.get("LastDeathLocation");
                if (tag instanceof CompoundTag && (dim = Dimension.of((compoundTag = (CompoundTag)tag).get("dimension"))) != null && (posString = dim.formatPosition((Tag)compoundTag.get("pos"))) != null) {
                    return posString;
                }
                return "";
            });
            BorderPane spawnPane = new BorderPane();
            this.setLeftLabel(spawnPane, "world.info.player.spawn");
            Label spawnLabel = new Label();
            this.setRightTextLabel(spawnPane, spawnLabel, () -> {
                CompoundTag respawnTag;
                Object patt15039$temp = player.get("respawn");
                if (patt15039$temp instanceof CompoundTag && (respawnTag = (CompoundTag)patt15039$temp).get("dimension") != null) {
                    IntArrayTag intArrayTag;
                    Dimension dimension = Dimension.of(respawnTag.get("dimension"));
                    Object posTag = respawnTag.get("pos");
                    if (posTag instanceof IntArrayTag && (intArrayTag = (IntArrayTag)posTag).length() >= 3) {
                        return dimension.formatPosition(intArrayTag.getValue(0), intArrayTag.getValue(1), intArrayTag.getValue(2));
                    }
                } else {
                    Object patt15593$temp = player.get("SpawnX");
                    if (patt15593$temp instanceof IntTag) {
                        IntTag intX = (IntTag)patt15593$temp;
                        Object patt15668$temp = player.get("SpawnY");
                        if (patt15668$temp instanceof IntTag) {
                            IntTag intY = (IntTag)patt15668$temp;
                            Object patt15743$temp = player.get("SpawnZ");
                            if (patt15743$temp instanceof IntTag) {
                                IntTag intZ = (IntTag)patt15743$temp;
                                Dimension dimension = Dimension.of(player.get("SpawnDimension") == null ? new IntTag("SpawnDimension", 0) : player.get("SpawnDimension"));
                                if (dimension == null) {
                                    return "";
                                }
                                return dimension.formatPosition(intX.getValue(), intY.getValue(), intZ.getValue());
                            }
                        }
                    }
                }
                return "";
            });
            BorderPane playerGameTypePane = new BorderPane();
            this.setLeftLabel(playerGameTypePane, "world.info.player.game_type");
            JFXComboBox<GameType> gameTypeBox = new JFXComboBox<GameType>(GameType.items);
            gameTypeBox.setDisable(this.worldManagePage.isReadOnly());
            BorderPane.setAlignment(gameTypeBox, (Pos)Pos.CENTER_RIGHT);
            playerGameTypePane.setRight(gameTypeBox);
            tag3 = player.get("playerGameType");
            Object hardcoreTag = dataTag.get("hardcore");
            boolean bl = isHardcore = hardcoreTag instanceof ByteTag && ((ByteTag)hardcoreTag).getValue() == 1;
            if (tag3 instanceof IntTag) {
                intTag = (IntTag)tag3;
                GameType gameType = GameType.of(intTag.getValue(), isHardcore);
                if (gameType != null) {
                    gameTypeBox.setValue((Object)gameType);
                    gameTypeBox.valueProperty().addListener((o, oldValue, newValue) -> {
                        if (newValue != null) {
                            if (newValue == GameType.HARDCORE) {
                                intTag.setValue(0);
                                if (hardcoreTag instanceof ByteTag) {
                                    ((ByteTag)hardcoreTag).setValue((byte)1);
                                }
                            } else {
                                intTag.setValue(newValue.ordinal());
                                if (hardcoreTag instanceof ByteTag) {
                                    ((ByteTag)hardcoreTag).setValue((byte)0);
                                }
                            }
                            this.saveLevelDat();
                        }
                    });
                } else {
                    gameTypeBox.setDisable(true);
                }
            } else {
                gameTypeBox.setDisable(true);
            }
            BorderPane healthPane = new BorderPane();
            this.setLeftLabel(healthPane, "world.info.player.health");
            JFXTextField healthField = new JFXTextField();
            this.setRightTextField(healthPane, healthField, 50);
            Object tag5 = player.get("Health");
            if (tag5 instanceof FloatTag) {
                FloatTag floatTag = (FloatTag)tag5;
                this.setTagAndTextField(floatTag, healthField);
            } else {
                healthField.setDisable(true);
            }
            BorderPane foodLevelPane = new BorderPane();
            this.setLeftLabel(foodLevelPane, "world.info.player.food_level");
            JFXTextField foodLevelField = new JFXTextField();
            this.setRightTextField(foodLevelPane, foodLevelField, 50);
            tag = player.get("foodLevel");
            if (tag instanceof IntTag) {
                intTag = (IntTag)tag;
                this.setTagAndTextField(intTag, foodLevelField);
            } else {
                foodLevelField.setDisable(true);
            }
            BorderPane xpLevelPane = new BorderPane();
            this.setLeftLabel(xpLevelPane, "world.info.player.xp_level");
            JFXTextField xpLevelField = new JFXTextField();
            this.setRightTextField(xpLevelPane, xpLevelField, 50);
            Object tag6 = player.get("XpLevel");
            if (tag6 instanceof IntTag) {
                IntTag intTag2 = (IntTag)tag6;
                this.setTagAndTextField(intTag2, xpLevelField);
            } else {
                xpLevelField.setDisable(true);
            }
            playerInfo.getContent().setAll((Object[])new Node[]{locationPane, lastDeathLocationPane, spawnPane, playerGameTypePane, healthPane, foodLevelPane, xpLevelPane});
            rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.info.player")), playerInfo});
        }
    }

    private void setLeftLabel(BorderPane borderPane, @PropertyKey(resourceBundle="assets.lang.I18N") @PropertyKey(resourceBundle="assets.lang.I18N") String key) {
        Label label = new Label(I18n.i18n(key));
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        borderPane.setLeft((Node)label);
    }

    private void setRightTextField(BorderPane borderPane, JFXTextField textField, int perfWidth) {
        textField.setDisable(this.worldManagePage.isReadOnly());
        textField.setPrefWidth(perfWidth);
        textField.setAlignment(Pos.CENTER_RIGHT);
        borderPane.setRight((Node)textField);
    }

    private void setRightTextLabel(BorderPane borderPane, Label label, Callable<String> setNameCall) {
        FXUtils.copyOnDoubleClick((Labeled)label);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_RIGHT);
        try {
            label.setText(setNameCall.call());
        }
        catch (Exception e) {
            Logger.LOG.warning("Exception happened when setting name", e);
        }
        borderPane.setRight((Node)label);
    }

    private void checkTagAndSetListener(Tag tag, OptionToggleButton toggleButton) {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            byte value = byteTag.getValue();
            if (value == 0 || value == 1) {
                toggleButton.setSelected(value == 1);
                toggleButton.selectedProperty().addListener((o, oldValue, newValue) -> {
                    try {
                        byteTag.setValue((byte)(newValue != false ? 1 : 0));
                        this.saveLevelDat();
                    }
                    catch (Exception e) {
                        toggleButton.setSelected((boolean)oldValue);
                        Logger.LOG.warning("Exception happened when saving level.dat", e);
                    }
                });
            } else {
                toggleButton.setDisable(true);
            }
        } else {
            toggleButton.setDisable(true);
        }
    }

    private void setTagAndTextField(IntTag intTag, JFXTextField jfxTextField) {
        jfxTextField.setText(String.valueOf(intTag.getValue()));
        jfxTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    intTag.setValue(Integer.parseInt(newValue));
                    this.saveLevelDat();
                }
                catch (Exception e) {
                    jfxTextField.setText((String)oldValue);
                    Logger.LOG.warning("Exception happened when saving level.dat", e);
                }
            }
        });
        FXUtils.setValidateWhileTextChanged((Node)jfxTextField, true);
        jfxTextField.setValidators(new NumberValidator(I18n.i18n("input.number"), true));
    }

    private void setTagAndTextField(FloatTag floatTag, JFXTextField jfxTextField) {
        jfxTextField.setText(new DecimalFormat("#").format(floatTag.getValue().floatValue()));
        jfxTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    floatTag.setValue(Float.parseFloat(newValue));
                    this.saveLevelDat();
                }
                catch (Exception e) {
                    jfxTextField.setText((String)oldValue);
                    Logger.LOG.warning("Exception happened when saving level.dat", e);
                }
            }
        });
        FXUtils.setValidateWhileTextChanged((Node)jfxTextField, true);
        jfxTextField.setValidators(new DoubleValidator(I18n.i18n("input.number"), true));
    }

    private void saveLevelDat() {
        Logger.LOG.info("Saving level.dat of world " + this.world.getWorldName());
        try {
            this.world.writeLevelDat(this.levelDat);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to save level.dat of world " + this.world.getWorldName(), e);
        }
    }

    private void changeWorldIcon() {
        Image image;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("world.icon.choose.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("extension.png"), new String[]{"*.png"}));
        fileChooser.setInitialFileName("icon.png");
        File file = fileChooser.showOpenDialog((Window)Controllers.getStage());
        if (file == null) {
            return;
        }
        try {
            image = FXUtils.loadImage(file.toPath());
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to load image", e);
            Controllers.dialog(I18n.i18n("world.icon.change.fail.load.text"), I18n.i18n("world.icon.change.fail.load.title"), MessageDialogPane.MessageType.ERROR);
            return;
        }
        if ((int)image.getWidth() == 64 && (int)image.getHeight() == 64) {
            Path output = this.world.getFile().resolve("icon.png");
            this.saveImage(image, output);
        } else {
            Controllers.dialog(I18n.i18n("world.icon.change.fail.not_64x64.text", (int)image.getWidth(), (int)image.getHeight()), I18n.i18n("world.icon.change.fail.not_64x64.title"), MessageDialogPane.MessageType.ERROR);
        }
    }

    private void saveImage(Image image, Path path) {
        Image oldImage = this.iconImageView.getImage();
        try {
            PNGJavaFXUtils.writeImage(image, path);
            this.iconImageView.setImage(image);
            Controllers.showToast(I18n.i18n("world.icon.change.succeed.toast"));
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to save world icon " + e.getMessage());
            this.iconImageView.setImage(oldImage);
        }
    }

    private void clearWorldIcon() {
        Path output = this.world.getFile().resolve("icon.png");
        try {
            Files.deleteIfExists(output);
            this.iconImageView.setImage(FXUtils.newBuiltinImage("/assets/img/unknown_server.png"));
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to delete world icon " + e.getMessage());
        }
    }

    private static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

        static final ObservableList<Difficulty> items;

        static Difficulty of(int d) {
            return d >= 0 && d < items.size() ? (Difficulty)((Object)items.get(d)) : null;
        }

        public String toString() {
            return I18n.i18n("world.info.difficulty." + this.name().toLowerCase(Locale.ROOT));
        }

        static {
            items = FXCollections.observableList(Arrays.asList(Difficulty.values()));
        }
    }

    private static enum GameType {
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        SPECTATOR,
        HARDCORE;

        static final ObservableList<GameType> items;

        static GameType of(int d, boolean hardcore) {
            if (hardcore && d == 0) {
                return HARDCORE;
            }
            return d >= 0 && d < 4 ? (GameType)((Object)items.get(d)) : null;
        }

        public String toString() {
            return I18n.i18n("world.info.player.game_type." + this.name().toLowerCase(Locale.ROOT));
        }

        static {
            items = FXCollections.observableList(Arrays.asList(GameType.values()));
        }
    }

    private record Dimension(String name) {
        static final Dimension OVERWORLD = new Dimension(null);
        static final Dimension THE_NETHER = new Dimension(I18n.i18n("world.info.dimension.the_nether"));
        static final Dimension THE_END = new Dimension(I18n.i18n("world.info.dimension.the_end"));

        static Dimension of(Tag tag) {
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                return switch (intTag.getValue()) {
                    case 0 -> OVERWORLD;
                    case 1 -> THE_NETHER;
                    case 2 -> THE_END;
                    default -> null;
                };
            }
            if (tag instanceof StringTag) {
                String id;
                StringTag stringTag = (StringTag)tag;
                return switch (id = stringTag.getValue()) {
                    case "overworld", "minecraft:overworld" -> OVERWORLD;
                    case "the_nether", "minecraft:the_nether" -> THE_NETHER;
                    case "the_end", "minecraft:the_end" -> THE_END;
                    default -> new Dimension(id);
                };
            }
            return null;
        }

        String formatPosition(Tag tag) {
            ListTag listTag;
            if (tag instanceof ListTag && (listTag = (ListTag)tag).size() == 3) {
                Object x = listTag.get(0);
                Object y = listTag.get(1);
                Object z = listTag.get(2);
                if (x instanceof DoubleTag && y instanceof DoubleTag && z instanceof DoubleTag) {
                    return this == OVERWORLD ? String.format("(%.2f, %.2f, %.2f)", ((Tag)x).getValue(), ((Tag)y).getValue(), ((Tag)z).getValue()) : String.format("%s (%.2f, %.2f, %.2f)", this.name, ((Tag)x).getValue(), ((Tag)y).getValue(), ((Tag)z).getValue());
                }
                return null;
            }
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int x = intArrayTag.getValue(0);
                int y = intArrayTag.getValue(1);
                int z = intArrayTag.getValue(2);
                return this == OVERWORLD ? String.format("(%d, %d, %d)", x, y, z) : String.format("%s (%d, %d, %d)", this.name, x, y, z);
            }
            return null;
        }

        String formatPosition(int x, int y, int z) {
            return this == OVERWORLD ? String.format("(%d, %d, %d)", x, y, z) : String.format("%s (%d, %d, %d)", this.name, x, y, z);
        }

        String formatPosition(double x, double y, double z) {
            return this == OVERWORLD ? String.format("(%.2f, %.2f, %.2f)", x, y, z) : String.format("%s (%.2f, %.2f, %.2f)", this.name, x, y, z);
        }
    }
}

