/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXPopup;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldBackupsPage;
import org.jackhuang.hmcl.ui.versions.WorldInfoPage;
import org.jackhuang.hmcl.ui.versions.WorldManageUIUtils;
import org.jackhuang.hmcl.util.ChunkBaseApp;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class WorldManagePage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final ObjectProperty<DecoratorPage.State> state;
    private final World world;
    private final Path backupsDir;
    private final Profile profile;
    private final String id;
    private boolean loadFailed = false;
    private final TabHeader header;
    private final TabControl.Tab<WorldInfoPage> worldInfoTab = new TabControl.Tab("worldInfoPage");
    private final TabControl.Tab<WorldBackupsPage> worldBackupsTab = new TabControl.Tab("worldBackupsPage");
    private final TabControl.Tab<DatapackListPage> datapackTab = new TabControl.Tab("datapackListPage");
    private final TransitionPane transitionPane = new TransitionPane();
    private FileChannel sessionLockChannel;

    public WorldManagePage(World world, Path backupsDir, Profile profile, String id) {
        this.world = world;
        this.backupsDir = backupsDir;
        this.profile = profile;
        this.id = id;
        this.sessionLockChannel = WorldManageUIUtils.getSessionLockChannel(world);
        try {
            world.reloadLevelDat();
        }
        catch (IOException e) {
            Logger.LOG.warning("Can not load world level.dat of world: " + String.valueOf(world.getFile()), e);
            this.loadFailed = true;
        }
        this.worldInfoTab.setNodeSupplier(() -> new WorldInfoPage(this));
        this.worldBackupsTab.setNodeSupplier(() -> new WorldBackupsPage(this));
        this.datapackTab.setNodeSupplier(() -> new DatapackListPage(this));
        this.state = new SimpleObjectProperty((Object)DecoratorPage.State.fromTitle(I18n.i18n("world.manage.title", StringUtils.parseColorEscapes(world.getWorldName()))));
        this.header = new TabHeader(this.transitionPane, this.worldInfoTab, this.worldBackupsTab);
        this.header.select(this.worldInfoTab);
        this.setCenter(new Node[]{this.transitionPane});
        BorderPane left = new BorderPane();
        FXUtils.setLimitWidth((Region)left, 200.0);
        VBox.setVgrow((Node)left, (Priority)Priority.ALWAYS);
        this.setLeft(new Node[]{left});
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerTab(this.header, this.worldInfoTab, I18n.i18n("world.info"), SVG.INFO, SVG.INFO_FILL).addNavigationDrawerTab(this.header, this.worldBackupsTab, I18n.i18n("world.backup"), SVG.ARCHIVE, SVG.ARCHIVE_FILL);
        if (world.getGameVersion() != null && world.getGameVersion().isAtLeast("1.13", "17w43a")) {
            this.header.getTabs().add(this.datapackTab);
            sideBar.addNavigationDrawerTab(this.header, this.datapackTab, I18n.i18n("world.datapack"), SVG.EXTENSION, SVG.EXTENSION_FILL);
        }
        left.setTop((Node)sideBar);
        AdvancedListBox toolbar = new AdvancedListBox();
        if (world.getGameVersion() != null && world.getGameVersion().isAtLeast("1.20", "23w14a")) {
            toolbar.addNavigationDrawerItem(I18n.i18n("version.launch"), SVG.ROCKET_LAUNCH, this::launch, advancedListItem -> advancedListItem.setDisable(this.isReadOnly()));
        }
        if (ChunkBaseApp.isSupported(world)) {
            PopupMenu chunkBasePopupMenu = new PopupMenu();
            JFXPopup chunkBasePopup = new JFXPopup((Region)chunkBasePopupMenu);
            chunkBasePopupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.EXPLORE, I18n.i18n("world.chunkbase.seed_map"), () -> ChunkBaseApp.openSeedMap(world), chunkBasePopup), new IconedMenuItem(SVG.VISIBILITY, I18n.i18n("world.chunkbase.stronghold"), () -> ChunkBaseApp.openStrongholdFinder(world), chunkBasePopup), new IconedMenuItem(SVG.FORT, I18n.i18n("world.chunkbase.nether_fortress"), () -> ChunkBaseApp.openNetherFortressFinder(world), chunkBasePopup)});
            if (world.getGameVersion() != null && world.getGameVersion().compareTo("1.13") >= 0) {
                chunkBasePopupMenu.getContent().add((Object)new IconedMenuItem(SVG.LOCATION_CITY, I18n.i18n("world.chunkbase.end_city"), () -> ChunkBaseApp.openEndCityFinder(world), chunkBasePopup));
            }
            toolbar.addNavigationDrawerItem(I18n.i18n("world.chunkbase"), SVG.EXPLORE, null, chunkBaseMenuItem -> chunkBaseMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> chunkBasePopup.show((Node)chunkBaseMenuItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, chunkBaseMenuItem.getWidth(), 0.0))));
        }
        toolbar.addNavigationDrawerItem(I18n.i18n("settings.game.exploration"), SVG.FOLDER_OPEN, () -> FXUtils.openFolder(world.getFile()), null);
        PopupMenu managePopupMenu = new PopupMenu();
        JFXPopup managePopup = new JFXPopup((Region)managePopupMenu);
        if (world.getGameVersion() != null && world.getGameVersion().isAtLeast("1.20", "23w14a")) {
            managePopupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.ROCKET_LAUNCH, I18n.i18n("version.launch"), this::launch, managePopup), new IconedMenuItem(SVG.SCRIPT, I18n.i18n("version.launch_script"), this::generateLaunchScript, managePopup), new MenuSeparator()});
        }
        managePopupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.OUTPUT, I18n.i18n("world.export"), () -> WorldManageUIUtils.export(world, this.sessionLockChannel), managePopup), new IconedMenuItem(SVG.DELETE, I18n.i18n("world.delete"), () -> WorldManageUIUtils.delete(world, () -> this.fireEvent(new PageCloseEvent()), this.sessionLockChannel), managePopup), new IconedMenuItem(SVG.CONTENT_COPY, I18n.i18n("world.duplicate"), () -> WorldManageUIUtils.copyWorld(world, null), managePopup)});
        toolbar.addNavigationDrawerItem(I18n.i18n("settings.game.management"), SVG.MENU, null, managePopupMenuItem -> {
            managePopupMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> managePopup.show((Node)managePopupMenuItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, managePopupMenuItem.getWidth(), 0.0)));
            managePopupMenuItem.setDisable(this.isReadOnly());
        });
        BorderPane.setMargin((Node)toolbar, (Insets)new Insets(0.0, 0.0, 12.0, 0.0));
        left.setBottom((Node)toolbar);
        this.addEventHandler(Navigator.NavigationEvent.EXITED, this::onExited);
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onNavigated);
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (this.loadFailed) {
            Platform.runLater(() -> {
                this.fireEvent(new PageCloseEvent());
                Controllers.dialog(I18n.i18n("world.load.fail"), null, MessageDialogPane.MessageType.ERROR);
            });
            return;
        }
        if (this.sessionLockChannel == null || !this.sessionLockChannel.isOpen()) {
            this.sessionLockChannel = WorldManageUIUtils.getSessionLockChannel(this.world);
        }
    }

    public void onExited(Navigator.NavigationEvent event) {
        try {
            WorldManageUIUtils.closeSessionLockChannel(this.world, this.sessionLockChannel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public World getWorld() {
        return this.world;
    }

    public Path getBackupsDir() {
        return this.backupsDir;
    }

    public boolean isReadOnly() {
        return this.sessionLockChannel == null;
    }

    public void launch() {
        this.fireEvent(new PageCloseEvent());
        Versions.launchAndEnterWorld(this.profile, this.id, this.world.getFileName());
    }

    public void generateLaunchScript() {
        Versions.generateLaunchScriptForQuickEnterWorld(this.profile, this.id, this.world.getFileName());
    }
}

