/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OSVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativePatcher {
    private static final Library NONEXISTENT_LIBRARY = new Library(null);
    private static final Map<Platform, Map<String, Library>> natives = new HashMap<Platform, Map<String, Library>>();

    private static Map<String, Library> getNatives(Platform platform) {
        return natives.computeIfAbsent(platform, p -> {
            Map map;
            InputStreamReader reader = new InputStreamReader(NativePatcher.class.getResourceAsStream("/assets/natives.json"), StandardCharsets.UTF_8);
            try {
                Map<String, Map<String, Library>> natives = JsonUtils.GSON.fromJson((Reader)reader, JsonUtils.mapTypeOf(String.class, JsonUtils.mapTypeOf(String.class, Library.class)));
                map = natives.getOrDefault(p.toString(), Collections.emptyMap());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to load native library list", e);
                    return Collections.emptyMap();
                }
            }
            ((Reader)reader).close();
            return map;
        });
    }

    public static Version patchNative(DefaultGameRepository repository, Version version, String gameVersion, JavaRuntime javaVersion, VersionSetting settings, List<String> javaArguments) {
        GameVersionNumber gameVersionNumber;
        if (settings.getNativesDirType() == NativesDirectoryType.CUSTOM) {
            if (gameVersion != null && GameVersionNumber.compare(gameVersion, "1.19") < 0) {
                return version;
            }
            ArrayList<Library> newLibraries = new ArrayList<Library>();
            for (Library library2 : version.getLibraries()) {
                if (!library2.appliesToCurrentEnvironment() || library2.getClassifier() != null && library2.getArtifactId().startsWith("lwjgl") && library2.getClassifier().startsWith("natives")) continue;
                newLibraries.add(library2);
            }
            return version.setLibraries(newLibraries);
        }
        boolean useNativeGLFW = settings.isUseNativeGLFW();
        boolean useNativeOpenAL = settings.isUseNativeOpenAL();
        if (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && (useNativeGLFW || useNativeOpenAL) && gameVersion != null && GameVersionNumber.compare(gameVersion, "1.19") >= 0) {
            version = version.setLibraries(version.getLibraries().stream().filter(library -> {
                if (library.getClassifier() != null && library.getClassifier().startsWith("natives") && "org.lwjgl".equals(library.getGroupId()) && (useNativeGLFW && "lwjgl-glfw".equals(library.getArtifactId()) || useNativeOpenAL && "lwjgl-openal".equals(library.getArtifactId()))) {
                    Logger.LOG.info("Filter out " + library.getName());
                    return false;
                }
                return true;
            }).collect(Collectors.toList()));
        }
        OperatingSystem os = javaVersion.getPlatform().getOperatingSystem();
        Architecture arch = javaVersion.getArchitecture();
        GameVersionNumber gameVersionNumber2 = gameVersionNumber = gameVersion != null ? GameVersionNumber.asGameVersion(gameVersion) : null;
        if (settings.isNotPatchNatives()) {
            return version;
        }
        if (arch.isX86() && (os == OperatingSystem.WINDOWS || os == OperatingSystem.LINUX || os == OperatingSystem.MACOS)) {
            return version;
        }
        if (arch == Architecture.ARM64 && (os == OperatingSystem.MACOS || os == OperatingSystem.WINDOWS) && gameVersionNumber != null && gameVersionNumber.compareTo("1.19") >= 0) {
            return version;
        }
        Map<String, Library> replacements = NativePatcher.getNatives(javaVersion.getPlatform());
        if (replacements.isEmpty()) {
            Logger.LOG.warning("No alternative native library provided for platform " + String.valueOf(javaVersion.getPlatform()));
            return version;
        }
        boolean lwjglVersionChanged = false;
        ArrayList<Library> newLibraries = new ArrayList<Library>();
        for (Library library2 : version.getLibraries()) {
            Library replacement;
            if (!library2.appliesToCurrentEnvironment()) continue;
            if (library2.isNative()) {
                replacement = replacements.getOrDefault(library2.getName() + ":natives", NONEXISTENT_LIBRARY);
                if (replacement == NONEXISTENT_LIBRARY) {
                    Logger.LOG.warning("No alternative native library " + library2.getName() + ":natives provided for platform " + String.valueOf(javaVersion.getPlatform()));
                    newLibraries.add(library2);
                    continue;
                }
                if (replacement == null) continue;
                Logger.LOG.info("Replace " + library2.getName() + ":natives with " + replacement.getName());
                newLibraries.add(replacement);
                continue;
            }
            replacement = replacements.getOrDefault(library2.getName(), NONEXISTENT_LIBRARY);
            if (replacement == NONEXISTENT_LIBRARY) {
                newLibraries.add(library2);
                continue;
            }
            if (replacement == null) continue;
            Logger.LOG.info("Replace " + library2.getName() + " with " + replacement.getName());
            newLibraries.add(replacement);
            if (!"org.lwjgl:lwjgl".equals(library2.getName()) || Objects.equals(library2.getVersion(), replacement.getVersion())) continue;
            lwjglVersionChanged = true;
        }
        if (lwjglVersionChanged) {
            ModManager modManager = repository.getModManager(version.getId());
            try {
                for (LocalModFile mod : modManager.getMods()) {
                    if (!"sodium".equals(mod.getId())) continue;
                    javaArguments.add("-Dsodium.checks.issue2561=false");
                    break;
                }
            }
            catch (Throwable throwable) {
                Logger.LOG.warning("Failed to get mods", throwable);
            }
        }
        return version.setLibraries(newLibraries);
    }

    @Nullable
    public static Library getWindowsMesaLoader(@NotNull JavaRuntime javaVersion, @NotNull Renderer renderer, @NotNull OSVersion windowsVersion) {
        if (renderer == Renderer.DEFAULT) {
            return null;
        }
        if (windowsVersion.isAtLeast(OSVersion.WINDOWS_10)) {
            return NativePatcher.getNatives(javaVersion.getPlatform()).get("mesa-loader");
        }
        if (windowsVersion.isAtLeast(OSVersion.WINDOWS_7)) {
            if (renderer == Renderer.LLVMPIPE) {
                return NativePatcher.getNatives(javaVersion.getPlatform()).get("software-renderer-loader");
            }
            return null;
        }
        return null;
    }

    public static SupportStatus checkSupportedStatus(GameVersionNumber gameVersion, Platform platform, OSVersion systemVersion) {
        if (platform.equals(Platform.WINDOWS_X86_64)) {
            if (!systemVersion.isAtLeast(OSVersion.WINDOWS_10) && gameVersion.isAtLeast("1.20.5", "24w14a")) {
                return SupportStatus.UNSUPPORTED;
            }
            return SupportStatus.OFFICIAL_SUPPORTED;
        }
        if (platform.equals(Platform.MACOS_X86_64) || platform.equals(Platform.LINUX_X86_64)) {
            return SupportStatus.OFFICIAL_SUPPORTED;
        }
        if (platform.equals(Platform.WINDOWS_X86) || platform.equals(Platform.LINUX_X86)) {
            if (gameVersion.isAtLeast("1.20.5", "24w14a")) {
                return SupportStatus.UNSUPPORTED;
            }
            return SupportStatus.OFFICIAL_SUPPORTED;
        }
        if (platform.equals(Platform.WINDOWS_ARM64) || platform.equals(Platform.MACOS_ARM64)) {
            if (gameVersion.compareTo("1.19") >= 0) {
                return SupportStatus.OFFICIAL_SUPPORTED;
            }
            String minVersion = platform.getOperatingSystem() == OperatingSystem.WINDOWS ? "1.8" : "1.6";
            return gameVersion.compareTo(minVersion) >= 0 ? SupportStatus.LAUNCHER_SUPPORTED : SupportStatus.TRANSLATION_SUPPORTED;
        }
        String minVersion = null;
        String maxVersion = null;
        if (platform.equals(Platform.FREEBSD_X86_64)) {
            minVersion = "1.13";
        } else if (platform.equals(Platform.LINUX_ARM64)) {
            minVersion = "1.6";
        } else if (platform.equals(Platform.LINUX_RISCV64)) {
            minVersion = "1.8";
            maxVersion = "1.21.5";
        } else if (platform.equals(Platform.LINUX_LOONGARCH64)) {
            minVersion = "1.6";
        } else if (platform.equals(Platform.LINUX_LOONGARCH64_OW)) {
            minVersion = "1.6";
            maxVersion = "1.20.1";
        } else if (platform.equals(Platform.LINUX_MIPS64EL) || platform.equals(Platform.LINUX_ARM32)) {
            minVersion = "1.8";
            maxVersion = "1.20.1";
        }
        if (minVersion != null) {
            if (gameVersion.compareTo(minVersion) >= 0) {
                if (maxVersion != null && gameVersion.compareTo(maxVersion) > 0) {
                    return SupportStatus.UNSUPPORTED;
                }
                String[] defaultGameVersions = GameVersionNumber.getDefaultGameVersions();
                if (defaultGameVersions.length > 0 && gameVersion.compareTo(defaultGameVersions[0]) > 0) {
                    return SupportStatus.UNTESTED;
                }
                return SupportStatus.LAUNCHER_SUPPORTED;
            }
            return SupportStatus.UNSUPPORTED;
        }
        return SupportStatus.UNTESTED;
    }

    private NativePatcher() {
    }

    public static enum SupportStatus {
        OFFICIAL_SUPPORTED,
        LAUNCHER_SUPPORTED,
        TRANSLATION_SUPPORTED,
        UNTESTED,
        UNSUPPORTED;

    }
}

