/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet.prober;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.glavo.chardet.DetectedCharset;
import org.glavo.chardet.prober.CharsetProber;
import org.glavo.chardet.prober.HebrewProber;
import org.glavo.chardet.prober.SingleByteCharsetProber;
import org.glavo.chardet.prober.sequence.HebrewModel;
import org.glavo.chardet.prober.sequence.IBM855Model;
import org.glavo.chardet.prober.sequence.IBM866Model;
import org.glavo.chardet.prober.sequence.KOI8RModel;
import org.glavo.chardet.prober.sequence.Latin5BulgarianModel;
import org.glavo.chardet.prober.sequence.Latin5Model;
import org.glavo.chardet.prober.sequence.Latin7Model;
import org.glavo.chardet.prober.sequence.MacCyrillicModel;
import org.glavo.chardet.prober.sequence.ThaiModel;
import org.glavo.chardet.prober.sequence.Win1251BulgarianModel;
import org.glavo.chardet.prober.sequence.Win1251Model;
import org.glavo.chardet.prober.sequence.Win1253Model;

public final class SBCSGroupProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private final List<CharsetProber> probers = new ArrayList<CharsetProber>();
    private CharsetProber bestGuess;
    private int activeNum;

    public SBCSGroupProber() {
        this.probers.add(new SingleByteCharsetProber(new Win1251Model()));
        this.probers.add(new SingleByteCharsetProber(new KOI8RModel()));
        this.probers.add(new SingleByteCharsetProber(new Latin5Model()));
        this.probers.add(new SingleByteCharsetProber(new MacCyrillicModel()));
        this.probers.add(new SingleByteCharsetProber(new IBM866Model()));
        this.probers.add(new SingleByteCharsetProber(new IBM855Model()));
        this.probers.add(new SingleByteCharsetProber(new Latin7Model()));
        this.probers.add(new SingleByteCharsetProber(new Win1253Model()));
        this.probers.add(new SingleByteCharsetProber(new Latin5BulgarianModel()));
        this.probers.add(new SingleByteCharsetProber(new Win1251BulgarianModel()));
        this.probers.add(new SingleByteCharsetProber(new ThaiModel()));
        HebrewModel hebrewModel = new HebrewModel();
        HebrewProber hebprober = new HebrewProber();
        SingleByteCharsetProber singleByte1 = new SingleByteCharsetProber(hebrewModel, false, hebprober);
        SingleByteCharsetProber singleByte2 = new SingleByteCharsetProber(hebrewModel, true, hebprober);
        hebprober.setModalProbers(singleByte1, singleByte2);
        this.probers.add(hebprober);
        this.probers.add(singleByte1);
        this.probers.add(singleByte2);
        this.reset();
    }

    @Override
    public DetectedCharset getCharset() {
        if (this.bestGuess == null) {
            this.getConfidence();
            if (this.bestGuess == null) {
                this.bestGuess = this.probers.get(0);
            }
        }
        return this.bestGuess.getCharset();
    }

    @Override
    public float getConfidence() {
        float bestConf = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        for (CharsetProber prober : this.probers) {
            float cf;
            if (!prober.isActive() || !(bestConf < (cf = prober.getConfidence()))) continue;
            bestConf = cf;
            this.bestGuess = prober;
        }
        return bestConf;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(ByteBuffer buf, int offset, int length) {
        ByteBuffer newbuf = this.filterWithoutEnglishLetters(buf, offset, length);
        if (newbuf.position() != 0) {
            for (CharsetProber prober : this.probers) {
                if (!prober.isActive()) continue;
                CharsetProber.ProbingState st = prober.handleData(newbuf, 0, newbuf.position());
                if (st == CharsetProber.ProbingState.FOUND_IT || 0.99f == prober.getConfidence()) {
                    this.bestGuess = prober;
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                    break;
                }
                if (st != CharsetProber.ProbingState.NOT_ME) continue;
                prober.setActive(false);
                --this.activeNum;
                if (this.activeNum > 0) continue;
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
        }
        return this.state;
    }

    @Override
    public final void reset() {
        this.activeNum = 0;
        for (CharsetProber prober : this.probers) {
            prober.reset();
            prober.setActive(true);
            ++this.activeNum;
        }
        this.bestGuess = null;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void setOption() {
    }
}

