/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.opennbt;

import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongArrayTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.github.steveice10.opennbt.tag.builtin.custom.DoubleArrayTag;
import com.github.steveice10.opennbt.tag.builtin.custom.FloatArrayTag;
import com.github.steveice10.opennbt.tag.builtin.custom.ShortArrayTag;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.util.regex.Pattern;

public class SNBTIO {
    public static CompoundTag readFile(String path) throws IOException {
        return SNBTIO.readFile(new File(path));
    }

    public static CompoundTag readFile(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            Tag tag = SNBTIO.readTag(in);
            if (!(tag instanceof CompoundTag)) {
                throw new IOException("Root tag is not a CompoundTag!");
            }
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag;
        }
    }

    public static void writeFile(CompoundTag tag, String path) throws IOException {
        SNBTIO.writeFile(tag, new File(path));
    }

    public static void writeFile(CompoundTag tag, File file) throws IOException {
        SNBTIO.writeFile(tag, file, false);
    }

    public static void writeFile(CompoundTag tag, String path, boolean linebreak) throws IOException {
        SNBTIO.writeFile(tag, new File(path), linebreak);
    }

    public static void writeFile(CompoundTag tag, File file, boolean linebreak) throws IOException {
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            SNBTIO.writeTag(out, tag, linebreak);
        }
    }

    public static Tag readTag(InputStream in) throws IOException {
        try (StringifiedNBTReader reader = new StringifiedNBTReader(in);){
            Tag tag = reader.readNextTag("");
            return tag;
        }
    }

    public static void writeTag(OutputStream out, Tag tag) throws IOException {
        SNBTIO.writeTag(out, tag, false);
    }

    public static void writeTag(OutputStream out, Tag tag, boolean linebreak) throws IOException {
        try (StringifiedNBTWriter writer = new StringifiedNBTWriter(out);){
            writer.writeTag(tag, linebreak);
        }
    }

    public static class StringifiedNBTWriter
    extends OutputStreamWriter {
        public static Pattern nonEscapedTagName = Pattern.compile("(?!\\d+)[\\w\\d]*");

        public StringifiedNBTWriter(OutputStream out) {
            super(out);
        }

        public void writeTag(Tag tag, boolean linebreak) throws IOException {
            this.writeTag(tag, linebreak, 0);
            this.flush();
        }

        public void writeTag(Tag tag, boolean linebreak, int depth) throws IOException {
            if (linebreak && depth > 0) {
                this.append('\n');
                this.indent(depth);
            }
            if (tag.getName() != null && !tag.getName().equals("")) {
                this.appendTagName(tag.getName());
                this.append(':');
                this.append(' ');
            }
            if (tag instanceof CompoundTag) {
                tag.stringify(this, linebreak, depth);
            } else if (tag instanceof ListTag) {
                tag.stringify(this, linebreak, depth);
            } else {
                tag.stringify(this, linebreak, depth);
            }
        }

        public void appendTagName(String tagName) throws IOException {
            if (!nonEscapedTagName.matcher(tagName).matches()) {
                this.append('\"');
                this.append(tagName.replaceAll("\\\"", "\\\""));
                this.append('\"');
            } else {
                this.append(tagName);
            }
        }

        public void indent(int depth) throws IOException {
            for (int i = 0; i < depth; ++i) {
                this.append('\t');
            }
        }
    }

    public static class StringifiedNBTReader
    extends PushbackReader {
        static final Pattern byteTagValuePattern = Pattern.compile("[-+]?\\d+[bB]");
        static final Pattern doubleTagValuePattern = Pattern.compile("[-+]?((\\d+(\\.\\d*)?)|(\\.\\d+))[dD]");
        static final Pattern floatTagValuePattern = Pattern.compile("[-+]?((\\d+(\\.\\d*)?)|(\\.\\d+))[fF]");
        static final Pattern intTagValuePattern = Pattern.compile("[-+]?\\d+");
        static final Pattern longTagValuePattern = Pattern.compile("[-+]?\\d+[lL]");
        static final Pattern shortTagValuePattern = Pattern.compile("[-+]?\\d+[sS]");

        public StringifiedNBTReader(InputStream in) {
            super(new InputStreamReader(in), 32);
        }

        public Tag readNextTag(String name) throws IOException {
            this.skipWhitespace();
            if (this.lookAhead(0) == '{') {
                return this.readCompoundTag(name);
            }
            if (this.lookAhead(0) == '[') {
                return this.readListOrArrayTag(name);
            }
            return this.readPrimitiveTag(name);
        }

        public Tag readCompoundTag(String name) throws IOException {
            return this.parseTag(new CompoundTag(name));
        }

        private Tag readListOrArrayTag(String name) throws IOException {
            if (this.lookAhead(2) == ';') {
                switch (this.lookAhead(1)) {
                    case 'B': {
                        return this.parseTag(new ByteArrayTag(name));
                    }
                    case 'S': {
                        return this.parseTag(new ShortArrayTag(name));
                    }
                    case 'I': {
                        return this.parseTag(new IntArrayTag(name));
                    }
                    case 'L': {
                        return this.parseTag(new LongArrayTag(name));
                    }
                    case 'F': {
                        return this.parseTag(new FloatArrayTag(name));
                    }
                    case 'D': {
                        return this.parseTag(new DoubleArrayTag(name));
                    }
                }
            }
            return this.parseTag(new ListTag(name));
        }

        private Tag readPrimitiveTag(String name) throws IOException {
            String valueString = this.readNextSingleValueString(32);
            this.unread(valueString.toCharArray());
            return this.parseTag(this.getTagForStringifiedValue(name, valueString));
        }

        public String readNextSingleValueString() throws IOException {
            return this.readNextSingleValueString(Integer.MAX_VALUE);
        }

        public String readNextSingleValueString(int maxReadLenght) throws IOException {
            String valueString;
            if (this.lookAhead(0) == '\'' || this.lookAhead(0) == '\"') {
                char c = (char)this.read();
                valueString = c + this.readUntil(maxReadLenght, true, c);
            } else {
                valueString = this.readUntil(maxReadLenght, false, ',', '}', ']', '\r', '\n', '\t');
            }
            return valueString;
        }

        private Tag getTagForStringifiedValue(String name, String stringifiedValue) {
            if (byteTagValuePattern.matcher(stringifiedValue).matches()) {
                return new ByteTag(name);
            }
            if (doubleTagValuePattern.matcher(stringifiedValue).matches()) {
                return new DoubleTag(name);
            }
            if (floatTagValuePattern.matcher(stringifiedValue).matches()) {
                return new FloatTag(name);
            }
            if (intTagValuePattern.matcher(stringifiedValue).matches()) {
                return new IntTag(name);
            }
            if (longTagValuePattern.matcher(stringifiedValue).matches()) {
                return new LongTag(name);
            }
            if (shortTagValuePattern.matcher(stringifiedValue).matches()) {
                return new ShortTag(name);
            }
            return new StringTag(name);
        }

        public Tag parseTag(Tag tag) throws IOException {
            tag.destringify(this);
            return tag;
        }

        public void skipWhitespace() throws IOException {
            char c;
            while ((c = (char)this.read()) != '\uffffffff') {
                if (c == '\t' || c == '\r' || c == '\n' || c == ' ') continue;
                this.unread(c);
                return;
            }
        }

        public char readSkipWhitespace() throws IOException {
            this.skipWhitespace();
            return (char)this.read();
        }

        public String readUntil(boolean includeEndChar, char ... endChar) throws IOException {
            return this.readUntil(Integer.MAX_VALUE, includeEndChar, endChar);
        }

        public String readUntil(int maxReadLenght, boolean includeEndChar, char ... endChar) throws IOException {
            char c;
            StringBuilder sb = new StringBuilder();
            boolean escapeEnd = false;
            int reads = 0;
            while (++reads < maxReadLenght && (c = (char)this.read()) != '\uffffffff') {
                if (c == '\\') {
                    sb.append(c);
                    escapeEnd = true;
                    continue;
                }
                if (!escapeEnd && StringifiedNBTReader.matchesAny(c, endChar)) {
                    if (includeEndChar) {
                        sb.append(c);
                        break;
                    }
                    this.unread(c);
                    break;
                }
                sb.append(c);
                escapeEnd = false;
            }
            return sb.toString();
        }

        public char lookAhead(int offset) throws IOException {
            char[] future = new char[offset + 1];
            this.read(future);
            this.unread(future);
            return future[offset];
        }

        public static boolean matchesAny(char c, char[] matchable) {
            for (char m : matchable) {
                if (c != m) continue;
                return true;
            }
            return false;
        }
    }
}

