/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.StringArgument;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.VersionLibraryBuilder;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.SimpleMultimap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class MaintainTask
extends Task<Version> {
    private final GameRepository repository;
    private final Version version;

    public MaintainTask(GameRepository repository, Version version) {
        this.repository = repository;
        this.version = version;
        if (version.getInheritsFrom() != null) {
            throw new IllegalArgumentException("MaintainTask requires independent game version");
        }
    }

    @Override
    public void execute() {
        this.setResult(MaintainTask.maintain(this.repository, this.version));
    }

    public static Version maintain(GameRepository repository, Version version) {
        Library library;
        if (version.getInheritsFrom() != null) {
            throw new IllegalArgumentException("MaintainTask requires independent game version");
        }
        String mainClass = version.resolve(null).getMainClass();
        List<Library> libraries = (version = mainClass != null && mainClass.equals("net.minecraft.launchwrapper.Launch") ? MaintainTask.maintainOptiFineLibrary(repository, MaintainTask.maintainGameWithLaunchWrapper(repository, MaintainTask.unique(version), true), false) : (mainClass != null && mainClass.equals("cpw.mods.modlauncher.Launcher") ? MaintainTask.maintainOptiFineLibrary(repository, MaintainTask.maintainGameWithCpwModLauncher(repository, MaintainTask.unique(version)), true) : (mainClass != null && mainClass.equals("cpw.mods.bootstraplauncher.BootstrapLauncher") ? MaintainTask.maintainGameWithCpwBoostrapLauncher(repository, MaintainTask.unique(version)) : MaintainTask.maintainOptiFineLibrary(repository, MaintainTask.unique(version), false)))).getLibraries();
        if (!libraries.isEmpty() && "org.glavo".equals((library = libraries.get(0)).getGroupId()) && ("log4j-patch".equals(library.getArtifactId()) || "log4j-patch-beta9".equals(library.getArtifactId())) && "1.0".equals(library.getVersion()) && library.getDownload() == null) {
            version = version.setLibraries(libraries.subList(1, libraries.size()));
        }
        return version;
    }

    public static Version maintainPreservingPatches(GameRepository repository, Version version) {
        if (!version.isResolvedPreservingPatches()) {
            throw new IllegalArgumentException("MaintainTask requires independent game version");
        }
        Version newVersion = MaintainTask.maintain(repository, version.resolve(repository));
        return newVersion.setPatches(version.getPatches()).markAsUnresolved();
    }

    private static Version maintainGameWithLaunchWrapper(GameRepository repository, Version version, boolean reorderTweakClass) {
        LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version, null);
        VersionLibraryBuilder builder = new VersionLibraryBuilder(version);
        String mainClass = null;
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER) && !libraryAnalyzer.hasModLauncher()) {
            builder.replaceTweakClass("com.mumfrey.liteloader.launch.LiteLoaderTweaker", "com.mumfrey.liteloader.launch.LiteLoaderTweaker", !reorderTweakClass, reorderTweakClass);
        } else {
            builder.removeTweakClass("com.mumfrey.liteloader.launch.LiteLoaderTweaker");
        }
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
            if (!libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER) && !libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
                if (builder.hasTweakClass(LibraryAnalyzer.OPTIFINE_TWEAKERS[1])) {
                    builder.replaceTweakClass(LibraryAnalyzer.OPTIFINE_TWEAKERS[1], LibraryAnalyzer.OPTIFINE_TWEAKERS[0], !reorderTweakClass, reorderTweakClass);
                }
            } else if (libraryAnalyzer.hasModLauncher()) {
                mainClass = "cpw.mods.modlauncher.Launcher";
                for (String optiFineTweaker : LibraryAnalyzer.OPTIFINE_TWEAKERS) {
                    builder.removeTweakClass(optiFineTweaker);
                }
            } else if (builder.hasTweakClass(LibraryAnalyzer.OPTIFINE_TWEAKERS[0])) {
                builder.replaceTweakClass(LibraryAnalyzer.OPTIFINE_TWEAKERS[0], LibraryAnalyzer.OPTIFINE_TWEAKERS[1], !reorderTweakClass, reorderTweakClass);
            }
        } else {
            for (String optiFineTweaker : LibraryAnalyzer.OPTIFINE_TWEAKERS) {
                builder.removeTweakClass(optiFineTweaker);
            }
        }
        boolean hasForge = libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        boolean hasModLauncher = libraryAnalyzer.hasModLauncher();
        for (String forgeTweaker : LibraryAnalyzer.FORGE_TWEAKERS) {
            if (!hasForge) {
                builder.removeTweakClass(forgeTweaker);
                continue;
            }
            if (hasModLauncher || !builder.hasTweakClass(forgeTweaker)) continue;
            builder.replaceTweakClass(forgeTweaker, forgeTweaker, !reorderTweakClass, reorderTweakClass);
        }
        Version ret = builder.build();
        return mainClass == null ? ret : ret.setMainClass(mainClass);
    }

    private static Version maintainGameWithCpwModLauncher(GameRepository repository, Version version) {
        LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version, null);
        VersionLibraryBuilder builder = new VersionLibraryBuilder(version);
        if (!libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
            return version;
        }
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
            Library hmclTransformerDiscoveryService = new Library(new Artifact("org.jackhuang.hmcl", "transformer-discovery-service", "1.0"));
            Optional<Library> optiFine = version.getLibraries().stream().filter(library -> library.is("optifine", "OptiFine")).findAny();
            boolean libraryExisting = version.getLibraries().stream().anyMatch(library -> library.is("org.jackhuang.hmcl", "transformer-discovery-service"));
            optiFine.ifPresent(library -> {
                builder.addJvmArgument("-Dhmcl.transformer.candidates=${library_directory}/" + library.getPath());
                if (!libraryExisting) {
                    builder.addLibrary(hmclTransformerDiscoveryService);
                }
                Path libraryPath = repository.getLibraryFile(version, hmclTransformerDiscoveryService);
                try (InputStream input = MaintainTask.class.getResourceAsStream("/assets/game/HMCLTransformerDiscoveryService-1.0.jar");){
                    Files.createDirectories(libraryPath.getParent(), new FileAttribute[0]);
                    Files.copy(Objects.requireNonNull(input, "Bundled HMCLTransformerDiscoveryService is missing."), libraryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException | NullPointerException e) {
                    Logger.LOG.warning("Unable to unpack HMCLTransformerDiscoveryService", e);
                }
            });
        }
        return builder.build();
    }

    private static String updateIgnoreList(GameRepository repository, Version version, String ignoreList) {
        String[] ignores = ignoreList.split(",");
        ArrayList<String> newIgnoreList = new ArrayList<String>();
        newIgnoreList.add("${primary_jar}");
        Path libraryDirectory = repository.getLibrariesDirectory(version).toAbsolutePath().normalize();
        for (String classpathName : repository.getClasspath(version)) {
            Path classpathFile = Paths.get(classpathName, new String[0]).toAbsolutePath();
            String fileName = classpathFile.getFileName().toString();
            if (!Stream.of(ignores).anyMatch(fileName::contains)) continue;
            Object absolutePath = classpathFile.startsWith(libraryDirectory) ? "${library_directory}${file_separator}" + libraryDirectory.relativize(classpathFile).toString().replace(File.separator, "${file_separator}") : classpathFile.toString();
            newIgnoreList.add(StringUtils.substringBefore((String)absolutePath, ","));
        }
        return String.join((CharSequence)",", newIgnoreList);
    }

    private static Version maintainGameWithCpwBoostrapLauncher(GameRepository repository, Version version) {
        VersionLibraryBuilder builder;
        block5: {
            LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version, null);
            builder = new VersionLibraryBuilder(version);
            if (!libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE) && !libraryAnalyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE)) {
                return version;
            }
            Optional<String> bslVersion = libraryAnalyzer.getVersion(LibraryAnalyzer.LibraryType.BOOTSTRAP_LAUNCHER);
            if (!bslVersion.isPresent()) break block5;
            if (VersionNumber.compare(bslVersion.get(), "0.1.17") < 0) {
                List<Argument> jvm = builder.getMutableJvmArguments();
                for (int i = 0; i < jvm.size(); ++i) {
                    String jvmArgStr;
                    Argument jvmArg = jvm.get(i);
                    if (!(jvmArg instanceof StringArgument) || !(jvmArgStr = jvmArg.toString()).startsWith("-DignoreList=")) continue;
                    jvm.set(i, new StringArgument("-DignoreList=" + MaintainTask.updateIgnoreList(repository, version, jvmArgStr.substring("-DignoreList=".length()))));
                }
            } else {
                List<Argument> jvm = builder.getMutableJvmArguments();
                for (int i = 0; i < jvm.size(); ++i) {
                    String jvmArgStr;
                    Argument jvmArg = jvm.get(i);
                    if (!(jvmArg instanceof StringArgument) || !(jvmArgStr = jvmArg.toString()).startsWith("-DignoreList=")) continue;
                    jvm.set(i, new StringArgument(jvmArgStr + ",${primary_jar_name}"));
                }
            }
        }
        return builder.build();
    }

    private static Version maintainOptiFineLibrary(GameRepository repository, Version version, boolean remove) {
        LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version, null);
        ArrayList<Library> libraries = new ArrayList<Library>(version.getLibraries());
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE) && (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER) || libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) && repository != null) {
            for (int i = 0; i < version.getLibraries().size(); ++i) {
                Library newLibrary;
                Library library = (Library)libraries.get(i);
                if (library.is("optifine", "OptiFine") && Files.exists(repository.getLibraryFile(version, newLibrary = new Library(new Artifact("optifine", "OptiFine", library.getVersion(), "installer"))), new LinkOption[0])) {
                    libraries.set(i, null);
                    if (!remove) {
                        libraries.add(newLibrary);
                    }
                }
                if (!library.is("optifine", "launchwrapper-of")) continue;
                libraries.set(i, null);
            }
        }
        return version.setLibraries(libraries.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static Version unique(Version version) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        SimpleMultimap<CallSite, Integer, List> multimap = new SimpleMultimap<CallSite, Integer, List>(HashMap::new, ArrayList::new);
        for (Library library : version.getLibraries()) {
            String id = library.getGroupId() + ":" + library.getArtifactId();
            VersionNumber number = VersionNumber.asVersion(library.getVersion());
            String serialized = JsonUtils.GSON.toJson(library);
            if (multimap.containsKey((CallSite)((Object)id))) {
                boolean duplicate = false;
                Iterator iterator = multimap.get((CallSite)((Object)id)).iterator();
                while (iterator.hasNext()) {
                    int otherLibraryIndex = (Integer)iterator.next();
                    Library otherLibrary = (Library)libraries.get(otherLibraryIndex);
                    VersionNumber otherNumber = VersionNumber.asVersion(otherLibrary.getVersion());
                    if (!CompatibilityRule.equals(library.getRules(), otherLibrary.getRules())) continue;
                    boolean flag = true;
                    if (number.compareTo(otherNumber) > 0) {
                        libraries.set(otherLibraryIndex, library);
                    } else if (number.compareTo(otherNumber) == 0) {
                        if (library.equals(otherLibrary)) {
                            String otherSerialized = JsonUtils.GSON.toJson(otherLibrary);
                            if (serialized.length() > otherSerialized.length()) {
                                libraries.set(otherLibraryIndex, library);
                            }
                        } else {
                            flag = false;
                        }
                    }
                    if (!flag) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                multimap.put((CallSite)((Object)id), libraries.size());
                libraries.add(library);
                continue;
            }
            multimap.put((CallSite)((Object)id), libraries.size());
            libraries.add(library);
        }
        return version.setLibraries(libraries);
    }
}

