/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta.provider;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaNative;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jetbrains.annotations.Nullable;

public final class MacOSProvider
implements ITerracottaProvider {
    public final TerracottaNative installer;
    public final TerracottaNative binary;

    public MacOSProvider(TerracottaNative installer, TerracottaNative binary) {
        this.installer = installer;
        this.binary = binary;
    }

    @Override
    public ITerracottaProvider.Status status() throws IOException {
        assert (this.binary != null);
        if (!Files.exists(Path.of("/Applications/terracotta.app", new String[0]), new LinkOption[0])) {
            return ITerracottaProvider.Status.NOT_EXIST;
        }
        return this.binary.status();
    }

    @Override
    public Task<?> install(ITerracottaProvider.Context context, @Nullable TarFileTree tree) throws IOException {
        assert (this.installer != null && this.binary != null);
        Task installerTask = this.installer.install(context, tree);
        Task<?> binaryTask = this.binary.install(context, tree);
        context.bindProgress((ObservableValue<? extends Number>)installerTask.progressProperty().add((ObservableNumberValue)binaryTask.progressProperty()).multiply(0.4));
        return Task.allOf(installerTask.thenComposeAsync(() -> {
            Path osascript = SystemUtils.which("osascript");
            if (osascript == null) {
                throw new IllegalStateException("Cannot locate 'osascript' system executable on MacOS for installing Terracotta.");
            }
            Path pkg = Files.createTempDirectory(Metadata.HMCL_GLOBAL_DIRECTORY, "terracotta-pkg", new FileAttribute[0]).toRealPath(new LinkOption[0]).resolve(FileUtils.getName(this.installer.getPath()));
            Files.copy(this.installer.getPath(), pkg, StandardCopyOption.REPLACE_EXISTING);
            ManagedProcess process = new ManagedProcess(new ProcessBuilder(osascript.toString(), "-e", String.format("do shell script \"installer -pkg '%s' -target /\" with prompt \"%s\" with administrator privileges", pkg, I18n.i18n("terracotta.sudo_installing"))));
            process.pumpInputStream(SystemUtils::onLogLine);
            process.pumpErrorStream(SystemUtils::onLogLine);
            return Task.fromCompletableFuture(process.getProcess().onExit()).thenRunAsync(() -> {
                try {
                    FileUtils.cleanDirectory(pkg.getParent());
                }
                catch (IOException e) {
                    Logger.LOG.warning("Cannot remove temporary Terracotta package file.", e);
                }
                if (process.getExitCode() != 0) {
                    throw new IllegalStateException(String.format("Cannot install Terracotta %s: system installer exited with code %d", pkg, process.getExitCode()));
                }
            });
        }), binaryTask.thenRunAsync(() -> Files.setPosixFilePermissions(this.binary.getPath(), Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE))));
    }

    @Override
    public List<String> ofCommandLine(Path path) {
        assert (this.binary != null);
        return List.of(this.binary.getPath().toString(), "--hmcl", path.toString());
    }
}

