/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix;

import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.stage.Screen;
import javafx.stage.Window;

public class Utils {
    private static Bounds getBounds(Object obj) {
        if (obj instanceof Node) {
            Node n = (Node)obj;
            Bounds b = n.localToScreen(n.getLayoutBounds());
            return b != null ? b : new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        if (obj instanceof Window) {
            Window window = (Window)obj;
            return new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        }
        return new BoundingBox(0.0, 0.0, 0.0, 0.0);
    }

    public static Screen getScreen(Object obj) {
        Bounds parentBounds = Utils.getBounds(obj);
        Rectangle2D rect = new Rectangle2D(parentBounds.getMinX(), parentBounds.getMinY(), parentBounds.getWidth(), parentBounds.getHeight());
        return Utils.getScreenForRectangle(rect);
    }

    public static Screen getScreenForRectangle(Rectangle2D rect) {
        ObservableList screens = Screen.getScreens();
        double rectX0 = rect.getMinX();
        double rectX1 = rect.getMaxX();
        double rectY0 = rect.getMinY();
        double rectY1 = rect.getMaxY();
        Screen selectedScreen = null;
        double maxIntersection = 0.0;
        for (Screen screen : screens) {
            Rectangle2D screenBounds = screen.getBounds();
            double intersection = Utils.getIntersectionLength(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX()) * Utils.getIntersectionLength(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY());
            if (!(maxIntersection < intersection)) continue;
            maxIntersection = intersection;
            selectedScreen = screen;
        }
        if (selectedScreen != null) {
            return selectedScreen;
        }
        selectedScreen = Screen.getPrimary();
        double minDistance = Double.MAX_VALUE;
        for (Screen screen : screens) {
            double dy;
            Rectangle2D screenBounds = screen.getBounds();
            double dx = Utils.getOuterDistance(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX());
            double distance = dx * dx + (dy = Utils.getOuterDistance(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY())) * dy;
            if (!(minDistance > distance)) continue;
            minDistance = distance;
            selectedScreen = screen;
        }
        return selectedScreen;
    }

    private static double getIntersectionLength(double a0, double a1, double b0, double b1) {
        return a0 <= b0 ? Utils.getIntersectionLengthImpl(b0, b1, a1) : Utils.getIntersectionLengthImpl(a0, a1, b1);
    }

    private static double getIntersectionLengthImpl(double v0, double v1, double v) {
        if (v <= v0) {
            return 0.0;
        }
        return v <= v1 ? v - v0 : v1 - v0;
    }

    private static double getOuterDistance(double a0, double a1, double b0, double b1) {
        if (a1 <= b0) {
            return b0 - a1;
        }
        if (b1 <= a0) {
            return b1 - a0;
        }
        return 0.0;
    }

    private static double getOuterDistance(double v0, double v1, double v) {
        if (v <= v0) {
            return v0 - v;
        }
        if (v >= v1) {
            return v - v1;
        }
        return 0.0;
    }
}

