/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.io.Unzipper;

public class ModpackInstallTask<T>
extends Task<Void> {
    private final Path modpackFile;
    private final Path dest;
    private final Charset charset;
    private final List<String> subDirectories;
    private final List<ModpackConfiguration.FileInformation> overrides;
    private final Predicate<String> callback;

    public ModpackInstallTask(Path modpackFile, Path dest, Charset charset, List<String> subDirectories, Predicate<String> callback, ModpackConfiguration<T> oldConfiguration) {
        this.modpackFile = modpackFile;
        this.dest = dest;
        this.charset = charset;
        this.subDirectories = subDirectories;
        this.callback = callback;
        this.overrides = oldConfiguration == null ? Collections.emptyList() : oldConfiguration.getOverrides();
    }

    @Override
    public void execute() throws Exception {
        HashSet entries = new HashSet();
        Files.createDirectories(this.dest, new FileAttribute[0]);
        HashMap<String, ModpackConfiguration.FileInformation> files = new HashMap<String, ModpackConfiguration.FileInformation>();
        for (ModpackConfiguration.FileInformation file : this.overrides) {
            files.put(file.getPath(), file);
        }
        for (String subDirectory : this.subDirectories) {
            new Unzipper(this.modpackFile, this.dest).setSubDirectory(subDirectory).setTerminateIfSubDirectoryNotExists().setReplaceExistentFile(true).setEncoding(this.charset).setFilter((zipEntry, destFile, relativePath) -> {
                if (zipEntry.isDirectory()) {
                    return true;
                }
                if (!this.callback.test(relativePath)) {
                    return false;
                }
                entries.add(relativePath);
                if (!files.containsKey(relativePath)) {
                    return true;
                }
                if (!Files.exists(destFile, new LinkOption[0])) {
                    return false;
                }
                String fileHash = DigestUtils.digestToString("SHA-1", destFile);
                String oldHash = ((ModpackConfiguration.FileInformation)files.get(relativePath)).getHash();
                return Objects.equals(oldHash, fileHash);
            }).unzip();
        }
        for (ModpackConfiguration.FileInformation file : this.overrides) {
            Path original = this.dest.resolve(file.getPath());
            if (!Files.exists(original, new LinkOption[0]) || entries.contains(file.getPath())) continue;
            Files.deleteIfExists(original);
        }
    }
}

