/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.JFXTextField;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.WeakListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jackhuang.hmcl.setting.StyleSheets;
import org.jackhuang.hmcl.task.CacheFileTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ScrollUtils;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.image.ImageLoader;
import org.jackhuang.hmcl.ui.image.ImageUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.ResourceNotFoundError;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class FXUtils {
    public static final int JAVAFX_MAJOR_VERSION;
    public static final String GRAPHICS_PIPELINE;
    public static final boolean GPU_ACCELERATION_ENABLED;
    @Nullable
    public static final ObservableMap<String, Object> PREFERENCES;
    @Nullable
    public static final ObservableBooleanValue DARK_MODE;
    @Nullable
    public static final Boolean REDUCED_MOTION;
    @Nullable
    public static final ReadOnlyObjectProperty<Color> ACCENT_COLOR;
    @Nullable
    public static final MethodHandle TEXT_TRUNCATED_PROPERTY;
    @Nullable
    public static final MethodHandle FOCUS_VISIBLE_PROPERTY;
    public static final String DEFAULT_MONOSPACE_FONT;
    public static final List<String> IMAGE_EXTENSIONS;
    private static final Map<String, Image> builtinImageCache;
    private static final Duration TOOLTIP_FAST_SHOW_DELAY;
    private static final Duration TOOLTIP_SLOW_SHOW_DELAY;
    private static final Duration TOOLTIP_SHOW_DURATION;
    private static final String[] linuxBrowsers;
    private static final String LABEL_FULL_TEXT_PROP_KEY;
    public static final Interpolator SINE;

    private FXUtils() {
    }

    public static void shutdown() {
        builtinImageCache.clear();
    }

    public static void runInFX(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void checkFxUserThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public static InvalidationListener onInvalidating(Runnable action) {
        return arg -> action.run();
    }

    public static <T> void onChange(ObservableValue<T> value, Consumer<T> consumer) {
        value.addListener((a, b, c) -> consumer.accept(c));
    }

    public static <T> ChangeListener<T> onWeakChange(ObservableValue<T> value, Consumer<T> consumer) {
        ChangeListener listener = (a, b, c) -> consumer.accept(c);
        value.addListener((ChangeListener)new WeakChangeListener(listener));
        return listener;
    }

    public static <T> void onChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        consumer.accept(value.getValue());
        FXUtils.onChange(value, consumer);
    }

    public static <T> ChangeListener<T> onWeakChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        consumer.accept(value.getValue());
        return FXUtils.onWeakChange(value, consumer);
    }

    public static InvalidationListener observeWeak(Runnable runnable, Observable ... observables) {
        InvalidationListener originalListener = observable -> runnable.run();
        WeakInvalidationListener listener = new WeakInvalidationListener(originalListener);
        for (Observable observable2 : observables) {
            observable2.addListener((InvalidationListener)listener);
        }
        runnable.run();
        return originalListener;
    }

    public static void runLaterIf(BooleanSupplier condition, Runnable runnable) {
        if (condition.getAsBoolean()) {
            Platform.runLater(() -> FXUtils.runLaterIf(condition, runnable));
        } else {
            runnable.run();
        }
    }

    public static void limitSize(ImageView imageView, double maxWidth, double maxHeight) {
        imageView.setPreserveRatio(true);
        FXUtils.onChangeAndOperate(imageView.imageProperty(), image -> {
            if (image != null && (image.getWidth() > maxWidth || image.getHeight() > maxHeight)) {
                imageView.setFitHeight(maxHeight);
                imageView.setFitWidth(maxWidth);
            } else {
                imageView.setFitHeight(-1.0);
                imageView.setFitWidth(-1.0);
            }
        });
    }

    public static Node wrap(Node node) {
        return FXUtils.limitingSize(node, 30.0, 20.0);
    }

    public static Node wrap(SVG svg) {
        return FXUtils.wrap(svg.createIcon(20.0));
    }

    public static <T> void addListener(Node node, String key, ObservableValue<T> value, Consumer<? super T> callback) {
        ListenerPair<T> pair = new ListenerPair<T>(value, (a, b, newValue) -> callback.accept(newValue));
        node.getProperties().put((Object)key, pair);
        pair.bind();
    }

    public static void removeListener(Node node, String key) {
        Lang.tryCast(node.getProperties().get((Object)key), ListenerPair.class).ifPresent(info -> {
            info.unbind();
            node.getProperties().remove((Object)key);
        });
    }

    public static <T extends Event> void ignoreEvent(Node node, EventType<T> type, Predicate<? super T> filter) {
        EventDispatcher oldDispatcher = node.getEventDispatcher();
        node.setEventDispatcher((event, tail) -> {
            EventType t;
            for (t = event.getEventType(); t != null && t != type; t = t.getSuperType()) {
            }
            if (t == type && filter.test(event)) {
                return tail.dispatchEvent(event);
            }
            return oldDispatcher.dispatchEvent(event, tail);
        });
    }

    public static void setValidateWhileTextChanged(Node field, boolean validate) {
        if (field instanceof JFXTextField) {
            if (validate) {
                FXUtils.addListener(field, "FXUtils.validation", ((JFXTextField)field).textProperty(), o -> ((JFXTextField)field).validate());
            } else {
                FXUtils.removeListener(field, "FXUtils.validation");
            }
            ((JFXTextField)field).validate();
        } else if (field instanceof JFXPasswordField) {
            if (validate) {
                FXUtils.addListener(field, "FXUtils.validation", ((JFXPasswordField)field).textProperty(), o -> ((JFXPasswordField)field).validate());
            } else {
                FXUtils.removeListener(field, "FXUtils.validation");
            }
            ((JFXPasswordField)field).validate();
        } else {
            throw new IllegalArgumentException("Only JFXTextField and JFXPasswordField allowed");
        }
    }

    public static boolean getValidateWhileTextChanged(Node field) {
        return field.getProperties().containsKey((Object)"FXUtils.validation");
    }

    public static Rectangle setOverflowHidden(Region region) {
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)region.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)region.heightProperty());
        region.setClip((Node)rectangle);
        return rectangle;
    }

    public static Rectangle setOverflowHidden(Region region, double arc) {
        Rectangle rectangle = FXUtils.setOverflowHidden(region);
        rectangle.setArcWidth(arc);
        rectangle.setArcHeight(arc);
        return rectangle;
    }

    public static void setLimitWidth(Region region, double width) {
        region.setMaxWidth(width);
        region.setMinWidth(width);
        region.setPrefWidth(width);
    }

    public static double getLimitWidth(Region region) {
        return region.getMaxWidth();
    }

    public static void setLimitHeight(Region region, double height) {
        region.setMaxHeight(height);
        region.setMinHeight(height);
        region.setPrefHeight(height);
    }

    public static double getLimitHeight(Region region) {
        return region.getMaxHeight();
    }

    public static Node limitingSize(Node node, double width, double height) {
        StackPane pane = new StackPane(new Node[]{node});
        pane.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)pane, width);
        FXUtils.setLimitHeight((Region)pane, height);
        return pane;
    }

    public static void limitCellWidth(ListView<?> listView, ListCell<?> cell) {
        ReadOnlyDoubleProperty widthProperty;
        Node node = listView.lookup(".clipped-container");
        if (node instanceof Region) {
            Region clippedContainer = (Region)node;
            widthProperty = clippedContainer.widthProperty();
        } else {
            widthProperty = listView.widthProperty();
        }
        cell.maxWidthProperty().bind((ObservableValue)widthProperty);
        cell.prefWidthProperty().bind((ObservableValue)widthProperty);
        cell.minWidthProperty().bind((ObservableValue)widthProperty);
    }

    public static void smoothScrolling(ScrollPane scrollPane) {
        if (AnimationUtils.isAnimationEnabled()) {
            ScrollUtils.addSmoothScrolling(scrollPane);
        }
    }

    public static void smoothScrolling(VirtualFlow<?> virtualFlow) {
        if (AnimationUtils.isAnimationEnabled()) {
            ScrollUtils.addSmoothScrolling(virtualFlow);
        }
    }

    @Nullable
    public static ReadOnlyBooleanProperty textTruncatedProperty(Labeled labeled) {
        if (TEXT_TRUNCATED_PROPERTY != null) {
            try {
                return TEXT_TRUNCATED_PROPERTY.invokeExact(labeled);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    public static ReadOnlyBooleanProperty focusVisibleProperty(Node node) {
        if (FOCUS_VISIBLE_PROPERTY != null) {
            try {
                return FOCUS_VISIBLE_PROPERTY.invokeExact(node);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void installTooltip(Node node, Duration showDelay, Duration showDuration, Duration hideDelay, Tooltip tooltip) {
        tooltip.setShowDelay(showDelay);
        tooltip.setShowDuration(showDuration);
        tooltip.setHideDelay(hideDelay);
        Tooltip.install((Node)node, (Tooltip)tooltip);
    }

    public static void installFastTooltip(Node node, Tooltip tooltip) {
        FXUtils.runInFX(() -> FXUtils.installTooltip(node, TOOLTIP_FAST_SHOW_DELAY, TOOLTIP_SHOW_DURATION, Duration.ZERO, tooltip));
    }

    public static void installFastTooltip(Node node, String tooltip) {
        FXUtils.installFastTooltip(node, new Tooltip(tooltip));
    }

    public static void installSlowTooltip(Node node, Tooltip tooltip) {
        FXUtils.runInFX(() -> FXUtils.installTooltip(node, TOOLTIP_SLOW_SHOW_DELAY, TOOLTIP_SHOW_DURATION, Duration.ZERO, tooltip));
    }

    public static void installSlowTooltip(Node node, String tooltip) {
        FXUtils.installSlowTooltip(node, new Tooltip(tooltip));
    }

    public static void playAnimation(Node node, String animationKey, Animation animation) {
        animationKey = "hmcl.animations." + (String)animationKey;
        Object object = node.getProperties().get(animationKey);
        if (object instanceof Animation) {
            Animation oldAnimation = (Animation)object;
            oldAnimation.stop();
        }
        animation.play();
        node.getProperties().put(animationKey, (Object)animation);
    }

    public static void openFolder(Path file) {
        if (file.getFileSystem() != FileSystems.getDefault()) {
            Logger.LOG.warning("Cannot open folder as the file system is not supported: " + String.valueOf(file));
            return;
        }
        try {
            Files.createDirectories(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to create directory " + String.valueOf(file));
            return;
        }
        String path = FileUtils.getAbsolutePath(file);
        String openCommand = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "explorer.exe" : (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS ? "/usr/bin/open" : (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && Files.exists(Path.of("/usr/bin/xdg-open", new String[0]), new LinkOption[0]) ? "/usr/bin/xdg-open" : null));
        Lang.thread(() -> {
            if (openCommand != null) {
                try {
                    int exitCode = SystemUtils.callExternalProcess(openCommand, path);
                    if (exitCode == 0 || exitCode == 1 && OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                        return;
                    }
                    Logger.LOG.warning("Open " + path + " failed with code " + exitCode);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Unable to open " + path + " by executing " + openCommand, e);
                }
            }
            try {
                Desktop.getDesktop().open(file.toFile());
            }
            catch (Throwable e) {
                Logger.LOG.error("Unable to open " + path + " by java.awt.Desktop.getDesktop()::open", e);
            }
        });
    }

    public static void showFileInExplorer(Path file) {
        String path = file.toAbsolutePath().toString();
        String[] openCommands = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? new String[]{"explorer.exe", "/select,", path} : (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS ? new String[]{"/usr/bin/open", "-R", path} : (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && SystemUtils.which("dbus-send") != null ? new String[]{"dbus-send", "--print-reply", "--dest=org.freedesktop.FileManager1", "/org/freedesktop/FileManager1", "org.freedesktop.FileManager1.ShowItems", "array:string:" + String.valueOf(file.toAbsolutePath().toUri()), "string:"} : null));
        if (openCommands != null) {
            Lang.thread(() -> {
                try {
                    int exitCode = SystemUtils.callExternalProcess(openCommands);
                    if (exitCode == 0 || exitCode == 1 && OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                        return;
                    }
                    Logger.LOG.warning("Show " + path + " in explorer failed with code " + exitCode);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Unable to show " + path + " in explorer", e);
                }
                FXUtils.openFolder(file.getParent());
            });
        } else {
            FXUtils.openFolder(file.getParent());
        }
    }

    public static void openLink(String link) {
        if (link == null) {
            return;
        }
        String uri = NetworkUtils.encodeLocation(link);
        Lang.thread(() -> {
            try {
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                    Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", uri});
                    return;
                }
                if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
                    Runtime.getRuntime().exec(new String[]{"open", uri});
                    return;
                }
                for (String browser : linuxBrowsers) {
                    Path path = SystemUtils.which(browser);
                    if (path == null) continue;
                    try {
                        Runtime.getRuntime().exec(new String[]{path.toString(), uri});
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Logger.LOG.warning("No known browser found");
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to open link: " + link + ", fallback to java.awt.Desktop", e);
            }
            try {
                Desktop.getDesktop().browse(new URI(uri));
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to open link: " + link, e);
            }
        });
    }

    public static <T> void bind(JFXTextField textField, Property<T> property, StringConverter<T> converter) {
        TextFieldBinding<T> binding = new TextFieldBinding<T>(textField, property, converter);
        binding.updateTextField();
        textField.getProperties().put((Object)"FXUtils.bind.binding", binding);
        textField.focusedProperty().addListener(binding.focusedListener);
        textField.sceneProperty().addListener(binding.sceneListener);
        property.addListener(binding.propertyListener);
    }

    public static void bindInt(JFXTextField textField, Property<Number> property) {
        FXUtils.bind(textField, property, SafeStringConverter.fromInteger());
    }

    public static void bindString(JFXTextField textField, Property<String> property) {
        FXUtils.bind(textField, property, null);
    }

    public static void unbind(JFXTextField textField, Property<?> property) {
        TextFieldBinding binding = (TextFieldBinding)textField.getProperties().remove((Object)"FXUtils.bind.binding");
        if (binding != null) {
            textField.focusedProperty().removeListener(binding.focusedListener);
            textField.sceneProperty().removeListener(binding.sceneListener);
            property.removeListener(binding.propertyListener);
        }
    }

    public static <T extends Enum<T>> void bindEnum(JFXComboBox<T> comboBox, Property<T> property) {
        EnumBidirectionalBinding<T> binding = new EnumBidirectionalBinding<T>(comboBox, property);
        comboBox.getSelectionModel().selectedItemProperty().removeListener(binding);
        property.removeListener(binding);
        comboBox.getSelectionModel().select((Object)((Enum)property.getValue()));
        comboBox.getSelectionModel().selectedItemProperty().addListener(binding);
        property.addListener(binding);
    }

    public static <T extends Enum<T>> void unbindEnum(JFXComboBox<T> comboBox, Property<T> property) {
        EnumBidirectionalBinding<T> binding = new EnumBidirectionalBinding<T>(comboBox, property);
        comboBox.getSelectionModel().selectedItemProperty().removeListener(binding);
        property.removeListener(binding);
    }

    public static void bindPaint(ColorPicker colorPicker, Property<Paint> property) {
        PaintBidirectionalBinding binding = new PaintBidirectionalBinding(colorPicker, property);
        colorPicker.valueProperty().removeListener((InvalidationListener)binding);
        property.removeListener((InvalidationListener)binding);
        if (property.getValue() instanceof Color) {
            colorPicker.setValue((Object)((Color)property.getValue()));
        } else {
            colorPicker.setValue(null);
        }
        colorPicker.valueProperty().addListener((InvalidationListener)binding);
        property.addListener((InvalidationListener)binding);
    }

    public static void bindWindowsSize(JFXComboBox<String> comboBox, IntegerProperty widthProperty, IntegerProperty heightProperty) {
        comboBox.setValue(widthProperty.get() + "x" + heightProperty.get());
        WindowsSizeBidirectionalBinding binding = new WindowsSizeBidirectionalBinding(comboBox, widthProperty, heightProperty);
        comboBox.focusedProperty().addListener((InvalidationListener)binding);
        comboBox.sceneProperty().addListener((InvalidationListener)binding);
        widthProperty.addListener((InvalidationListener)binding);
        heightProperty.addListener((InvalidationListener)binding);
    }

    public static void unbindWindowsSize(JFXComboBox<String> comboBox, IntegerProperty widthProperty, IntegerProperty heightProperty) {
        WindowsSizeBidirectionalBinding binding = new WindowsSizeBidirectionalBinding(comboBox, widthProperty, heightProperty);
        comboBox.focusedProperty().removeListener((InvalidationListener)binding);
        comboBox.sceneProperty().removeListener((InvalidationListener)binding);
        widthProperty.removeListener((InvalidationListener)binding);
        heightProperty.removeListener((InvalidationListener)binding);
    }

    public static void bindAllEnabled(final BooleanProperty allEnabled, final BooleanProperty ... children) {
        final int itemCount = children.length;
        int childSelectedCount = 0;
        for (BooleanProperty child : children) {
            if (!child.get()) continue;
            ++childSelectedCount;
        }
        allEnabled.set(childSelectedCount == itemCount);
        class Listener
        implements InvalidationListener {
            private int childSelectedCount;
            private boolean updating = false;

            public Listener(int childSelectedCount) {
                this.childSelectedCount = childSelectedCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invalidated(Observable observable) {
                if (this.updating) {
                    return;
                }
                this.updating = true;
                try {
                    boolean value = ((BooleanProperty)observable).get();
                    if (observable == allEnabled) {
                        for (BooleanProperty child : children) {
                            child.setValue(Boolean.valueOf(value));
                        }
                        this.childSelectedCount = value ? itemCount : 0;
                    } else {
                        this.childSelectedCount = value ? ++this.childSelectedCount : --this.childSelectedCount;
                        allEnabled.set(this.childSelectedCount == itemCount);
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
        Listener listener = new Listener(childSelectedCount);
        WeakInvalidationListener weakListener = new WeakInvalidationListener((InvalidationListener)listener);
        allEnabled.addListener((InvalidationListener)listener);
        for (BooleanProperty child : children) {
            child.addListener((InvalidationListener)weakListener);
        }
    }

    public static void setIcon(Stage stage) {
        String icon = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "/assets/img/icon.png" : (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS ? "/assets/img/icon-mac.png" : "/assets/img/icon@4x.png");
        stage.getIcons().add((Object)FXUtils.newBuiltinImage(icon));
    }

    public static Image loadImage(Path path) throws Exception {
        return FXUtils.loadImage(path, 0, 0, false, false);
    }

    public static Image loadImage(Path path, int requestedWidth, int requestedHeight, boolean preserveRatio, boolean smooth) throws Exception {
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            String ext = FileUtils.getExtension(path).toLowerCase(Locale.ROOT);
            ImageLoader loader = ImageUtils.EXT_TO_LOADER.get(ext);
            if (loader == null && !ImageUtils.DEFAULT_EXTS.contains(ext)) {
                input.mark(1024);
                byte[] headerBuffer = input.readNBytes(1024);
                input.reset();
                loader = ImageUtils.guessLoader(headerBuffer);
            }
            if (loader == null) {
                loader = ImageUtils.DEFAULT;
            }
            Image image = loader.load(input, requestedWidth, requestedHeight, preserveRatio, smooth);
            return image;
        }
    }

    public static Image loadImage(String url) throws Exception {
        URI uri = NetworkUtils.toURI(url);
        URLConnection connection = NetworkUtils.createConnection(uri);
        if (connection instanceof HttpURLConnection) {
            connection = NetworkUtils.resolveConnection((HttpURLConnection)connection);
        }
        try (BufferedInputStream input = new BufferedInputStream(connection.getInputStream());){
            ImageLoader loader;
            String contentType = Objects.requireNonNull(connection.getContentType(), "");
            Matcher matcher = ImageUtils.CONTENT_TYPE_PATTERN.matcher(contentType);
            if (matcher.find()) {
                contentType = matcher.group("type");
            }
            if ((loader = ImageUtils.CONTENT_TYPE_TO_LOADER.get(contentType)) == null && !ImageUtils.DEFAULT_CONTENT_TYPES.contains(contentType)) {
                input.mark(1024);
                byte[] headerBuffer = input.readNBytes(1024);
                input.reset();
                loader = ImageUtils.guessLoader(headerBuffer);
            }
            if (loader == null) {
                loader = ImageUtils.DEFAULT;
            }
            Image image = loader.load(input, 0, 0, false, false);
            return image;
        }
    }

    public static Image newBuiltinImage(String url) {
        try {
            return builtinImageCache.computeIfAbsent(url, Image::new);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundError("Cannot access image: " + url, e);
        }
    }

    public static Image newBuiltinImage(String url, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth) {
        try {
            return new Image(url, requestedWidth, requestedHeight, preserveRatio, smooth);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundError("Cannot access image: " + url, e);
        }
    }

    public static Task<Image> getRemoteImageTask(String url, int requestedWidth, int requestedHeight, boolean preserveRatio, boolean smooth) {
        return new CacheFileTask(url).setSignificance(Task.TaskSignificance.MINOR).thenApplyAsync(file -> FXUtils.loadImage(file, requestedWidth, requestedHeight, preserveRatio, smooth)).setSignificance(Task.TaskSignificance.MINOR);
    }

    public static Task<Image> getRemoteImageTask(URI uri, int requestedWidth, int requestedHeight, boolean preserveRatio, boolean smooth) {
        return new CacheFileTask(uri).setSignificance(Task.TaskSignificance.MINOR).thenApplyAsync(file -> FXUtils.loadImage(file, requestedWidth, requestedHeight, preserveRatio, smooth)).setSignificance(Task.TaskSignificance.MINOR);
    }

    public static ObservableValue<Image> newRemoteImage(String url, int requestedWidth, int requestedHeight, boolean preserveRatio, boolean smooth) {
        SimpleObjectProperty image = new SimpleObjectProperty();
        FXUtils.getRemoteImageTask(url, requestedWidth, requestedHeight, preserveRatio, smooth).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                image.set(result);
            } else {
                Logger.LOG.warning("An exception encountered while loading remote image: " + url, exception);
            }
        }).setSignificance(Task.TaskSignificance.MINOR).start();
        return image;
    }

    public static JFXButton newRaisedButton(String text) {
        JFXButton button = new JFXButton(text);
        button.getStyleClass().add((Object)"jfx-button-raised");
        button.setButtonType(JFXButton.ButtonType.RAISED);
        return button;
    }

    public static JFXButton newBorderButton(String text) {
        JFXButton button = new JFXButton(text);
        button.getStyleClass().add((Object)"jfx-button-border");
        return button;
    }

    public static JFXButton newToggleButton4(SVG icon) {
        JFXButton button = new JFXButton();
        button.getStyleClass().add((Object)"toggle-icon4");
        button.setGraphic(icon.createIcon());
        return button;
    }

    public static Label newSafeTruncatedLabel(String text) {
        Label label = new Label(text);
        label.setTextOverrun(OverrunStyle.CENTER_WORD_ELLIPSIS);
        FXUtils.showTooltipWhenTruncated((Labeled)label);
        return label;
    }

    public static void showTooltipWhenTruncated(Labeled labeled) {
        ReadOnlyBooleanProperty textTruncatedProperty = FXUtils.textTruncatedProperty(labeled);
        if (textTruncatedProperty != null) {
            ChangeListener listener = (observable, oldValue, newValue) -> {
                Labeled label = (Labeled)((ReadOnlyProperty)observable).getBean();
                Tooltip tooltip = (Tooltip)label.getProperties().get((Object)LABEL_FULL_TEXT_PROP_KEY);
                if (newValue.booleanValue()) {
                    if (tooltip == null) {
                        tooltip = new Tooltip();
                        tooltip.textProperty().bind((ObservableValue)label.textProperty());
                        label.getProperties().put((Object)LABEL_FULL_TEXT_PROP_KEY, (Object)tooltip);
                    }
                    FXUtils.installFastTooltip((Node)label, tooltip);
                } else if (tooltip != null) {
                    Tooltip.uninstall((Node)label, (Tooltip)tooltip);
                }
            };
            listener.changed((ObservableValue)textTruncatedProperty, (Object)false, (Object)textTruncatedProperty.get());
            textTruncatedProperty.addListener(listener);
        }
    }

    public static void applyDragListener(Node node, PathMatcher filter, Consumer<List<Path>> callback) {
        FXUtils.applyDragListener(node, filter, callback, null);
    }

    public static void applyDragListener(Node node, PathMatcher filter, Consumer<List<Path>> callback, Runnable dragDropped) {
        node.setOnDragOver(event -> {
            if (event.getGestureSource() != node && event.getDragboard().hasFiles()) {
                if (event.getDragboard().getFiles().stream().map(File::toPath).anyMatch(filter::matches)) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                }
            }
            event.consume();
        });
        node.setOnDragDropped(event -> {
            List files = event.getDragboard().getFiles();
            if (files != null) {
                List<Path> acceptFiles = files.stream().map(File::toPath).filter(filter::matches).toList();
                if (!acceptFiles.isEmpty()) {
                    callback.accept(acceptFiles);
                    event.setDropCompleted(true);
                }
            }
            if (dragDropped != null) {
                dragDropped.run();
            }
            event.consume();
        });
    }

    public static <T> StringConverter<T> stringConverter(final Function<T, String> func) {
        return new StringConverter<T>(){

            public String toString(T object) {
                return object == null ? "" : (String)func.apply(object);
            }

            public T fromString(String string) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Callback<ListView<T>, ListCell<T>> jfxListCellFactory(final Function<T, Node> graphicBuilder) {
        return view -> new JFXListCell<T>(){

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    this.setGraphic((Node)graphicBuilder.apply(item));
                }
            }
        };
    }

    public static ColumnConstraints getColumnFillingWidth() {
        ColumnConstraints constraint = new ColumnConstraints();
        constraint.setFillWidth(true);
        return constraint;
    }

    public static ColumnConstraints getColumnHgrowing() {
        ColumnConstraints constraint = new ColumnConstraints();
        constraint.setFillWidth(true);
        constraint.setHgrow(Priority.ALWAYS);
        return constraint;
    }

    public static void onEscPressed(Node node, Runnable action) {
        node.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                action.run();
                e.consume();
            }
        });
    }

    public static void onClicked(Node node, Runnable action) {
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                action.run();
                e.consume();
            }
        });
    }

    public static void onSecondaryButtonClicked(Node node, Runnable action) {
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                action.run();
                e.consume();
            }
        });
    }

    public static <N extends Parent> N prepareNode(N node) {
        Scene dummyScene = new Scene(node);
        StyleSheets.init(dummyScene);
        node.applyCss();
        node.layout();
        return node;
    }

    public static void prepareOnMouseEnter(final Node node, final Runnable action) {
        node.addEventFilter(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                node.removeEventFilter(MouseEvent.MOUSE_ENTERED, (EventHandler)this);
                action.run();
            }
        });
    }

    public static <T> void onScroll(Node node, List<T> list, ToIntFunction<List<T>> finder, Consumer<T> updater) {
        node.addEventHandler(ScrollEvent.SCROLL, event -> {
            double deltaY = event.getDeltaY();
            if (deltaY == 0.0) {
                return;
            }
            int index = finder.applyAsInt(list);
            if (index < 0) {
                return;
            }
            index = deltaY > 0.0 ? --index : ++index;
            updater.accept(list.get((index + list.size()) % list.size()));
            event.consume();
        });
    }

    public static void copyOnDoubleClick(Labeled label) {
        label.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            String text;
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2 && (text = label.getText()) != null && !text.isEmpty()) {
                FXUtils.copyText(label.getText());
                e.consume();
            }
        });
    }

    public static void copyText(String text) {
        FXUtils.copyText(text, I18n.i18n("message.copied"));
    }

    public static void copyText(String text, @Nullable String toastMessage) {
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        Clipboard.getSystemClipboard().setContent((Map)content);
        if (toastMessage != null && !Controllers.isStopped()) {
            Controllers.showToast(toastMessage);
        }
    }

    public static List<Node> parseSegment(String segment, Consumer<String> hyperlinkAction) {
        if (segment.indexOf(60) < 0) {
            return Collections.singletonList(new Text(segment));
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader("<body>" + segment + "</body>")));
            Element r = doc.getDocumentElement();
            NodeList children = r.getChildNodes();
            ArrayList<Node> texts = new ArrayList<Node>();
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node node = children.item(i);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    if ("a".equals(element.getTagName())) {
                        String href = element.getAttribute("href");
                        Text text = new Text(element.getTextContent());
                        text.getStyleClass().add((Object)"hyperlink");
                        FXUtils.onClicked((Node)text, () -> {
                            String link = href;
                            try {
                                link = new URI(href).toASCIIString();
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                            hyperlinkAction.accept(link);
                        });
                        text.setCursor(Cursor.HAND);
                        text.setUnderline(true);
                        texts.add((Node)text);
                        continue;
                    }
                    if ("b".equals(element.getTagName())) {
                        Text text = new Text(element.getTextContent());
                        text.getStyleClass().add((Object)"bold");
                        texts.add((Node)text);
                        continue;
                    }
                    if ("br".equals(element.getTagName())) {
                        texts.add((Node)new Text("\n"));
                        continue;
                    }
                    throw new IllegalArgumentException("unsupported tag " + element.getTagName());
                }
                texts.add((Node)new Text(node.getTextContent()));
            }
            return texts;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.LOG.warning("Failed to parse xml", e);
            return Collections.singletonList(new Text(segment));
        }
    }

    public static TextFlow segmentToTextFlow(String segment, Consumer<String> hyperlinkAction) {
        TextFlow tf = new TextFlow();
        tf.getChildren().setAll(FXUtils.parseSegment(segment, hyperlinkAction));
        return tf;
    }

    public static String toWeb(Color color) {
        int r = (int)Math.round(color.getRed() * 255.0);
        int g = (int)Math.round(color.getGreen() * 255.0);
        int b = (int)Math.round(color.getBlue() * 255.0);
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static FileChooser.ExtensionFilter getImageExtensionFilter() {
        return new FileChooser.ExtensionFilter(I18n.i18n("extension.png"), (String[])IMAGE_EXTENSIONS.stream().map(ext -> "*." + ext).toArray(String[]::new));
    }

    public static JFXPopup.PopupVPosition determineOptimalPopupPosition(Node root, JFXPopup popupInstance) {
        double menuHeight;
        Bounds screenBounds = root.localToScreen(root.getBoundsInLocal());
        Rectangle2D boundsRect = new Rectangle2D(screenBounds.getMinX(), screenBounds.getMinY(), screenBounds.getWidth(), screenBounds.getHeight());
        ObservableList screens = Screen.getScreensForRectangle((Rectangle2D)boundsRect);
        Screen currentScreen = screens.isEmpty() ? Screen.getPrimary() : (Screen)screens.get(0);
        Rectangle2D visualBounds = currentScreen.getVisualBounds();
        double screenHeight = visualBounds.getHeight();
        double screenMinY = visualBounds.getMinY();
        double itemScreenY = screenBounds.getMinY();
        double availableSpaceAbove = itemScreenY - screenMinY;
        double availableSpaceBelow = screenMinY + screenHeight - itemScreenY - root.getBoundsInLocal().getHeight();
        Region popupContent = popupInstance.getPopupContent();
        if (popupContent.getHeight() <= 0.0) {
            popupContent.autosize();
            popupContent.applyCss();
            popupContent.layout();
            menuHeight = popupContent.getHeight();
            if (menuHeight <= 0.0) {
                menuHeight = 300.0;
            }
        } else {
            menuHeight = popupContent.getHeight();
        }
        return availableSpaceAbove > (menuHeight += 20.0) && availableSpaceBelow < menuHeight ? JFXPopup.PopupVPosition.BOTTOM : JFXPopup.PopupVPosition.TOP;
    }

    public static void useJFXContextMenu(TextInputControl control) {
        control.setContextMenu(null);
        PopupMenu menu = new PopupMenu();
        JFXPopup popup = new JFXPopup((Region)menu);
        popup.setAutoHide(true);
        control.setOnContextMenuRequested(e -> {
            boolean hasNoSelection = control.getSelectedText().isEmpty();
            IconedMenuItem undo = new IconedMenuItem(SVG.UNDO, I18n.i18n("menu.undo"), () -> ((TextInputControl)control).undo(), popup);
            IconedMenuItem redo = new IconedMenuItem(SVG.REDO, I18n.i18n("menu.redo"), () -> ((TextInputControl)control).redo(), popup);
            IconedMenuItem cut = new IconedMenuItem(SVG.CONTENT_CUT, I18n.i18n("menu.cut"), () -> ((TextInputControl)control).cut(), popup);
            IconedMenuItem copy = new IconedMenuItem(SVG.CONTENT_COPY, I18n.i18n("menu.copy"), () -> ((TextInputControl)control).copy(), popup);
            IconedMenuItem paste = new IconedMenuItem(SVG.CONTENT_PASTE, I18n.i18n("menu.paste"), () -> ((TextInputControl)control).paste(), popup);
            IconedMenuItem delete = new IconedMenuItem(SVG.DELETE, I18n.i18n("menu.deleteselection"), () -> control.replaceSelection(""), popup);
            IconedMenuItem selectall = new IconedMenuItem(SVG.SELECT_ALL, I18n.i18n("menu.selectall"), () -> ((TextInputControl)control).selectAll(), popup);
            menu.getContent().setAll((Object[])new Node[]{undo, redo, new MenuSeparator(), cut, copy, paste, delete, new MenuSeparator(), selectall});
            undo.setDisable(!control.isUndoable());
            redo.setDisable(!control.isRedoable());
            cut.setDisable(hasNoSelection);
            delete.setDisable(hasNoSelection);
            copy.setDisable(hasNoSelection);
            paste.setDisable(!Clipboard.getSystemClipboard().hasString());
            selectall.setDisable(control.getText() == null || control.getText().isEmpty());
            JFXPopup.PopupVPosition vPosition = FXUtils.determineOptimalPopupPosition((Node)control, popup);
            popup.show((Node)control, vPosition, JFXPopup.PopupHPosition.LEFT, e.getX(), vPosition == JFXPopup.PopupVPosition.TOP ? e.getY() : e.getY() - control.getHeight());
            e.consume();
        });
    }

    static {
        Matcher matcher;
        String pipelineName = "";
        try {
            Object pipeline = Class.forName("com.sun.prism.GraphicsPipeline").getMethod("getPipeline", new Class[0]).invoke(null, new Object[0]);
            if (pipeline != null) {
                pipelineName = pipeline.getClass().getName();
            }
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get prism pipeline", e);
        }
        GRAPHICS_PIPELINE = pipelineName;
        GPU_ACCELERATION_ENABLED = !pipelineName.endsWith(".SWPipeline");
        String jfxVersion = System.getProperty("javafx.version");
        int majorVersion = -1;
        if (jfxVersion != null && (matcher = Pattern.compile("^(?<version>[0-9]+)").matcher(jfxVersion)).find()) {
            majorVersion = Lang.parseInt(matcher.group(), -1);
        }
        JAVAFX_MAJOR_VERSION = majorVersion;
        ObservableMap preferences = null;
        BooleanBinding darkMode = null;
        ReadOnlyObjectProperty accentColorProperty = null;
        Boolean reducedMotion = null;
        if (JAVAFX_MAJOR_VERSION >= 22) {
            try {
                ReadOnlyObjectProperty accentColorProperty0;
                ObservableMap preferences0;
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                Class<?> preferencesClass = Class.forName("javafx.application.Platform$Preferences");
                preferences = preferences0 = lookup.findStatic(Platform.class, "getPreferences", MethodType.methodType(preferencesClass)).invoke();
                ReadOnlyObjectProperty colorSchemeProperty = lookup.findVirtual(preferencesClass, "colorSchemeProperty", MethodType.methodType(ReadOnlyObjectProperty.class)).invoke(preferences);
                darkMode = Bindings.createBooleanBinding(() -> "DARK".equals(((Enum)colorSchemeProperty.get()).name()), (Observable[])new Observable[]{colorSchemeProperty});
                accentColorProperty = accentColorProperty0 = lookup.findVirtual(preferencesClass, "accentColorProperty", MethodType.methodType(ReadOnlyObjectProperty.class)).invoke(preferences);
                if (JAVAFX_MAJOR_VERSION >= 24) {
                    reducedMotion = lookup.findVirtual(preferencesClass, "isReducedMotion", MethodType.methodType(Boolean.TYPE)).invoke(preferences);
                }
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to get preferences", e);
            }
        }
        PREFERENCES = preferences;
        DARK_MODE = darkMode;
        REDUCED_MOTION = reducedMotion;
        ACCENT_COLOR = accentColorProperty;
        MethodHandle textTruncatedProperty = null;
        if (JAVAFX_MAJOR_VERSION >= 23) {
            try {
                textTruncatedProperty = MethodHandles.publicLookup().findVirtual(Labeled.class, "textTruncatedProperty", MethodType.methodType(ReadOnlyBooleanProperty.class));
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to lookup textTruncatedProperty", e);
            }
        }
        TEXT_TRUNCATED_PROPERTY = textTruncatedProperty;
        MethodHandle focusVisibleProperty = null;
        if (JAVAFX_MAJOR_VERSION >= 19) {
            try {
                focusVisibleProperty = MethodHandles.publicLookup().findVirtual(Node.class, "focusVisibleProperty", MethodType.methodType(ReadOnlyBooleanProperty.class));
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to lookup focusVisibleProperty", e);
            }
        }
        FOCUS_VISIBLE_PROPERTY = focusVisibleProperty;
        DEFAULT_MONOSPACE_FONT = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "Consolas" : "Monospace";
        IMAGE_EXTENSIONS = Lang.immutableListOf("png", "jpg", "jpeg", "bmp", "gif", "webp", "apng");
        builtinImageCache = new ConcurrentHashMap<String, Image>();
        TOOLTIP_FAST_SHOW_DELAY = Duration.millis((double)50.0);
        TOOLTIP_SLOW_SHOW_DELAY = Duration.millis((double)500.0);
        TOOLTIP_SHOW_DURATION = Duration.millis((double)5000.0);
        linuxBrowsers = new String[]{"xdg-open", "google-chrome", "firefox", "microsoft-edge", "opera", "konqueror", "mozilla"};
        LABEL_FULL_TEXT_PROP_KEY = FXUtils.class.getName() + ".LABEL_FULL_TEXT";
        SINE = new Interpolator(){

            protected double curve(double t) {
                return Math.sin(t * Math.PI / 2.0);
            }

            public String toString() {
                return "Interpolator.SINE";
            }
        };
    }

    private static class ListenerPair<T> {
        private final ObservableValue<T> value;
        private final ChangeListener<? super T> listener;

        ListenerPair(ObservableValue<T> value, ChangeListener<? super T> listener) {
            this.value = value;
            this.listener = listener;
        }

        void bind() {
            this.value.addListener(this.listener);
        }

        void unbind() {
            this.value.removeListener(this.listener);
        }
    }

    private static final class TextFieldBinding<T> {
        private final JFXTextField textField;
        private final Property<T> property;
        private final StringConverter<T> converter;
        public final ChangeListener<Boolean> focusedListener;
        public final ChangeListener<Scene> sceneListener;
        public final InvalidationListener propertyListener;

        public TextFieldBinding(JFXTextField textField, Property<T> property, StringConverter<T> converter) {
            this.textField = textField;
            this.property = property;
            this.converter = converter;
            this.focusedListener = (observable, oldFocused, newFocused) -> {
                if (oldFocused.booleanValue() && !newFocused.booleanValue()) {
                    if (textField.validate()) {
                        this.updateProperty();
                    } else {
                        this.updateTextField();
                    }
                }
            };
            this.sceneListener = (observable, oldScene, newScene) -> {
                if (oldScene != null && newScene == null && textField.validate()) {
                    this.updateProperty();
                }
            };
            this.propertyListener = observable -> this.updateTextField();
        }

        public void updateProperty() {
            String newValue;
            String newText = this.textField.getText();
            String string = newValue = this.converter == null ? newText : this.converter.fromString(newText);
            if (!Objects.equals(newValue, this.property.getValue())) {
                this.property.setValue((Object)newValue);
            }
        }

        public void updateTextField() {
            Object value = this.property.getValue();
            this.textField.setText(this.converter == null ? (String)value : this.converter.toString(value));
        }
    }

    private static final class EnumBidirectionalBinding<E extends Enum<E>>
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<JFXComboBox<E>> comboBoxRef;
        private final WeakReference<Property<E>> propertyRef;
        private final int hashCode;
        private boolean updating = false;

        private EnumBidirectionalBinding(JFXComboBox<E> comboBox, Property<E> property) {
            this.comboBoxRef = new WeakReference<JFXComboBox<E>>(comboBox);
            this.propertyRef = new WeakReference<Property<E>>(property);
            this.hashCode = System.identityHashCode(comboBox) ^ System.identityHashCode(property);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(Observable sourceProperty) {
            if (!this.updating) {
                JFXComboBox comboBox = (JFXComboBox)((Object)this.comboBoxRef.get());
                Property property = (Property)this.propertyRef.get();
                if (comboBox == null || property == null) {
                    if (comboBox != null) {
                        comboBox.getSelectionModel().selectedItemProperty().removeListener((InvalidationListener)this);
                    }
                    if (property != null) {
                        property.removeListener((InvalidationListener)this);
                    }
                } else {
                    this.updating = true;
                    try {
                        if (property == sourceProperty) {
                            Enum newValue = (Enum)property.getValue();
                            comboBox.getSelectionModel().select((Object)newValue);
                        } else {
                            Enum newValue = (Enum)comboBox.getSelectionModel().getSelectedItem();
                            property.setValue((Object)newValue);
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.comboBoxRef.get() == null || this.propertyRef.get() == null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnumBidirectionalBinding)) {
                return false;
            }
            EnumBidirectionalBinding that = (EnumBidirectionalBinding)o;
            JFXComboBox comboBox = (JFXComboBox)((Object)this.comboBoxRef.get());
            Property property = (Property)this.propertyRef.get();
            JFXComboBox thatComboBox = (JFXComboBox)((Object)that.comboBoxRef.get());
            Property thatProperty = (Property)that.propertyRef.get();
            if (comboBox == null || property == null || thatComboBox == null || thatProperty == null) {
                return false;
            }
            return comboBox == thatComboBox && property == thatProperty;
        }
    }

    private static final class PaintBidirectionalBinding
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<ColorPicker> colorPickerRef;
        private final WeakReference<Property<Paint>> propertyRef;
        private final int hashCode;
        private boolean updating = false;

        private PaintBidirectionalBinding(ColorPicker colorPicker, Property<Paint> property) {
            this.colorPickerRef = new WeakReference<ColorPicker>(colorPicker);
            this.propertyRef = new WeakReference<Property<Paint>>(property);
            this.hashCode = System.identityHashCode(colorPicker) ^ System.identityHashCode(property);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(Observable sourceProperty) {
            if (!this.updating) {
                ColorPicker colorPicker = (ColorPicker)this.colorPickerRef.get();
                Property property = (Property)this.propertyRef.get();
                if (colorPicker == null || property == null) {
                    if (colorPicker != null) {
                        colorPicker.valueProperty().removeListener((InvalidationListener)this);
                    }
                    if (property != null) {
                        property.removeListener((InvalidationListener)this);
                    }
                } else {
                    this.updating = true;
                    try {
                        if (property == sourceProperty) {
                            Paint newValue = (Paint)property.getValue();
                            if (newValue instanceof Color) {
                                colorPicker.setValue((Object)((Color)newValue));
                            } else {
                                colorPicker.setValue(null);
                            }
                        } else {
                            Paint newValue = (Paint)colorPicker.getValue();
                            property.setValue((Object)newValue);
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.colorPickerRef.get() == null || this.propertyRef.get() == null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PaintBidirectionalBinding)) {
                return false;
            }
            PaintBidirectionalBinding that = (PaintBidirectionalBinding)o;
            ColorPicker colorPicker = (ColorPicker)this.colorPickerRef.get();
            Property property = (Property)this.propertyRef.get();
            ColorPicker thatColorPicker = (ColorPicker)that.colorPickerRef.get();
            Property thatProperty = (Property)that.propertyRef.get();
            if (colorPicker == null || property == null || thatColorPicker == null || thatProperty == null) {
                return false;
            }
            return colorPicker == thatColorPicker && property == thatProperty;
        }
    }

    private static final class WindowsSizeBidirectionalBinding
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<JFXComboBox<String>> comboBoxRef;
        private final WeakReference<IntegerProperty> widthPropertyRef;
        private final WeakReference<IntegerProperty> heightPropertyRef;
        private final int hashCode;
        private boolean updating = false;

        private WindowsSizeBidirectionalBinding(JFXComboBox<String> comboBox, IntegerProperty widthProperty, IntegerProperty heightProperty) {
            this.comboBoxRef = new WeakReference<JFXComboBox<String>>(comboBox);
            this.widthPropertyRef = new WeakReference<IntegerProperty>(widthProperty);
            this.heightPropertyRef = new WeakReference<IntegerProperty>(heightProperty);
            this.hashCode = System.identityHashCode(comboBox) ^ System.identityHashCode(widthProperty) ^ System.identityHashCode(heightProperty);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(Observable observable) {
            block17: {
                if (!this.updating) {
                    JFXComboBox comboBox = (JFXComboBox)((Object)this.comboBoxRef.get());
                    IntegerProperty widthProperty = (IntegerProperty)this.widthPropertyRef.get();
                    IntegerProperty heightProperty = (IntegerProperty)this.heightPropertyRef.get();
                    if (comboBox == null || widthProperty == null || heightProperty == null) {
                        if (comboBox != null) {
                            comboBox.focusedProperty().removeListener((InvalidationListener)this);
                            comboBox.sceneProperty().removeListener((InvalidationListener)this);
                        }
                        if (widthProperty != null) {
                            widthProperty.removeListener((InvalidationListener)this);
                        }
                        if (heightProperty != null) {
                            heightProperty.removeListener((InvalidationListener)this);
                        }
                    } else {
                        this.updating = true;
                        try {
                            int width = widthProperty.get();
                            int height = heightProperty.get();
                            if (observable instanceof ReadOnlyProperty && ((ReadOnlyProperty)observable).getBean() == comboBox) {
                                int newHeight;
                                int newWidth;
                                int idx;
                                String value = (String)comboBox.valueProperty().get();
                                if (value == null) {
                                    value = "";
                                }
                                if ((idx = value.indexOf(120)) < 0) {
                                    idx = value.indexOf(42);
                                }
                                if (idx < 0) {
                                    Logger.LOG.warning("Bad window size: " + value);
                                    comboBox.setValue(width + "x" + height);
                                    return;
                                }
                                String widthStr = value.substring(0, idx).trim();
                                String heightStr = value.substring(idx + 1).trim();
                                try {
                                    newWidth = Integer.parseInt(widthStr);
                                    newHeight = Integer.parseInt(heightStr);
                                }
                                catch (NumberFormatException e) {
                                    Logger.LOG.warning("Bad window size: " + value);
                                    comboBox.setValue(width + "x" + height);
                                    this.updating = false;
                                    return;
                                }
                                widthProperty.set(newWidth);
                                heightProperty.set(newHeight);
                                break block17;
                            }
                            comboBox.setValue(width + "x" + height);
                        }
                        finally {
                            this.updating = false;
                        }
                    }
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.comboBoxRef.get() == null || this.widthPropertyRef.get() == null || this.heightPropertyRef.get() == null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WindowsSizeBidirectionalBinding)) {
                return false;
            }
            WindowsSizeBidirectionalBinding that = (WindowsSizeBidirectionalBinding)obj;
            JFXComboBox comboBox = (JFXComboBox)((Object)this.comboBoxRef.get());
            IntegerProperty widthProperty = (IntegerProperty)this.widthPropertyRef.get();
            IntegerProperty heightProperty = (IntegerProperty)this.heightPropertyRef.get();
            JFXComboBox thatComboBox = (JFXComboBox)((Object)that.comboBoxRef.get());
            IntegerProperty thatWidthProperty = (IntegerProperty)that.widthPropertyRef.get();
            IntegerProperty thatHeightProperty = (IntegerProperty)that.heightPropertyRef.get();
            if (comboBox == null || widthProperty == null || heightProperty == null || thatComboBox == null || thatWidthProperty == null || thatHeightProperty == null) {
                return false;
            }
            return comboBox == thatComboBox && widthProperty == thatWidthProperty && heightProperty == thatHeightProperty;
        }
    }
}

