/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DownloadListPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.SimpleMultimap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jetbrains.annotations.Nullable;

public class DownloadPage
extends Control
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final BooleanProperty loaded = new SimpleBooleanProperty(false);
    private final BooleanProperty loading = new SimpleBooleanProperty(false);
    private final BooleanProperty failed = new SimpleBooleanProperty(false);
    private final RemoteModRepository repository;
    private final ModTranslations translations;
    private final RemoteMod addon;
    private final ModTranslations.Mod mod;
    private final Profile.ProfileVersion version;
    private final DownloadCallback callback;
    private final DownloadListPage page;
    private SimpleMultimap<String, RemoteMod.Version, List<RemoteMod.Version>> versions;

    public DownloadPage(DownloadListPage page, RemoteMod addon, Profile.ProfileVersion version, @Nullable DownloadCallback callback) {
        this.page = page;
        this.repository = page.repository;
        this.addon = addon;
        this.translations = ModTranslations.getTranslationsByRepositoryType(this.repository.getType());
        this.mod = this.translations.getModByCurseForgeId(addon.getSlug());
        this.version = version;
        this.callback = callback;
        this.loadModVersions();
        this.state.set((Object)DecoratorPage.State.fromTitle(addon.getTitle()));
    }

    private void loadModVersions() {
        this.setLoading(true);
        this.setFailed(false);
        Task.supplyAsync(() -> {
            Stream<RemoteMod.Version> versions = this.addon.getData().loadVersions(this.repository);
            return this.sortVersions(versions);
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.versions = result;
                this.loaded.set(true);
                this.setFailed(false);
            } else {
                this.setFailed(true);
            }
            this.setLoading(false);
        }).start();
    }

    private SimpleMultimap<String, RemoteMod.Version, List<RemoteMod.Version>> sortVersions(Stream<RemoteMod.Version> versions) {
        SimpleMultimap<String, RemoteMod.Version, List<RemoteMod.Version>> classifiedVersions = new SimpleMultimap<String, RemoteMod.Version, List<RemoteMod.Version>>(HashMap::new, ArrayList::new);
        versions.forEach(version -> {
            for (String gameVersion : version.getGameVersions()) {
                classifiedVersions.put(gameVersion, (RemoteMod.Version)version);
            }
        });
        for (String gameVersion : classifiedVersions.keys()) {
            List<RemoteMod.Version> versionList = classifiedVersions.get(gameVersion);
            versionList.sort(Comparator.comparing(RemoteMod.Version::getDatePublished).reversed());
        }
        return classifiedVersions;
    }

    public RemoteMod getAddon() {
        return this.addon;
    }

    public Profile.ProfileVersion getVersion() {
        return this.version;
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading.set(loading);
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public BooleanProperty failedProperty() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed.set(failed);
    }

    public void download(RemoteMod mod, RemoteMod.Version file) {
        if (this.callback == null) {
            this.saveAs(mod, file);
        } else {
            this.callback.download(this.version.getProfile(), this.version.getVersion(), mod, file);
        }
    }

    public void saveAs(RemoteMod mod, RemoteMod.Version file) {
        String extension = StringUtils.substringAfterLast(file.getFile().getFilename(), '.');
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("button.save_as"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("file"), new String[]{"*." + extension}));
        fileChooser.setInitialFileName(file.getFile().getFilename());
        Path dest = FileUtils.toPath(fileChooser.showSaveDialog((Window)Controllers.getStage()));
        if (dest == null) {
            return;
        }
        Controllers.taskDialog(Task.composeAsync(() -> {
            FileDownloadTask task = new FileDownloadTask(file.getFile().getUrl(), dest, file.getFile().getIntegrityCheck());
            task.setName(file.getName());
            return task;
        }), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new ModDownloadPageSkin(this);
    }

    public static interface DownloadCallback {
        public void download(Profile var1, @Nullable String var2, RemoteMod var3, RemoteMod.Version var4);
    }

    private static class ModDownloadPageSkin
    extends SkinBase<DownloadPage> {
        protected ModDownloadPageSkin(DownloadPage control) {
            super((Control)control);
            VBox pane = new VBox(8.0);
            pane.getStyleClass().add((Object)"gray-background");
            pane.setPadding(new Insets(10.0));
            ScrollPane scrollPane = new ScrollPane((Node)pane);
            FXUtils.smoothScrolling(scrollPane);
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            HBox descriptionPane = new HBox(8.0);
            descriptionPane.setMinHeight(Double.NEGATIVE_INFINITY);
            descriptionPane.setAlignment(Pos.CENTER);
            pane.getChildren().add((Object)descriptionPane);
            descriptionPane.getStyleClass().add((Object)"card-non-transparent");
            BorderPane.setMargin((Node)descriptionPane, (Insets)new Insets(11.0, 11.0, 0.0, 11.0));
            ImageView imageView = new ImageView();
            imageView.setFitWidth(40.0);
            imageView.setFitHeight(40.0);
            if (StringUtils.isNotBlank(((DownloadPage)this.getSkinnable()).addon.getIconUrl())) {
                imageView.imageProperty().bind(FXUtils.newRemoteImage(((DownloadPage)this.getSkinnable()).addon.getIconUrl(), 80, 80, true, true));
            }
            descriptionPane.getChildren().add((Object)FXUtils.limitingSize((Node)imageView, 40.0, 40.0));
            TwoLineListItem content = new TwoLineListItem();
            HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            ModTranslations.Mod mod = ((DownloadPage)this.getSkinnable()).translations.getModByCurseForgeId(((DownloadPage)this.getSkinnable()).addon.getSlug());
            content.setTitle(mod != null && I18n.isUseChinese() ? mod.getDisplayName() : ((DownloadPage)this.getSkinnable()).addon.getTitle());
            content.setSubtitle(((DownloadPage)this.getSkinnable()).addon.getDescription());
            content.getSubtitleLabel().setWrapText(true);
            ((DownloadPage)this.getSkinnable()).addon.getCategories().stream().map(category -> ((DownloadPage)this.getSkinnable()).page.getLocalizedCategory((String)category)).forEach(content::addTag);
            descriptionPane.getChildren().add((Object)content);
            if (((DownloadPage)this.getSkinnable()).mod != null) {
                JFXHyperlink openMcmodButton = new JFXHyperlink(I18n.i18n("mods.mcmod"));
                openMcmodButton.setExternalLink(((DownloadPage)this.getSkinnable()).translations.getMcmodUrl(((DownloadPage)this.getSkinnable()).mod));
                descriptionPane.getChildren().add((Object)openMcmodButton);
                openMcmodButton.setMinWidth(Double.NEGATIVE_INFINITY);
                FXUtils.installFastTooltip((Node)openMcmodButton, I18n.i18n("mods.mcmod"));
            }
            JFXHyperlink openUrlButton = new JFXHyperlink(control.page.getLocalizedOfficialPage());
            openUrlButton.setExternalLink(((DownloadPage)this.getSkinnable()).addon.getPageUrl());
            descriptionPane.getChildren().add((Object)openUrlButton);
            openUrlButton.setMinWidth(Double.NEGATIVE_INFINITY);
            FXUtils.installFastTooltip((Node)openUrlButton, control.page.getLocalizedOfficialPage());
            SpinnerPane spinnerPane = new SpinnerPane();
            VBox.setVgrow((Node)spinnerPane, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)spinnerPane);
            spinnerPane.loadingProperty().bind((ObservableValue)((DownloadPage)this.getSkinnable()).loadingProperty());
            spinnerPane.failedReasonProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((DownloadPage)this.getSkinnable()).isFailed()) {
                    return I18n.i18n("download.failed.refresh");
                }
                return null;
            }, (Observable[])new Observable[]{((DownloadPage)this.getSkinnable()).failedProperty()}));
            spinnerPane.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> ((DownloadPage)this.getSkinnable()).loadModVersions()));
            ComponentList list = new ComponentList();
            StackPane.setAlignment((Node)list, (Pos)Pos.TOP_CENTER);
            spinnerPane.setContent((Node)list);
            FXUtils.onChangeAndOperate(control.loaded, loaded -> {
                List<RemoteMod.Version> modVersions;
                Version game;
                HMCLGameRepository repository;
                String gameVersion;
                if (control.versions == null) {
                    return;
                }
                if (control.version.getProfile() != null && control.version.getVersion() != null && (gameVersion = (String)(repository = control.version.getProfile().getRepository()).getGameVersion(game = repository.getResolvedPreservingPatchesVersion(control.version.getVersion())).orElse(null)) != null && (modVersions = control.versions.get(gameVersion)) != null && !modVersions.isEmpty()) {
                    Set<ModLoaderType> targetLoaders = LibraryAnalyzer.analyze(game, gameVersion).getModLoaders();
                    block0: for (RemoteMod.Version modVersion : modVersions) {
                        for (ModLoaderType loader : modVersion.getLoaders()) {
                            if (!targetLoaders.contains((Object)loader)) continue;
                            list.getContent().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("mods.download.recommend", gameVersion)), new ModItem(control.addon, modVersion, control)});
                            break block0;
                        }
                    }
                }
                for (String gameVersion2 : control.versions.keys().stream().sorted(Collections.reverseOrder(GameVersionNumber::compare)).collect(Collectors.toList())) {
                    List<RemoteMod.Version> versions = control.versions.get(gameVersion2);
                    if (versions == null || versions.isEmpty()) continue;
                    ComponentList sublist = new ComponentList(() -> {
                        ArrayList<ModItem> items = new ArrayList<ModItem>(versions.size());
                        for (RemoteMod.Version v : versions) {
                            items.add(new ModItem(control.addon, v, control));
                        }
                        return items;
                    });
                    sublist.getStyleClass().add((Object)"no-padding");
                    sublist.setTitle("Minecraft " + gameVersion2);
                    list.getContent().add((Object)sublist);
                }
            });
            this.getChildren().setAll((Object[])new Node[]{scrollPane});
        }
    }

    private static final class ModVersion
    extends JFXDialogLayout {
        public ModVersion(RemoteMod mod, RemoteMod.Version version, DownloadPage selfPage) {
            RemoteModRepository.Type type = selfPage.repository.getType();
            String title = switch (type) {
                case RemoteModRepository.Type.WORLD -> "world.download.title";
                case RemoteModRepository.Type.MODPACK -> "modpack.download.title";
                case RemoteModRepository.Type.RESOURCE_PACK -> "resourcepack.download.title";
                case RemoteModRepository.Type.SHADER_PACK -> "shaderpack.download.title";
                default -> "mods.download.title";
            };
            this.setHeading(new Node[]{new HBox(new Node[]{new Label(I18n.i18n(title, version.getName()))})});
            VBox box = new VBox(8.0);
            box.setPadding(new Insets(8.0));
            ModItem modItem = new ModItem(mod, version, selfPage);
            modItem.setMouseTransparent(true);
            box.getChildren().setAll((Object[])new Node[]{modItem});
            SpinnerPane spinnerPane = new SpinnerPane();
            ScrollPane scrollPane = new ScrollPane();
            ComponentList dependenciesList = new ComponentList(() -> Lang.immutableListOf(new Node[0]));
            this.loadDependencies(version, selfPage, spinnerPane, dependenciesList);
            spinnerPane.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> this.loadDependencies(version, selfPage, spinnerPane, dependenciesList)));
            scrollPane.setContent((Node)dependenciesList);
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            spinnerPane.setContent((Node)scrollPane);
            box.getChildren().add((Object)spinnerPane);
            VBox.setVgrow((Node)spinnerPane, (Priority)Priority.SOMETIMES);
            this.setBody(new Node[]{box});
            JFXButton downloadButton = null;
            if (selfPage.callback != null) {
                downloadButton = new JFXButton(type == RemoteModRepository.Type.MODPACK ? I18n.i18n("install.modpack") : I18n.i18n("mods.install"));
                downloadButton.getStyleClass().add((Object)"dialog-accept");
                downloadButton.setOnAction(e -> {
                    if (type == RemoteModRepository.Type.MODPACK || !spinnerPane.isLoading() && spinnerPane.getFailedReason() == null) {
                        this.fireEvent(new DialogCloseEvent());
                    }
                    selfPage.download(mod, version);
                });
            }
            JFXButton saveAsButton = new JFXButton(I18n.i18n("mods.save_as"));
            saveAsButton.getStyleClass().add((Object)"dialog-accept");
            saveAsButton.setOnAction(e -> {
                if (!spinnerPane.isLoading() && spinnerPane.getFailedReason() == null) {
                    this.fireEvent(new DialogCloseEvent());
                }
                selfPage.saveAs(mod, version);
            });
            JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
            cancelButton.getStyleClass().add((Object)"dialog-cancel");
            cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            if (downloadButton == null) {
                this.setActions(new Node[]{saveAsButton, cancelButton});
            } else {
                this.setActions(new Node[]{downloadButton, saveAsButton, cancelButton});
            }
            this.prefWidthProperty().bind(BindingMapping.of(Controllers.getStage().widthProperty()).map(w -> w.doubleValue() * 0.7));
            this.prefHeightProperty().bind(BindingMapping.of(Controllers.getStage().heightProperty()).map(w -> w.doubleValue() * 0.7));
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
        }

        private void loadDependencies(RemoteMod.Version version, DownloadPage selfPage, SpinnerPane spinnerPane, ComponentList dependenciesList) {
            spinnerPane.setLoading(true);
            Task.supplyAsync(() -> {
                EnumMap dependencies = new EnumMap(RemoteMod.DependencyType.class);
                for (RemoteMod.Dependency dependency : version.getDependencies()) {
                    if (dependency.getType() == RemoteMod.DependencyType.INCOMPATIBLE || dependency.getType() == RemoteMod.DependencyType.BROKEN) continue;
                    if (!dependencies.containsKey((Object)dependency.getType())) {
                        ArrayList<Label> list = new ArrayList<Label>();
                        Label title = new Label(I18n.i18n(DependencyModItem.I18N_KEY.get((Object)dependency.getType())));
                        title.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
                        list.add(title);
                        dependencies.put(dependency.getType(), list);
                    }
                    DependencyModItem dependencyModItem = new DependencyModItem(selfPage.page, dependency.load(), selfPage.version, selfPage.callback);
                    ((List)dependencies.get((Object)dependency.getType())).add(dependencyModItem);
                }
                return dependencies.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }).whenComplete(Schedulers.javafx(), (result, exception) -> {
                spinnerPane.setLoading(false);
                if (exception == null) {
                    dependenciesList.getContent().setAll((Collection)result);
                    spinnerPane.setFailedReason(null);
                } else {
                    dependenciesList.getContent().setAll((Object[])new Node[0]);
                    spinnerPane.setFailedReason(I18n.i18n("download.failed.refresh"));
                }
            }).start();
        }
    }

    private static final class ModItem
    extends StackPane {
        ModItem(RemoteMod mod, RemoteMod.Version dataItem, DownloadPage selfPage) {
            VBox pane = new VBox(8.0);
            pane.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
            HBox descPane = new HBox(8.0);
            descPane.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
            descPane.setAlignment(Pos.CENTER_LEFT);
            descPane.setMouseTransparent(true);
            StackPane graphicPane = new StackPane();
            TwoLineListItem content = new TwoLineListItem();
            HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            content.setTitle(dataItem.getName());
            content.setSubtitle(I18n.formatDateTime(dataItem.getDatePublished()));
            switch (dataItem.getVersionType()) {
                case Alpha: {
                    content.addTag(I18n.i18n("mods.channel.alpha"));
                    graphicPane.getChildren().setAll((Object[])new Node[]{SVG.ALPHA_CIRCLE.createIcon(24.0)});
                    break;
                }
                case Beta: {
                    content.addTag(I18n.i18n("mods.channel.beta"));
                    graphicPane.getChildren().setAll((Object[])new Node[]{SVG.BETA_CIRCLE.createIcon(24.0)});
                    break;
                }
                case Release: {
                    content.addTag(I18n.i18n("mods.channel.release"));
                    graphicPane.getChildren().setAll((Object[])new Node[]{SVG.RELEASE_CIRCLE.createIcon(24.0)});
                }
            }
            for (ModLoaderType modLoaderType : dataItem.getLoaders()) {
                switch (modLoaderType) {
                    case FORGE: {
                        content.addTag(I18n.i18n("install.installer.forge"));
                        break;
                    }
                    case CLEANROOM: {
                        content.addTag(I18n.i18n("install.installer.cleanroom"));
                        break;
                    }
                    case NEO_FORGED: {
                        content.addTag(I18n.i18n("install.installer.neoforge"));
                        break;
                    }
                    case FABRIC: {
                        content.addTag(I18n.i18n("install.installer.fabric"));
                        break;
                    }
                    case LITE_LOADER: {
                        content.addTag(I18n.i18n("install.installer.liteloader"));
                        break;
                    }
                    case QUILT: {
                        content.addTag(I18n.i18n("install.installer.quilt"));
                    }
                }
            }
            descPane.getChildren().setAll((Object[])new Node[]{graphicPane, content});
            pane.getChildren().add((Object)descPane);
            RipplerContainer container = new RipplerContainer((Node)pane);
            FXUtils.onClicked((Node)container, () -> Controllers.dialog((Region)new ModVersion(mod, dataItem, selfPage)));
            this.getChildren().setAll((Object[])new Node[]{container});
            this.setMinHeight(50.0);
        }
    }

    private static final class DependencyModItem
    extends StackPane {
        public static final EnumMap<RemoteMod.DependencyType, String> I18N_KEY = new EnumMap(Lang.mapOf(Pair.pair(RemoteMod.DependencyType.EMBEDDED, "mods.dependency.embedded"), Pair.pair(RemoteMod.DependencyType.OPTIONAL, "mods.dependency.optional"), Pair.pair(RemoteMod.DependencyType.REQUIRED, "mods.dependency.required"), Pair.pair(RemoteMod.DependencyType.TOOL, "mods.dependency.tool"), Pair.pair(RemoteMod.DependencyType.INCLUDE, "mods.dependency.include"), Pair.pair(RemoteMod.DependencyType.INCOMPATIBLE, "mods.dependency.incompatible"), Pair.pair(RemoteMod.DependencyType.BROKEN, "mods.dependency.broken")));

        DependencyModItem(DownloadListPage page, RemoteMod addon, Profile.ProfileVersion version, DownloadCallback callback) {
            HBox pane = new HBox(8.0);
            pane.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
            pane.setAlignment(Pos.CENTER_LEFT);
            TwoLineListItem content = new TwoLineListItem();
            HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
            ImageView imageView = new ImageView();
            imageView.setFitWidth(40.0);
            imageView.setFitHeight(40.0);
            pane.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)imageView, 40.0, 40.0), content});
            RipplerContainer container = new RipplerContainer((Node)pane);
            FXUtils.onClicked((Node)container, () -> {
                this.fireEvent(new DialogCloseEvent());
                Controllers.navigate((Node)new DownloadPage(page, addon, version, callback));
            });
            this.getChildren().setAll((Object[])new Node[]{container});
            if (addon != RemoteMod.BROKEN) {
                ModTranslations.Mod mod = ModTranslations.getTranslationsByRepositoryType(page.repository.getType()).getModByCurseForgeId(addon.getSlug());
                content.setTitle(mod != null && I18n.isUseChinese() ? mod.getDisplayName() : addon.getTitle());
                content.setSubtitle(addon.getDescription());
                for (String category : addon.getCategories()) {
                    if (!page.shouldDisplayCategory(category)) continue;
                    content.addTag(page.getLocalizedCategory(category));
                }
                if (StringUtils.isNotBlank(addon.getIconUrl())) {
                    imageView.imageProperty().bind(FXUtils.newRemoteImage(addon.getIconUrl(), 80, 80, true, true));
                }
            } else {
                content.setTitle(I18n.i18n("mods.broken_dependency.title"));
                content.setSubtitle(I18n.i18n("mods.broken_dependency.desc"));
                imageView.setImage(FXUtils.newBuiltinImage("/assets/img/icon@4x.png"));
            }
        }
    }
}

