/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.JFXRadioButton;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.GameListItem;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class GameListCell
extends ListCell<GameListItem> {
    private final Region graphic;
    private final ImageView imageView;
    private final TwoLineListItem content;
    private final JFXRadioButton chkSelected;
    private final JFXButton btnUpgrade;
    private final JFXButton btnLaunch;
    private final JFXButton btnManage;
    private final HBox right;
    private final StringProperty tag = new SimpleStringProperty();

    public GameListCell() {
        BorderPane root = new BorderPane();
        root.getStyleClass().add((Object)"md-list-cell");
        root.setPadding(new Insets(8.0, 8.0, 8.0, 0.0));
        RipplerContainer container = new RipplerContainer((Node)root);
        this.graphic = container;
        this.chkSelected = new JFXRadioButton(){

            public void fire() {
                if (!this.isDisable() && !this.isSelected()) {
                    this.fireEvent((Event)new ActionEvent());
                    GameListItem item = (GameListItem)GameListCell.this.getItem();
                    if (item != null) {
                        item.getProfile().setSelectedVersion(item.getId());
                    }
                }
            }
        };
        root.setLeft((Node)this.chkSelected);
        BorderPane.setAlignment((Node)this.chkSelected, (Pos)Pos.CENTER);
        HBox center = new HBox();
        center.setMouseTransparent(true);
        root.setCenter((Node)center);
        center.setPrefWidth(Double.NEGATIVE_INFINITY);
        center.setSpacing(8.0);
        center.setAlignment(Pos.CENTER_LEFT);
        this.imageView = new ImageView();
        FXUtils.limitSize(this.imageView, 32.0, 32.0);
        this.content = new TwoLineListItem();
        BorderPane.setAlignment((Node)this.content, (Pos)Pos.CENTER);
        FXUtils.onChangeAndOperate(this.tag, tag -> {
            this.content.getTags().clear();
            if (StringUtils.isNotBlank(tag)) {
                this.content.addTag((String)tag);
            }
        });
        center.getChildren().setAll((Object[])new Node[]{this.imageView, this.content});
        this.right = new HBox();
        root.setRight((Node)this.right);
        this.right.setAlignment(Pos.CENTER_RIGHT);
        this.btnUpgrade = new JFXButton();
        this.btnUpgrade.setOnAction(e -> {
            GameListItem item = (GameListItem)this.getItem();
            if (item != null) {
                item.update();
            }
        });
        this.btnUpgrade.getStyleClass().add((Object)"toggle-icon4");
        this.btnUpgrade.setGraphic(FXUtils.limitingSize(SVG.UPDATE.createIcon(24.0), 24.0, 24.0));
        FXUtils.installFastTooltip((Node)this.btnUpgrade, I18n.i18n("version.update"));
        this.right.getChildren().add((Object)this.btnUpgrade);
        this.btnLaunch = new JFXButton();
        this.btnLaunch.setOnAction(e -> {
            GameListItem item = (GameListItem)this.getItem();
            if (item != null) {
                item.testGame();
            }
        });
        this.btnLaunch.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)this.btnLaunch, (Pos)Pos.CENTER);
        this.btnLaunch.setGraphic(FXUtils.limitingSize(SVG.ROCKET_LAUNCH.createIcon(24.0), 24.0, 24.0));
        FXUtils.installFastTooltip((Node)this.btnLaunch, I18n.i18n("version.launch.test"));
        this.right.getChildren().add((Object)this.btnLaunch);
        this.btnManage = new JFXButton();
        this.btnManage.setOnAction(e -> {
            JFXPopup.PopupVPosition vPosition;
            JFXPopup popup;
            GameListItem item = (GameListItem)this.getItem();
            if (item == null) {
                return;
            }
            popup.show((Node)root, vPosition, JFXPopup.PopupHPosition.RIGHT, 0.0, (vPosition = FXUtils.determineOptimalPopupPosition((Node)root, popup = GameListCell.getPopup(item))) == JFXPopup.PopupVPosition.TOP ? root.getHeight() : -root.getHeight());
        });
        this.btnManage.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)this.btnManage, (Pos)Pos.CENTER);
        this.btnManage.setGraphic(FXUtils.limitingSize(SVG.MORE_VERT.createIcon(24.0), 24.0, 24.0));
        FXUtils.installFastTooltip((Node)this.btnManage, I18n.i18n("settings.game.management"));
        this.right.getChildren().add((Object)this.btnManage);
        root.setCursor(Cursor.HAND);
        container.setOnMouseClicked(e -> {
            GameListItem item = (GameListItem)this.getItem();
            if (item == null) {
                return;
            }
            if (e.getButton() == MouseButton.PRIMARY) {
                if (e.getClickCount() == 1) {
                    item.modifyGameSettings();
                }
            } else if (e.getButton() == MouseButton.SECONDARY) {
                JFXPopup popup = GameListCell.getPopup(item);
                JFXPopup.PopupVPosition vPosition = FXUtils.determineOptimalPopupPosition((Node)root, popup);
                popup.show((Node)root, vPosition, JFXPopup.PopupHPosition.LEFT, e.getX(), vPosition == JFXPopup.PopupVPosition.TOP ? e.getY() : e.getY() - root.getHeight());
            }
        });
    }

    public void updateItem(GameListItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.imageView.imageProperty().unbind();
        this.content.titleProperty().unbind();
        this.content.subtitleProperty().unbind();
        this.tag.unbind();
        this.right.getChildren().clear();
        this.chkSelected.selectedProperty().unbind();
        if (empty || item == null) {
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)this.graphic);
            this.chkSelected.selectedProperty().bind((ObservableValue)item.selectedProperty());
            this.imageView.imageProperty().bind(item.imageProperty());
            this.content.titleProperty().bind((ObservableValue)item.titleProperty());
            this.content.subtitleProperty().bind((ObservableValue)item.subtitleProperty());
            this.tag.bind((ObservableValue)item.tagProperty());
            if (item.canUpdate()) {
                this.right.getChildren().add((Object)this.btnUpgrade);
            }
            this.right.getChildren().addAll((Object[])new Node[]{this.btnLaunch, this.btnManage});
        }
    }

    private static JFXPopup getPopup(GameListItem item) {
        PopupMenu menu = new PopupMenu();
        JFXPopup popup = new JFXPopup((Region)menu);
        Object[] objectArray = new Node[11];
        objectArray[0] = new IconedMenuItem(SVG.ROCKET_LAUNCH, I18n.i18n("version.launch.test"), item::testGame, popup);
        objectArray[1] = new IconedMenuItem(SVG.SCRIPT, I18n.i18n("version.launch_script"), item::generateLaunchScript, popup);
        objectArray[2] = new MenuSeparator();
        objectArray[3] = new IconedMenuItem(SVG.SETTINGS, I18n.i18n("version.manage.manage"), item::modifyGameSettings, popup);
        objectArray[4] = new MenuSeparator();
        objectArray[5] = new IconedMenuItem(SVG.EDIT, I18n.i18n("version.manage.rename"), item::rename, popup);
        objectArray[6] = new IconedMenuItem(SVG.FOLDER_COPY, I18n.i18n("version.manage.duplicate"), item::duplicate, popup);
        objectArray[7] = new IconedMenuItem(SVG.DELETE, I18n.i18n("version.manage.remove"), item::remove, popup);
        objectArray[8] = new IconedMenuItem(SVG.OUTPUT, I18n.i18n("modpack.export"), item::export, popup);
        objectArray[9] = new MenuSeparator();
        objectArray[10] = new IconedMenuItem(SVG.FOLDER_OPEN, I18n.i18n("folder.game"), item::browse, popup);
        menu.getContent().setAll(objectArray);
        return popup;
    }
}

