/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jackhuang.hmcl.util.function.ExceptionalPredicate;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public final class Zipper
implements Closeable {
    private final ZipOutputStream zos;
    private final byte[] buffer = new byte[8192];
    private final Set<String> entryNames;

    public Zipper(Path zipFile) throws IOException {
        this(zipFile, false);
    }

    public Zipper(Path zipFile, boolean allowDuplicateEntry) throws IOException {
        this.zos = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]), StandardCharsets.UTF_8);
        this.entryNames = allowDuplicateEntry ? new HashSet() : null;
    }

    private static String normalize(String path) {
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private ZipEntry newEntry(String name) throws IOException {
        if (this.entryNames == null || name.endsWith("/") || this.entryNames.add(name)) {
            return new ZipEntry(name);
        }
        for (int i = 1; i < 10; ++i) {
            String newName = name + "." + i;
            if (!this.entryNames.add(newName)) continue;
            return new ZipEntry(newName);
        }
        throw new ZipException("duplicate entry: " + name);
    }

    private static String resolve(String dir, String file) {
        if (dir.isEmpty()) {
            return file;
        }
        if (file.isEmpty()) {
            return dir;
        }
        return dir + "/" + file;
    }

    @Override
    public void close() throws IOException {
        this.zos.close();
    }

    public void putDirectory(Path source, String targetDir) throws IOException {
        this.putDirectory(source, targetDir, null);
    }

    public void putDirectory(final Path source, String targetDir, final ExceptionalPredicate<String, IOException> filter) throws IOException {
        final String root = Zipper.normalize(targetDir);
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (".DS_Store".equals(file.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String relativePath = Zipper.normalize(source.relativize(file).normalize().toString());
                if (filter != null && !filter.test(relativePath)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Zipper.this.putFile(file, Zipper.resolve(root, relativePath));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePath = Zipper.normalize(source.relativize(dir).normalize().toString());
                if (filter != null && !filter.test(relativePath)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                try {
                    Zipper.this.zos.putNextEntry(new ZipEntry(Zipper.resolve(root, relativePath) + "/"));
                    Zipper.this.zos.closeEntry();
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void putFile(Path file, String path) throws IOException {
        path = Zipper.normalize(path);
        BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        ZipEntry entry = this.newEntry((String)(attrs.isDirectory() ? path + "/" : path));
        entry.setCreationTime(attrs.creationTime());
        entry.setLastAccessTime(attrs.lastAccessTime());
        entry.setLastModifiedTime(attrs.lastModifiedTime());
        if (attrs.isDirectory()) {
            try {
                this.zos.putNextEntry(entry);
                this.zos.closeEntry();
            }
            catch (ZipException zipException) {}
        } else {
            try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                this.zos.putNextEntry(entry);
                IOUtils.copyTo(input, this.zos, this.buffer);
                this.zos.closeEntry();
            }
        }
    }

    public void putStream(InputStream in, String path) throws IOException {
        this.zos.putNextEntry(this.newEntry(Zipper.normalize(path)));
        IOUtils.copyTo(in, this.zos, this.buffer);
        this.zos.closeEntry();
    }

    public OutputStream putStream(String path) throws IOException {
        this.zos.putNextEntry(this.newEntry(Zipper.normalize(path)));
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                Zipper.this.zos.write(b);
            }

            @Override
            public void write(@NotNull byte[] b) throws IOException {
                Zipper.this.zos.write(b);
            }

            @Override
            public void write(@NotNull byte[] b, int off, int len) throws IOException {
                Zipper.this.zos.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                Zipper.this.zos.flush();
            }

            @Override
            public void close() throws IOException {
                Zipper.this.zos.closeEntry();
            }
        };
    }

    public void putLines(Stream<String> lines, String path) throws IOException {
        this.zos.putNextEntry(this.newEntry(Zipper.normalize(path)));
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.zos));
            lines.forEachOrdered(line -> {
                try {
                    writer.write((String)line);
                    writer.write(10);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            writer.flush();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.zos.closeEntry();
        }
    }

    public void putTextFile(String text, String path) throws IOException {
        this.putTextFile(text, StandardCharsets.UTF_8, path);
    }

    public void putTextFile(String text, Charset encoding, String path) throws IOException {
        this.zos.putNextEntry(this.newEntry(Zipper.normalize(path)));
        this.zos.write(text.getBytes(encoding));
        this.zos.closeEntry();
    }
}

