/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.ComponentSublistWrapper;
import org.jackhuang.hmcl.ui.construct.ControlSkinBase;
import org.jackhuang.hmcl.ui.construct.NoPaddingComponent;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class ComponentList
extends Control
implements NoPaddingComponent {
    private final ObservableList<Node> content = FXCollections.observableArrayList();

    public ComponentList() {
        this.getStyleClass().add((Object)"options-list");
    }

    public ObservableList<Node> getContent() {
        return this.content;
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    protected javafx.scene.control.Skin<?> createDefaultSkin() {
        return new Skin(this);
    }

    public static Node createComponentListTitle(String title) {
        HBox node = new HBox();
        node.setAlignment(Pos.CENTER_LEFT);
        node.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        Label advanced = new Label(title);
        node.getChildren().setAll((Object[])new Node[]{advanced});
        return node;
    }

    public static void setVgrow(Node node, Priority priority) {
        node.getProperties().put((Object)"ComponentList.vgrow", (Object)priority);
    }

    public static void setNoPadding(Node node) {
        node.getProperties().put((Object)"ComponentList.noPadding", (Object)true);
    }

    private static final class Skin
    extends ControlSkinBase<ComponentList> {
        private static final PseudoClass PSEUDO_CLASS_FIRST = PseudoClass.getPseudoClass((String)"first");
        private static final PseudoClass PSEUDO_CLASS_LAST = PseudoClass.getPseudoClass((String)"last");
        private final ObservableList<Node> list;
        private Node prevFirstItem;
        private Node prevLastItem;

        Skin(ComponentList control) {
            super(control);
            this.list = MappedObservableList.create(control.getContent(), node -> {
                Object wrapper;
                if (node instanceof ComponentSublist) {
                    ComponentSublist sublist = (ComponentSublist)node;
                    sublist.getStyleClass().remove((Object)"options-list");
                    sublist.getStyleClass().add((Object)"options-sublist");
                    wrapper = new ComponentSublistWrapper(sublist);
                } else {
                    wrapper = new StackPane(new Node[]{node});
                }
                wrapper.getStyleClass().add((Object)"options-list-item");
                Object patt0$temp = node.getProperties().get((Object)"ComponentList.vgrow");
                if (patt0$temp instanceof Priority) {
                    Priority priority = (Priority)patt0$temp;
                    VBox.setVgrow((Node)wrapper, (Priority)priority);
                }
                if (node instanceof NoPaddingComponent || node.getProperties().containsKey((Object)"ComponentList.noPadding")) {
                    wrapper.getStyleClass().add((Object)"no-padding");
                }
                return wrapper;
            });
            this.updateStyle();
            this.list.addListener(o -> this.updateStyle());
            VBox vbox = new VBox();
            vbox.setFillWidth(true);
            Bindings.bindContent((List)vbox.getChildren(), this.list);
            this.node = vbox;
        }

        private void updateStyle() {
            Node lastItem;
            Node firstItem;
            if (this.list.isEmpty()) {
                firstItem = null;
                lastItem = null;
            } else {
                firstItem = (Node)this.list.get(0);
                lastItem = (Node)this.list.get(this.list.size() - 1);
            }
            if (firstItem != this.prevFirstItem) {
                if (this.prevFirstItem != null) {
                    this.prevFirstItem.pseudoClassStateChanged(PSEUDO_CLASS_FIRST, false);
                }
                if (firstItem != null) {
                    firstItem.pseudoClassStateChanged(PSEUDO_CLASS_FIRST, true);
                }
                this.prevFirstItem = firstItem;
            }
            if (lastItem != this.prevLastItem) {
                if (this.prevLastItem != null) {
                    this.prevLastItem.pseudoClassStateChanged(PSEUDO_CLASS_LAST, false);
                }
                if (lastItem != null) {
                    lastItem.pseudoClassStateChanged(PSEUDO_CLASS_LAST, true);
                }
                this.prevLastItem = lastItem;
            }
        }
    }
}

