/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.BorderPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.LinePane;

public final class LineTextPane
extends LinePane {
    private static final String DEFAULT_STYLE_CLASS = "line-label-pane";
    private StringProperty text;

    public LineTextPane() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public StringProperty textProperty() {
        if (this.text == null) {
            this.text = new StringPropertyBase(){
                private static final Insets LABEL_MARGIN = new Insets(0.0, 8.0, 0.0, 16.0);
                private Label rightLabel;

                public Object getBean() {
                    return LineTextPane.this;
                }

                public String getName() {
                    return "text";
                }

                protected void invalidated() {
                    String text = this.get();
                    if (text == null || text.isEmpty()) {
                        if (this.rightLabel != null) {
                            this.rightLabel.setText(null);
                        }
                        LineTextPane.this.setRight(null);
                    } else {
                        if (this.rightLabel == null) {
                            this.rightLabel = FXUtils.newSafeTruncatedLabel();
                            FXUtils.copyOnDoubleClick((Labeled)this.rightLabel);
                            BorderPane.setMargin((Node)this.rightLabel, (Insets)LABEL_MARGIN);
                            BorderPane.setAlignment((Node)this.rightLabel, (Pos)Pos.CENTER_RIGHT);
                        }
                        this.rightLabel.setText(text);
                        LineTextPane.this.setRight((Node)this.rightLabel);
                    }
                }
            };
        }
        return this.text;
    }

    public String getText() {
        return (String)this.textProperty().get();
    }

    public void setText(String text) {
        this.textProperty().set((Object)text);
    }
}

