/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.LineSelectButton;
import org.jackhuang.hmcl.ui.construct.LineToggleButton;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;

public class DownloadSettingsPage
extends StackPane {
    private final WeakListenerHolder holder = new WeakListenerHolder();

    public DownloadSettingsPage() {
        VBox content = new VBox(10.0);
        content.setPadding(new Insets(10.0));
        content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        FXUtils.smoothScrolling(scrollPane);
        scrollPane.setFitToWidth(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
        ComponentList downloadSource = new ComponentList();
        downloadSource.getStyleClass().add((Object)"card-non-transparent");
        LineToggleButton autoChooseDownloadSource = new LineToggleButton();
        autoChooseDownloadSource.setTitle(I18n.i18n("settings.launcher.download_source.auto"));
        autoChooseDownloadSource.selectedProperty().bindBidirectional((Property)ConfigHolder.config().autoChooseDownloadTypeProperty());
        Function<String, String> converter = key -> I18n.i18n("download.provider." + key);
        Function<String, String> descriptionConverter = key -> {
            String bundleKey = "download.provider." + key + ".desc";
            return I18n.hasKey(bundleKey) ? I18n.i18n(bundleKey) : null;
        };
        LineSelectButton versionListSourcePane = new LineSelectButton();
        versionListSourcePane.disableProperty().bind((ObservableValue)autoChooseDownloadSource.selectedProperty().not());
        versionListSourcePane.setTitle(I18n.i18n("settings.launcher.version_list_source"));
        versionListSourcePane.setConverter(converter);
        versionListSourcePane.setDescriptionConverter(descriptionConverter);
        versionListSourcePane.setItems(DownloadProviders.AUTO_PROVIDERS.keySet());
        versionListSourcePane.valueProperty().bindBidirectional((Property)ConfigHolder.config().versionListSourceProperty());
        LineSelectButton downloadSourcePane = new LineSelectButton();
        downloadSourcePane.disableProperty().bind((ObservableValue)autoChooseDownloadSource.selectedProperty());
        downloadSourcePane.setTitle(I18n.i18n("settings.launcher.download_source"));
        downloadSourcePane.setConverter(converter);
        downloadSourcePane.setDescriptionConverter(descriptionConverter);
        downloadSourcePane.setItems(DownloadProviders.DIRECT_PROVIDERS.keySet());
        downloadSourcePane.valueProperty().bindBidirectional((Property)ConfigHolder.config().downloadTypeProperty());
        downloadSource.getContent().setAll((Object[])new Node[]{autoChooseDownloadSource, versionListSourcePane, downloadSourcePane});
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.download_source")), downloadSource});
        VBox downloadThreads = new VBox(16.0);
        downloadThreads.getStyleClass().add((Object)"card-non-transparent");
        JFXCheckBox chkAutoDownloadThreads = new JFXCheckBox(I18n.i18n("settings.launcher.download.threads.auto"));
        VBox.setMargin((Node)chkAutoDownloadThreads, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        chkAutoDownloadThreads.selectedProperty().bindBidirectional((Property)ConfigHolder.config().autoDownloadThreadsProperty());
        downloadThreads.getChildren().add((Object)chkAutoDownloadThreads);
        chkAutoDownloadThreads.selectedProperty().addListener((a, b, newValue) -> {
            if (newValue.booleanValue()) {
                ConfigHolder.config().downloadThreadsProperty().set(FetchTask.DEFAULT_CONCURRENCY);
            }
        });
        HBox hbox = new HBox(8.0);
        hbox.setStyle("-fx-view-order: -1;");
        hbox.setAlignment(Pos.CENTER);
        hbox.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        hbox.disableProperty().bind((ObservableValue)ConfigHolder.config().autoDownloadThreadsProperty());
        Label label = new Label(I18n.i18n("settings.launcher.download.threads"));
        JFXSlider slider = new JFXSlider(1.0, 256.0, 64.0);
        HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
        JFXTextField threadsField = new JFXTextField();
        FXUtils.setLimitWidth((Region)threadsField, 60.0);
        FXUtils.bindInt(threadsField, (Property<Number>)ConfigHolder.config().downloadThreadsProperty());
        AtomicBoolean changedByTextField = new AtomicBoolean(false);
        FXUtils.onChangeAndOperate(ConfigHolder.config().downloadThreadsProperty(), value -> {
            changedByTextField.set(true);
            slider.setValue(value.intValue());
            changedByTextField.set(false);
        });
        slider.valueProperty().addListener((value, oldVal, newVal) -> {
            if (changedByTextField.get()) {
                return;
            }
            ConfigHolder.config().downloadThreadsProperty().set(((Number)value.getValue()).intValue());
        });
        hbox.getChildren().setAll((Object[])new Node[]{label, slider, threadsField});
        downloadThreads.getChildren().add((Object)hbox);
        HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
        VBox.setMargin((Node)hintPane, (Insets)new Insets(0.0, 0.0, 0.0, 30.0));
        hintPane.disableProperty().bind((ObservableValue)ConfigHolder.config().autoDownloadThreadsProperty());
        hintPane.setText(I18n.i18n("settings.launcher.download.threads.hint"));
        downloadThreads.getChildren().add((Object)hintPane);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("download")), downloadThreads});
        VBox proxyList = new VBox(10.0);
        proxyList.getStyleClass().add((Object)"card-non-transparent");
        HBox proxyTypePane = new HBox();
        proxyTypePane.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        ToggleGroup proxyConfigurationGroup = new ToggleGroup();
        JFXRadioButton chkProxyDefault = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.default"));
        chkProxyDefault.setUserData(null);
        chkProxyDefault.setToggleGroup(proxyConfigurationGroup);
        JFXRadioButton chkProxyNone = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.none"));
        chkProxyNone.setUserData((Object)Proxy.Type.DIRECT);
        chkProxyNone.setToggleGroup(proxyConfigurationGroup);
        JFXRadioButton chkProxyHttp = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.http"));
        chkProxyHttp.setUserData((Object)Proxy.Type.HTTP);
        chkProxyHttp.setToggleGroup(proxyConfigurationGroup);
        JFXRadioButton chkProxySocks = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.socks"));
        chkProxySocks.setUserData((Object)Proxy.Type.SOCKS);
        chkProxySocks.setToggleGroup(proxyConfigurationGroup);
        if (ConfigHolder.config().hasProxy()) {
            Proxy.Type proxyType = ConfigHolder.config().getProxyType();
            if (proxyType == Proxy.Type.DIRECT) {
                chkProxyNone.setSelected(true);
            } else if (proxyType == Proxy.Type.HTTP) {
                chkProxyHttp.setSelected(true);
            } else if (proxyType == Proxy.Type.SOCKS) {
                chkProxySocks.setSelected(true);
            } else {
                chkProxyNone.setSelected(true);
            }
        } else {
            chkProxyDefault.setSelected(true);
        }
        this.holder.add(FXUtils.onWeakChange(proxyConfigurationGroup.selectedToggleProperty(), toggle -> {
            Proxy.Type proxyType;
            Proxy.Type type = proxyType = toggle != null ? (Proxy.Type)((Object)((Object)toggle.getUserData())) : null;
            if (proxyType == null) {
                ConfigHolder.config().setHasProxy(false);
                ConfigHolder.config().setProxyType(null);
            } else {
                ConfigHolder.config().setHasProxy(true);
                ConfigHolder.config().setProxyType(proxyType);
            }
        }));
        proxyTypePane.getChildren().setAll((Object[])new Node[]{chkProxyDefault, chkProxyNone, chkProxyHttp, chkProxySocks});
        proxyList.getChildren().add((Object)proxyTypePane);
        VBox proxyPane = new VBox();
        proxyPane.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !ConfigHolder.config().hasProxy() || ConfigHolder.config().getProxyType() == null || ConfigHolder.config().getProxyType() == Proxy.Type.DIRECT, (Observable[])new Observable[]{ConfigHolder.config().hasProxyProperty(), ConfigHolder.config().proxyTypeProperty()}));
        ColumnConstraints colHgrow = new ColumnConstraints();
        colHgrow.setHgrow(Priority.ALWAYS);
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        gridPane.setHgap(20.0);
        gridPane.setVgap(10.0);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), colHgrow});
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{new RowConstraints(), new RowConstraints()});
        Label host = new Label(I18n.i18n("settings.launcher.proxy.host"));
        GridPane.setRowIndex((Node)host, (Integer)1);
        GridPane.setColumnIndex((Node)host, (Integer)0);
        gridPane.getChildren().add((Object)host);
        JFXTextField txtProxyHost = new JFXTextField();
        GridPane.setRowIndex((Node)txtProxyHost, (Integer)1);
        GridPane.setColumnIndex((Node)txtProxyHost, (Integer)1);
        gridPane.getChildren().add((Object)txtProxyHost);
        FXUtils.bindString(txtProxyHost, (Property<String>)ConfigHolder.config().proxyHostProperty());
        Label port = new Label(I18n.i18n("settings.launcher.proxy.port"));
        GridPane.setRowIndex((Node)port, (Integer)2);
        GridPane.setColumnIndex((Node)port, (Integer)0);
        gridPane.getChildren().add((Object)port);
        JFXTextField txtProxyPort = new JFXTextField();
        GridPane.setFillWidth((Node)txtProxyPort, (Boolean)false);
        txtProxyPort.setMaxWidth(200.0);
        GridPane.setRowIndex((Node)txtProxyPort, (Integer)2);
        GridPane.setColumnIndex((Node)txtProxyPort, (Integer)1);
        FXUtils.setValidateWhileTextChanged((Node)txtProxyPort, true);
        gridPane.getChildren().add((Object)txtProxyPort);
        FXUtils.bind(txtProxyPort, ConfigHolder.config().proxyPortProperty(), SafeStringConverter.fromInteger().restrict(it -> it >= 0 && it <= 65535).fallbackTo(0).asPredicate(Validator.addTo(txtProxyPort)));
        proxyPane.getChildren().add((Object)gridPane);
        VBox chkProxyAuthenticationPane = new VBox();
        chkProxyAuthenticationPane.setPadding(new Insets(20.0, 0.0, 20.0, 5.0));
        JFXCheckBox chkProxyAuthentication = new JFXCheckBox(I18n.i18n("settings.launcher.proxy.authentication"));
        chkProxyAuthenticationPane.getChildren().add((Object)chkProxyAuthentication);
        chkProxyAuthentication.selectedProperty().bindBidirectional((Property)ConfigHolder.config().hasProxyAuthProperty());
        proxyPane.getChildren().add((Object)chkProxyAuthenticationPane);
        GridPane authPane = new GridPane();
        authPane.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        authPane.setHgap(20.0);
        authPane.setVgap(10.0);
        authPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), colHgrow});
        authPane.getRowConstraints().setAll((Object[])new RowConstraints[]{new RowConstraints(), new RowConstraints()});
        authPane.disableProperty().bind((ObservableValue)ConfigHolder.config().hasProxyAuthProperty().not());
        Label username = new Label(I18n.i18n("settings.launcher.proxy.username"));
        GridPane.setRowIndex((Node)username, (Integer)0);
        GridPane.setColumnIndex((Node)username, (Integer)0);
        authPane.getChildren().add((Object)username);
        JFXTextField txtProxyUsername = new JFXTextField();
        GridPane.setRowIndex((Node)txtProxyUsername, (Integer)0);
        GridPane.setColumnIndex((Node)txtProxyUsername, (Integer)1);
        authPane.getChildren().add((Object)txtProxyUsername);
        FXUtils.bindString(txtProxyUsername, (Property<String>)ConfigHolder.config().proxyUserProperty());
        Label password = new Label(I18n.i18n("settings.launcher.proxy.password"));
        GridPane.setRowIndex((Node)password, (Integer)1);
        GridPane.setColumnIndex((Node)password, (Integer)0);
        authPane.getChildren().add((Object)password);
        JFXPasswordField txtProxyPassword = new JFXPasswordField();
        GridPane.setRowIndex((Node)txtProxyPassword, (Integer)1);
        GridPane.setColumnIndex((Node)txtProxyPassword, (Integer)1);
        authPane.getChildren().add((Object)txtProxyPassword);
        txtProxyPassword.textProperty().bindBidirectional((Property)ConfigHolder.config().proxyPassProperty());
        proxyPane.getChildren().add((Object)authPane);
        proxyList.getChildren().add((Object)proxyPane);
        content.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("settings.launcher.proxy")), proxyList});
    }
}

