/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXPopup;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.ui.versions.WorldManageUIUtils;
import org.jackhuang.hmcl.util.ChunkBaseApp;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class WorldListPage
extends ListPageBase<World>
implements VersionPage.VersionLoadable {
    private final BooleanProperty showAll = new SimpleBooleanProperty((Object)this, "showAll", false);
    private Path savesDir;
    private List<World> worlds;
    private Profile profile;
    private String instanceId;
    private int refreshCount = 0;

    public WorldListPage() {
        FXUtils.applyDragListener((Node)this, it -> "zip".equals(FileUtils.getExtension(it)), modpacks -> this.installWorld((Path)modpacks.get(0)));
        this.showAll.addListener(e -> this.updateWorldList());
    }

    protected Skin<WorldListPage> createDefaultSkin() {
        return new WorldListPageSkin();
    }

    @Override
    public void loadVersion(Profile profile, String id) {
        this.profile = profile;
        this.instanceId = id;
        this.savesDir = profile.getRepository().getSavesDirectory(id);
        this.refresh();
    }

    private void updateWorldList() {
        if (this.worlds == null) {
            this.getItems().clear();
        } else if (this.showAll.get()) {
            this.getItems().setAll(this.worlds);
        } else {
            GameVersionNumber gameVersion = this.profile.getRepository().getGameVersion(this.instanceId).map(GameVersionNumber::asGameVersion).orElse(null);
            this.getItems().setAll(this.worlds.stream().filter(world -> world.getGameVersion() == null || world.getGameVersion().equals(gameVersion)).toList());
        }
    }

    public void refresh() {
        if (this.profile == null || this.instanceId == null) {
            return;
        }
        int currentRefresh = ++this.refreshCount;
        this.setLoading(true);
        Task.supplyAsync(Schedulers.io(), () -> {
            this.profile.getRepository().getGameVersion(this.instanceId);
            return World.getWorlds(this.savesDir);
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (this.refreshCount != currentRefresh) {
                return;
            }
            this.worlds = result;
            this.updateWorldList();
            if (exception != null) {
                Logger.LOG.warning("Failed to load world list page", exception);
            }
            this.setLoading(false);
        }).start();
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("world.import.choose"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("world.extension"), new String[]{"*.zip"})});
        List<Path> res = FileUtils.toPaths(chooser.showOpenMultipleDialog((Window)Controllers.getStage()));
        if (res == null || res.isEmpty()) {
            return;
        }
        this.installWorld(res.get(0));
    }

    public void download() {
        Controllers.getDownloadPage().showWorldDownloads();
        Controllers.navigate((Node)Controllers.getDownloadPage());
    }

    private void installWorld(Path zipFile) {
        Task.supplyAsync(() -> new World(zipFile)).whenComplete(Schedulers.javafx(), world -> Controllers.prompt(I18n.i18n("world.name.enter"), (name, handler) -> Task.runAsync(() -> world.install(this.savesDir, (String)name)).whenComplete(Schedulers.javafx(), () -> {
            handler.resolve();
            this.refresh();
        }, e -> {
            if (e instanceof FileAlreadyExistsException) {
                handler.reject(I18n.i18n("world.import.failed", I18n.i18n("world.import.already_exists")));
            } else if (e instanceof IOException && e.getCause() instanceof InvalidPathException) {
                handler.reject(I18n.i18n("world.import.failed", I18n.i18n("install.new_game.malformed")));
            } else {
                handler.reject(I18n.i18n("world.import.failed", e.getClass().getName() + ": " + e.getLocalizedMessage()));
            }
        }).start(), world.getWorldName(), new Validator(I18n.i18n("install.new_game.malformed"), FileUtils::isNameValid)), e -> {
            Logger.LOG.warning("Unable to parse world file " + String.valueOf(zipFile), (Throwable)e);
            Controllers.dialog(I18n.i18n("world.import.invalid"));
        }).start();
    }

    private void showManagePage(World world) {
        Controllers.navigate((Node)new WorldManagePage(world, this.profile, this.instanceId));
    }

    public void export(World world) {
        WorldManageUIUtils.export(world);
    }

    public void delete(World world) {
        WorldManageUIUtils.delete(world, this::refresh);
    }

    public void copy(World world) {
        WorldManageUIUtils.copyWorld(world, this::refresh);
    }

    public void reveal(World world) {
        FXUtils.openFolder(world.getFile());
    }

    public void launch(World world) {
        Versions.launchAndEnterWorld(this.profile, this.instanceId, world.getFileName());
    }

    public void generateLaunchScript(World world) {
        Versions.generateLaunchScriptForQuickEnterWorld(this.profile, this.instanceId, world.getFileName());
    }

    public BooleanProperty showAllProperty() {
        return this.showAll;
    }

    private final class WorldListPageSkin
    extends ToolbarListPageSkin<World, WorldListPage> {
        WorldListPageSkin() {
            super(WorldListPage.this);
        }

        @Override
        protected List<Node> initializeToolbar(WorldListPage skinnable) {
            JFXCheckBox chkShowAll = new JFXCheckBox(I18n.i18n("world.show_all"));
            chkShowAll.selectedProperty().bindBidirectional((Property)skinnable.showAllProperty());
            Node[] nodeArray = new Node[4];
            nodeArray[0] = chkShowAll;
            nodeArray[1] = WorldListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh);
            nodeArray[2] = WorldListPageSkin.createToolbarButton2(I18n.i18n("world.add"), SVG.ADD, skinnable::add);
            nodeArray[3] = WorldListPageSkin.createToolbarButton2(I18n.i18n("world.download"), SVG.DOWNLOAD, skinnable::download);
            return Arrays.asList(nodeArray);
        }

        @Override
        protected ListCell<World> createListCell(JFXListView<World> listView) {
            return new WorldListCell((WorldListPage)this.getSkinnable());
        }
    }

    private static final class WorldListCell
    extends ListCell<World> {
        private final WorldListPage page;
        private final RipplerContainer graphic;
        private final ImageView imageView;
        private final Tooltip leftTooltip;
        private final TwoLineListItem content;
        private final JFXButton btnLaunch;

        public WorldListCell(WorldListPage page) {
            this.page = page;
            BorderPane root = new BorderPane();
            root.getStyleClass().add((Object)"md-list-cell");
            root.setPadding(new Insets(8.0));
            StackPane left = new StackPane();
            this.leftTooltip = new Tooltip();
            FXUtils.installSlowTooltip((Node)left, this.leftTooltip);
            root.setLeft((Node)left);
            left.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
            this.imageView = new ImageView();
            left.getChildren().add((Object)this.imageView);
            FXUtils.limitSize(this.imageView, 32.0, 32.0);
            this.content = new TwoLineListItem();
            root.setCenter((Node)this.content);
            this.content.setMouseTransparent(true);
            HBox right = new HBox(8.0);
            root.setRight((Node)right);
            right.setAlignment(Pos.CENTER_RIGHT);
            this.btnLaunch = new JFXButton();
            right.getChildren().add((Object)this.btnLaunch);
            this.btnLaunch.getStyleClass().add((Object)"toggle-icon4");
            this.btnLaunch.setGraphic(SVG.ROCKET_LAUNCH.createIcon());
            FXUtils.installFastTooltip((Node)this.btnLaunch, I18n.i18n("version.launch"));
            this.btnLaunch.setOnAction(event -> {
                World world = (World)this.getItem();
                if (world != null) {
                    page.launch(world);
                }
            });
            JFXButton btnMore = new JFXButton();
            right.getChildren().add((Object)btnMore);
            btnMore.getStyleClass().add((Object)"toggle-icon4");
            btnMore.setGraphic(SVG.MORE_VERT.createIcon());
            btnMore.setOnAction(event -> {
                World world = (World)this.getItem();
                if (world != null) {
                    this.showPopupMenu(world, JFXPopup.PopupHPosition.RIGHT, 0.0, root.getHeight());
                }
            });
            this.graphic = new RipplerContainer((Node)root);
            this.graphic.setOnMouseClicked(event -> {
                if (event.getClickCount() != 1) {
                    return;
                }
                World world = (World)this.getItem();
                if (world == null) {
                    return;
                }
                if (event.getButton() == MouseButton.PRIMARY) {
                    page.showManagePage(world);
                } else if (event.getButton() == MouseButton.SECONDARY) {
                    this.showPopupMenu(world, JFXPopup.PopupHPosition.LEFT, event.getX(), event.getY());
                }
            });
        }

        protected void updateItem(World world, boolean empty) {
            super.updateItem((Object)world, empty);
            this.content.getTags().clear();
            if (empty || world == null) {
                this.setGraphic(null);
                this.imageView.setImage(null);
                this.leftTooltip.setText("");
                this.content.setTitle("");
                this.content.setSubtitle("");
            } else {
                this.imageView.setImage(world.getIcon() == null ? FXUtils.newBuiltinImage("/assets/img/unknown_server.png") : world.getIcon());
                this.leftTooltip.setText(world.getFile().toString());
                this.content.setTitle(world.getWorldName() != null ? StringUtils.parseColorEscapes(world.getWorldName()) : "");
                if (world.getGameVersion() != null) {
                    this.content.addTag(I18n.getDisplayVersion(world.getGameVersion()));
                }
                if (world.isLocked()) {
                    this.content.addTag(I18n.i18n("world.locked"));
                    this.btnLaunch.setDisable(true);
                } else {
                    this.btnLaunch.setDisable(false);
                }
                this.content.setSubtitle(I18n.i18n("world.datetime", I18n.formatDateTime(Instant.ofEpochMilli(world.getLastPlayed()))));
                this.setGraphic((Node)this.graphic);
            }
        }

        public void showPopupMenu(World world, JFXPopup.PopupHPosition hPosition, double initOffsetX, double initOffsetY) {
            boolean worldLocked = world.isLocked();
            PopupMenu popupMenu = new PopupMenu();
            JFXPopup popup = new JFXPopup((Region)popupMenu);
            if (world.supportQuickPlay()) {
                IconedMenuItem launchItem = new IconedMenuItem(SVG.ROCKET_LAUNCH, I18n.i18n("version.launch_and_enter_world"), () -> this.page.launch(world), popup);
                launchItem.setDisable(worldLocked);
                popupMenu.getContent().add((Object)launchItem);
                popupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.SCRIPT, I18n.i18n("version.launch_script"), () -> this.page.generateLaunchScript(world), popup), new MenuSeparator()});
            }
            popupMenu.getContent().add((Object)new IconedMenuItem(SVG.SETTINGS, I18n.i18n("world.manage.button"), () -> this.page.showManagePage(world), popup));
            if (ChunkBaseApp.isSupported(world)) {
                popupMenu.getContent().addAll((Object[])new Node[]{new MenuSeparator(), new IconedMenuItem(SVG.EXPLORE, I18n.i18n("world.chunkbase.seed_map"), () -> ChunkBaseApp.openSeedMap(world), popup), new IconedMenuItem(SVG.VISIBILITY, I18n.i18n("world.chunkbase.stronghold"), () -> ChunkBaseApp.openStrongholdFinder(world), popup), new IconedMenuItem(SVG.FORT, I18n.i18n("world.chunkbase.nether_fortress"), () -> ChunkBaseApp.openNetherFortressFinder(world), popup)});
                if (ChunkBaseApp.supportEndCity(world)) {
                    popupMenu.getContent().add((Object)new IconedMenuItem(SVG.LOCATION_CITY, I18n.i18n("world.chunkbase.end_city"), () -> ChunkBaseApp.openEndCityFinder(world), popup));
                }
            }
            IconedMenuItem exportMenuItem = new IconedMenuItem(SVG.OUTPUT, I18n.i18n("world.export"), () -> this.page.export(world), popup);
            exportMenuItem.setDisable(worldLocked);
            IconedMenuItem deleteMenuItem = new IconedMenuItem(SVG.DELETE, I18n.i18n("world.delete"), () -> this.page.delete(world), popup);
            deleteMenuItem.setDisable(worldLocked);
            IconedMenuItem duplicateMenuItem = new IconedMenuItem(SVG.CONTENT_COPY, I18n.i18n("world.duplicate"), () -> this.page.copy(world), popup);
            duplicateMenuItem.setDisable(worldLocked);
            popupMenu.getContent().addAll((Object[])new Node[]{new MenuSeparator(), exportMenuItem, deleteMenuItem, duplicateMenuItem});
            popupMenu.getContent().addAll((Object[])new Node[]{new MenuSeparator(), new IconedMenuItem(SVG.FOLDER_OPEN, I18n.i18n("folder.world"), () -> this.page.reveal(world), popup)});
            JFXPopup.PopupVPosition vPosition = FXUtils.determineOptimalPopupPosition((Node)this, popup);
            popup.show((Node)this, vPosition, hPosition, initOffsetX, vPosition == JFXPopup.PopupVPosition.TOP ? initOffsetY : -initOffsetY);
        }
    }
}

