/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXPopup;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldBackupsPage;
import org.jackhuang.hmcl.ui.versions.WorldInfoPage;
import org.jackhuang.hmcl.ui.versions.WorldManageUIUtils;
import org.jackhuang.hmcl.util.ChunkBaseApp;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class WorldManagePage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final World world;
    private final Path backupsDir;
    private final Profile profile;
    private final String versionId;
    private FileChannel sessionLockChannel;
    private final ObjectProperty<DecoratorPage.State> state;
    private boolean isFirstNavigation = true;
    private final BooleanProperty refreshable = new SimpleBooleanProperty(true);
    private final BooleanProperty readOnly = new SimpleBooleanProperty(false);
    private final TransitionPane transitionPane = new TransitionPane();
    private final TabHeader header = new TabHeader(this.transitionPane, new TabControl.Tab[0]);
    private final TabControl.Tab<WorldInfoPage> worldInfoTab = new TabControl.Tab("worldInfoPage");
    private final TabControl.Tab<WorldBackupsPage> worldBackupsTab = new TabControl.Tab("worldBackupsPage");
    private final TabControl.Tab<DatapackListPage> datapackTab = new TabControl.Tab("datapackListPage");

    public WorldManagePage(World world, Profile profile, String versionId) {
        this.world = world;
        this.backupsDir = profile.getRepository().getBackupsDirectory(versionId);
        this.profile = profile;
        this.versionId = versionId;
        this.updateSessionLockChannel();
        try {
            this.world.reloadLevelDat();
        }
        catch (IOException e) {
            Logger.LOG.warning("Can not load world level.dat of world: " + String.valueOf(this.world.getFile()), e);
            this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, event -> this.closePageForLoadingFail());
        }
        this.worldInfoTab.setNodeSupplier(() -> new WorldInfoPage(this));
        this.worldBackupsTab.setNodeSupplier(() -> new WorldBackupsPage(this));
        this.datapackTab.setNodeSupplier(() -> new DatapackListPage(this));
        this.state = new SimpleObjectProperty((Object)new DecoratorPage.State(I18n.i18n("world.manage.title", StringUtils.parseColorEscapes(world.getWorldName())), null, true, true, true));
        this.addEventHandler(Navigator.NavigationEvent.EXITED, this::onExited);
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onNavigated);
    }

    @NotNull
    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    @Override
    public void refresh() {
        this.updateSessionLockChannel();
        try {
            this.world.reloadLevelDat();
        }
        catch (IOException e) {
            Logger.LOG.warning("Can not load world level.dat of world: " + String.valueOf(this.world.getFile()), e);
            this.closePageForLoadingFail();
            return;
        }
        for (TabControl.Tab tab : this.header.getTabs()) {
            Object t = tab.getNode();
            if (!(t instanceof WorldRefreshable)) continue;
            WorldRefreshable r = (WorldRefreshable)t;
            r.refresh();
        }
    }

    private void closePageForLoadingFail() {
        Platform.runLater(() -> {
            this.fireEvent(new PageCloseEvent());
            Controllers.dialog(I18n.i18n("world.load.fail"), null, MessageDialogPane.MessageType.ERROR);
        });
    }

    private void updateSessionLockChannel() {
        if (this.sessionLockChannel == null || !this.sessionLockChannel.isOpen()) {
            this.sessionLockChannel = WorldManageUIUtils.getSessionLockChannel(this.world);
            this.readOnly.set(this.sessionLockChannel == null);
        }
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (this.isFirstNavigation) {
            this.isFirstNavigation = false;
        } else {
            this.refresh();
        }
    }

    public void onExited(Navigator.NavigationEvent event) {
        try {
            WorldManageUIUtils.closeSessionLockChannel(this.world, this.sessionLockChannel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void launch() {
        this.fireEvent(new PageCloseEvent());
        Versions.launchAndEnterWorld(this.profile, this.versionId, this.world.getFileName());
    }

    public void generateLaunchScript() {
        Versions.generateLaunchScriptForQuickEnterWorld(this.profile, this.versionId, this.world.getFileName());
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public void setTitle(String title) {
        this.state.set((Object)new DecoratorPage.State(title, null, true, true, true));
    }

    public World getWorld() {
        return this.world;
    }

    public Path getBackupsDir() {
        return this.backupsDir;
    }

    public boolean isReadOnly() {
        return this.readOnly.get();
    }

    public BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    @Override
    public BooleanProperty refreshableProperty() {
        return this.refreshable;
    }

    public static class Skin
    extends DecoratorAnimatedPage.DecoratorAnimatedPageSkin<WorldManagePage> {
        protected Skin(WorldManagePage control) {
            super(control);
            this.setCenter(new Node[]{control.transitionPane});
            this.setLeft(new Node[]{this.getSidebar()});
        }

        private BorderPane getSidebar() {
            BorderPane sidebar = new BorderPane();
            FXUtils.setLimitWidth((Region)sidebar, 200.0);
            VBox.setVgrow((Node)sidebar, (Priority)Priority.ALWAYS);
            sidebar.setTop((Node)this.getTabBar());
            sidebar.setBottom((Node)this.getToolBar());
            return sidebar;
        }

        private AdvancedListBox getTabBar() {
            AdvancedListBox tabBar = new AdvancedListBox();
            ((WorldManagePage)this.getSkinnable()).header.getTabs().addAll((Object[])new TabControl.Tab[]{((WorldManagePage)this.getSkinnable()).worldInfoTab, ((WorldManagePage)this.getSkinnable()).worldBackupsTab});
            ((WorldManagePage)this.getSkinnable()).header.select(((WorldManagePage)this.getSkinnable()).worldInfoTab);
            tabBar.addNavigationDrawerTab(((WorldManagePage)this.getSkinnable()).header, ((WorldManagePage)this.getSkinnable()).worldInfoTab, I18n.i18n("world.info"), SVG.INFO, SVG.INFO_FILL).addNavigationDrawerTab(((WorldManagePage)this.getSkinnable()).header, ((WorldManagePage)this.getSkinnable()).worldBackupsTab, I18n.i18n("world.backup"), SVG.ARCHIVE, SVG.ARCHIVE_FILL);
            if (((WorldManagePage)this.getSkinnable()).world.supportDatapacks()) {
                ((WorldManagePage)this.getSkinnable()).header.getTabs().add(((WorldManagePage)this.getSkinnable()).datapackTab);
                tabBar.addNavigationDrawerTab(((WorldManagePage)this.getSkinnable()).header, ((WorldManagePage)this.getSkinnable()).datapackTab, I18n.i18n("world.datapack"), SVG.EXTENSION, SVG.EXTENSION_FILL);
            }
            return tabBar;
        }

        private AdvancedListBox getToolBar() {
            AdvancedListBox toolbar = new AdvancedListBox();
            BorderPane.setMargin((Node)toolbar, (Insets)new Insets(0.0, 0.0, 12.0, 0.0));
            if (((WorldManagePage)this.getSkinnable()).world.supportQuickPlay()) {
                toolbar.addNavigationDrawerItem(I18n.i18n("version.launch"), SVG.ROCKET_LAUNCH, () -> ((WorldManagePage)this.getSkinnable()).launch(), advancedListItem -> advancedListItem.disableProperty().bind((ObservableValue)((WorldManagePage)this.getSkinnable()).readOnlyProperty()));
            }
            if (ChunkBaseApp.isSupported(((WorldManagePage)this.getSkinnable()).world)) {
                PopupMenu chunkBasePopupMenu = new PopupMenu();
                JFXPopup chunkBasePopup = new JFXPopup((Region)chunkBasePopupMenu);
                chunkBasePopupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.EXPLORE, I18n.i18n("world.chunkbase.seed_map"), () -> ChunkBaseApp.openSeedMap(((WorldManagePage)this.getSkinnable()).world), chunkBasePopup), new IconedMenuItem(SVG.VISIBILITY, I18n.i18n("world.chunkbase.stronghold"), () -> ChunkBaseApp.openStrongholdFinder(((WorldManagePage)this.getSkinnable()).world), chunkBasePopup), new IconedMenuItem(SVG.FORT, I18n.i18n("world.chunkbase.nether_fortress"), () -> ChunkBaseApp.openNetherFortressFinder(((WorldManagePage)this.getSkinnable()).world), chunkBasePopup)});
                if (ChunkBaseApp.supportEndCity(((WorldManagePage)this.getSkinnable()).world)) {
                    chunkBasePopupMenu.getContent().add((Object)new IconedMenuItem(SVG.LOCATION_CITY, I18n.i18n("world.chunkbase.end_city"), () -> ChunkBaseApp.openEndCityFinder(((WorldManagePage)this.getSkinnable()).world), chunkBasePopup));
                }
                toolbar.addNavigationDrawerItem(I18n.i18n("world.chunkbase"), SVG.EXPLORE, null, chunkBaseMenuItem -> chunkBaseMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> chunkBasePopup.show((Node)chunkBaseMenuItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, chunkBaseMenuItem.getWidth(), 0.0))));
            }
            toolbar.addNavigationDrawerItem(I18n.i18n("settings.game.exploration"), SVG.FOLDER_OPEN, () -> FXUtils.openFolder(((WorldManagePage)this.getSkinnable()).world.getFile()));
            PopupMenu managePopupMenu = new PopupMenu();
            JFXPopup managePopup = new JFXPopup((Region)managePopupMenu);
            if (((WorldManagePage)this.getSkinnable()).world.supportQuickPlay()) {
                managePopupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.ROCKET_LAUNCH, I18n.i18n("version.launch"), () -> ((WorldManagePage)this.getSkinnable()).launch(), managePopup), new IconedMenuItem(SVG.SCRIPT, I18n.i18n("version.launch_script"), () -> ((WorldManagePage)this.getSkinnable()).generateLaunchScript(), managePopup), new MenuSeparator()});
            }
            managePopupMenu.getContent().addAll((Object[])new Node[]{new IconedMenuItem(SVG.OUTPUT, I18n.i18n("world.export"), () -> WorldManageUIUtils.export(((WorldManagePage)this.getSkinnable()).world, ((WorldManagePage)this.getSkinnable()).sessionLockChannel), managePopup), new IconedMenuItem(SVG.DELETE, I18n.i18n("world.delete"), () -> WorldManageUIUtils.delete(((WorldManagePage)this.getSkinnable()).world, () -> ((WorldManagePage)this.getSkinnable()).fireEvent(new PageCloseEvent()), ((WorldManagePage)this.getSkinnable()).sessionLockChannel), managePopup), new IconedMenuItem(SVG.CONTENT_COPY, I18n.i18n("world.duplicate"), () -> WorldManageUIUtils.copyWorld(((WorldManagePage)this.getSkinnable()).world, null), managePopup)});
            toolbar.addNavigationDrawerItem(I18n.i18n("settings.game.management"), SVG.MENU, null, managePopupMenuItem -> {
                managePopupMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> managePopup.show((Node)managePopupMenuItem, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.LEFT, managePopupMenuItem.getWidth(), 0.0)));
                managePopupMenuItem.disableProperty().bind((ObservableValue)((WorldManagePage)this.getSkinnable()).readOnlyProperty());
            });
            return toolbar;
        }
    }

    public static interface WorldRefreshable {
        public void refresh();
    }
}

