/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class JFXDialogLayout
extends StackPane {
    private final StackPane heading = new StackPane();
    private final StackPane body = new StackPane();
    private final FlowPane actions = new FlowPane(){

        protected double computeMinWidth(double height) {
            if (this.getContentBias() == Orientation.HORIZONTAL) {
                double maxPref = 0.0;
                for (Node child : this.getChildren()) {
                    if (!child.isManaged()) continue;
                    maxPref = Math.max(maxPref, child.minWidth(-1.0));
                }
                Insets insets = this.getInsets();
                return insets.getLeft() + this.snapSizeX(maxPref) + insets.getRight();
            }
            return this.computePrefWidth(height);
        }

        protected double computeMinHeight(double width) {
            if (this.getContentBias() == Orientation.VERTICAL) {
                double maxPref = 0.0;
                for (Node child : this.getChildren()) {
                    if (!child.isManaged()) continue;
                    maxPref = Math.max(maxPref, child.minHeight(-1.0));
                }
                Insets insets = this.getInsets();
                return insets.getTop() + this.snapSizeY(maxPref) + insets.getBottom();
            }
            return this.computePrefHeight(width);
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "jfx-dialog-layout";

    public JFXDialogLayout() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        VBox layout = new VBox();
        this.heading.getStyleClass().add((Object)"jfx-layout-heading");
        this.heading.getStyleClass().add((Object)"title");
        this.body.getStyleClass().add((Object)"jfx-layout-body");
        this.body.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.body.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.actions.getStyleClass().add((Object)"jfx-layout-actions");
        layout.getChildren().setAll((Object[])new Node[]{this.heading, this.body, this.actions});
        this.getChildren().add((Object)layout);
    }

    public ObservableList<Node> getHeading() {
        return this.heading.getChildren();
    }

    public void setHeading(Node ... titleContent) {
        this.heading.getChildren().setAll((Object[])titleContent);
    }

    public ObservableList<Node> getBody() {
        return this.body.getChildren();
    }

    public void setBody(Node ... body) {
        this.body.getChildren().setAll((Object[])body);
    }

    public ObservableList<Node> getActions() {
        return this.actions.getChildren();
    }

    public void setActions(Node ... actions) {
        this.actions.getChildren().setAll((Object[])actions);
    }

    public void setActions(List<? extends Node> actions) {
        this.actions.getChildren().setAll(actions);
    }
}

