/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.modinfo.PackMcMeta;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class Datapack {
    private static final String DISABLED_EXT = "disabled";
    private static final String ZIP_EXT = "zip";
    private final Path path;
    private final ObservableList<Pack> packs = FXCollections.observableArrayList();

    public Datapack(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public ObservableList<Pack> getPacks() {
        return this.packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installPack(Path sourceDatapackPath, Path targetDatapackDirectory, GameVersionNumber gameVersionNumber) throws IOException {
        boolean containsMultiplePacks;
        Set<Object> packs = new HashSet<String>();
        try (FileSystem fs = CompressingUtils.readonly(sourceDatapackPath).setAutoDetectEncoding(true).build();){
            Path datapacks = fs.getPath("datapacks", new String[0]);
            Path mcmeta = fs.getPath("pack.mcmeta", new String[0]);
            if (Files.exists(datapacks, new LinkOption[0])) {
                containsMultiplePacks = true;
            } else if (Files.exists(mcmeta, new LinkOption[0])) {
                containsMultiplePacks = false;
            } else {
                throw new IOException("Malformed datapack zip");
            }
            if (containsMultiplePacks) {
                try (Stream<Path> s = Files.list(datapacks);){
                    packs = s.map(FileUtils::getNameWithoutExtension).collect(Collectors.toSet());
                }
            } else {
                packs.add(FileUtils.getNameWithoutExtension(sourceDatapackPath));
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(targetDatapackDirectory);){
                for (Path dir : stream) {
                    String packName = FileUtils.getName(dir);
                    if (FileUtils.getExtension(dir).equals(DISABLED_EXT)) {
                        packName = StringUtils.removeSuffix(packName, ".disabled");
                    }
                    if (!packs.contains(packName = FileUtils.getNameWithoutExtension(packName))) continue;
                    if (Files.isDirectory(dir, new LinkOption[0])) {
                        FileUtils.deleteDirectory(dir);
                        continue;
                    }
                    if (!Files.isRegularFile(dir, new LinkOption[0])) continue;
                    Files.delete(dir);
                }
            }
        }
        if (!containsMultiplePacks) {
            FileUtils.copyFile(sourceDatapackPath, targetDatapackDirectory.resolve(FileUtils.getName(sourceDatapackPath)));
        } else {
            Path targetResourceZipPath;
            boolean useNewResourcePath;
            new Unzipper(sourceDatapackPath, targetDatapackDirectory).setReplaceExistentFile(true).setSubDirectory("/datapacks/").unzip();
            boolean bl = useNewResourcePath = gameVersionNumber != null && gameVersionNumber.compareTo("26.1-snapshot-6") >= 0;
            if (useNewResourcePath) {
                Files.createDirectories(targetDatapackDirectory.getParent().resolve("resourcepacks"), new FileAttribute[0]);
                targetResourceZipPath = targetDatapackDirectory.getParent().resolve("resourcepacks/resources.zip");
            } else {
                targetResourceZipPath = targetDatapackDirectory.getParent().resolve("resources.zip");
            }
            try (FileSystem outputResourcesZipFS = CompressingUtils.createWritableZipFileSystem(targetResourceZipPath);
                 FileSystem inputPackZipFS = CompressingUtils.createReadOnlyZipFileSystem(sourceDatapackPath);){
                Path resourcesZip = inputPackZipFS.getPath("resources.zip", new String[0]);
                if (Files.isRegularFile(resourcesZip, new LinkOption[0])) {
                    Path tempResourcesFile = Files.createTempFile("hmcl", ".zip", new FileAttribute[0]);
                    try {
                        Files.copy(resourcesZip, tempResourcesFile, StandardCopyOption.REPLACE_EXISTING);
                        try (FileSystem resources = CompressingUtils.createReadOnlyZipFileSystem(tempResourcesFile);){
                            FileUtils.copyDirectory(resources.getPath("/", new String[0]), outputResourcesZipFS.getPath("/", new String[0]));
                        }
                    }
                    finally {
                        Files.deleteIfExists(tempResourcesFile);
                    }
                }
                Path packMcMeta = outputResourcesZipFS.getPath("pack.mcmeta", new String[0]);
                String metaContent = "{\n    \"pack\": {\n        \"pack_format\": 4,\n        \"description\": \"Modified by HMCL.\"\n    }\n}\n";
                Files.writeString(packMcMeta, (CharSequence)metaContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Path packPng = outputResourcesZipFS.getPath("pack.png", new String[0]);
                if (Files.isRegularFile(packPng, new LinkOption[0])) {
                    Files.delete(packPng);
                }
            }
        }
    }

    public void installPack(Path sourcePackPath, GameVersionNumber gameVersionNumber) throws IOException {
        Datapack.installPack(sourcePackPath, this.path, gameVersionNumber);
        this.loadFromDir();
    }

    public void deletePack(Pack packToDelete) throws IOException {
        Path pathToDelete = packToDelete.path;
        if (Files.isDirectory(pathToDelete, new LinkOption[0])) {
            FileUtils.deleteDirectory(pathToDelete);
        } else if (Files.isRegularFile(pathToDelete, new LinkOption[0])) {
            Files.delete(pathToDelete);
        }
        Platform.runLater(() -> this.packs.removeIf(p -> p.getId().equals(packToDelete.getId())));
    }

    public void loadFromDir() {
        try {
            this.loadFromDir(this.path);
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to read datapacks " + String.valueOf(this.path), e);
        }
    }

    private void loadFromDir(Path dir) throws IOException {
        List discoveredPacks;
        try (Stream<Path> stream = Files.list(dir);){
            discoveredPacks = ((Stream)stream.parallel()).map(this::loadSinglePackFromPath).flatMap(Optional::stream).sorted(Comparator.comparing(Pack::getId, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        }
        Platform.runLater(() -> this.packs.setAll((Collection)discoveredPacks));
    }

    private Optional<Pack> loadSinglePackFromPath(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return this.loadSinglePackFromDirectory(path);
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return this.loadSinglePackFromZipFile(path);
        }
        return Optional.empty();
    }

    private Optional<Pack> loadSinglePackFromDirectory(Path path) {
        Path mcmeta = path.resolve("pack.mcmeta");
        Path mcmetaDisabled = path.resolve("pack.mcmeta.disabled");
        if (!Files.exists(mcmeta, new LinkOption[0]) && !Files.exists(mcmetaDisabled, new LinkOption[0])) {
            return Optional.empty();
        }
        Path targetPath = Files.exists(mcmeta, new LinkOption[0]) ? mcmeta : mcmetaDisabled;
        return this.parsePack(path, true, FileUtils.getNameWithoutExtension(path), targetPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Pack> loadSinglePackFromZipFile(Path path) {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(path);){
            Path mcmeta = fs.getPath("pack.mcmeta", new String[0]);
            if (!Files.exists(mcmeta, new LinkOption[0])) {
                Optional<Pack> optional2 = Optional.empty();
                return optional2;
            }
            String packName = FileUtils.getName(path);
            if (FileUtils.getExtension(path).equals(DISABLED_EXT)) {
                packName = FileUtils.getNameWithoutExtension(packName);
            }
            packName = FileUtils.getNameWithoutExtension(packName);
            Optional<Pack> optional = this.parsePack(path, false, packName, mcmeta);
            return optional;
        }
        catch (IOException e) {
            Logger.LOG.warning("IO error reading " + String.valueOf(path), e);
            return Optional.empty();
        }
    }

    private Optional<Pack> parsePack(Path datapackPath, boolean isDirectory, String name, Path mcmetaPath) {
        try {
            PackMcMeta mcMeta = JsonUtils.fromNonNullJson(Files.readString(mcmetaPath), PackMcMeta.class);
            return Optional.of(new Pack(datapackPath, isDirectory, name, mcMeta.pack().description(), this));
        }
        catch (JsonParseException e) {
            Logger.LOG.warning("Invalid pack.mcmeta format in " + String.valueOf(datapackPath), e);
        }
        catch (IOException e) {
            Logger.LOG.warning("IO error reading " + String.valueOf(datapackPath), e);
        }
        return Optional.empty();
    }

    public static class Pack {
        private Path path;
        private final boolean isDirectory;
        private Path statusFile;
        private final BooleanProperty activeProperty;
        private final String id;
        private final LocalModFile.Description description;
        private final Datapack parentDatapack;

        public Pack(Path path, boolean isDirectory, String id, LocalModFile.Description description, Datapack parentDatapack) {
            this.path = path;
            this.isDirectory = isDirectory;
            this.id = id;
            this.description = description;
            this.parentDatapack = parentDatapack;
            this.statusFile = this.initializeStatusFile(path, isDirectory);
            this.activeProperty = this.initializeActiveProperty();
        }

        private Path initializeStatusFile(Path path, boolean isDirectory) {
            if (isDirectory) {
                Path mcmeta = path.resolve("pack.mcmeta");
                return Files.exists(mcmeta, new LinkOption[0]) ? mcmeta : path.resolve("pack.mcmeta.disabled");
            }
            return path;
        }

        private BooleanProperty initializeActiveProperty() {
            SimpleBooleanProperty property = new SimpleBooleanProperty((Object)this, "active", !FileUtils.getExtension(this.statusFile).equals(Datapack.DISABLED_EXT));
            property.addListener((obs, wasActive, isNowActive) -> {
                if (wasActive != isNowActive) {
                    this.handleFileRename((boolean)isNowActive);
                }
            });
            return property;
        }

        private void handleFileRename(boolean isNowActive) {
            Path newStatusFile = this.calculateNewStatusFilePath(isNowActive);
            if (this.statusFile.equals(newStatusFile)) {
                return;
            }
            try {
                Files.move(this.statusFile, newStatusFile, new CopyOption[0]);
                this.statusFile = newStatusFile;
                if (!this.isDirectory) {
                    this.path = newStatusFile;
                }
            }
            catch (IOException e) {
                Logger.LOG.warning("Unable to rename file from " + String.valueOf(this.statusFile) + " to " + String.valueOf(newStatusFile), e);
            }
        }

        private Path calculateNewStatusFilePath(boolean isActive) {
            boolean isFileDisabled = Datapack.DISABLED_EXT.equals(FileUtils.getExtension(this.statusFile));
            if (isActive && isFileDisabled) {
                return this.statusFile.getParent().resolve(FileUtils.getNameWithoutExtension(this.statusFile));
            }
            if (!isActive && !isFileDisabled) {
                return this.statusFile.getParent().resolve(FileUtils.getName(this.statusFile) + ".disabled");
            }
            return this.statusFile;
        }

        public String getId() {
            return this.id;
        }

        public LocalModFile.Description getDescription() {
            return this.description;
        }

        public Datapack getParentDatapack() {
            return this.parentDatapack;
        }

        public BooleanProperty activeProperty() {
            return this.activeProperty;
        }

        public boolean isActive() {
            return this.activeProperty.get();
        }

        public void setActive(boolean active) {
            this.activeProperty.set(active);
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

