/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.io.ContentEncoding;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FetchTask<T>
extends Task<T> {
    protected static final int DEFAULT_RETRY = 3;
    protected final List<URI> uris;
    protected int retry = 3;
    protected CacheRepository repository = CacheRepository.getInstance();
    private static final Timer timer = new Timer("DownloadSpeedRecorder", true);
    private static final AtomicLong downloadSpeed = new AtomicLong(0L);
    public static final EventManager<SpeedEvent> SPEED_EVENT = EventBus.EVENT_BUS.channel(SpeedEvent.class);
    private static final HttpResponse.BodyHandler<InputStream> BODY_HANDLER;
    public static int DEFAULT_CONCURRENCY;
    private static int downloadExecutorConcurrency;
    private static final ExecutorService DOWNLOAD_EXECUTOR;
    @Nullable
    private static final Semaphore SEMAPHORE;
    private static volatile boolean initialized;

    public FetchTask(@NotNull @NotNull List<@NotNull URI> uris) {
        Objects.requireNonNull(uris);
        this.uris = List.copyOf(uris);
        if (this.uris.isEmpty()) {
            throw new IllegalArgumentException("At least one URL is required");
        }
        this.setExecutor(DOWNLOAD_EXECUTOR);
    }

    public void setRetry(int retry) {
        if (retry <= 0) {
            throw new IllegalArgumentException("Retry count must be greater than 0");
        }
        this.retry = retry;
    }

    public void setCacheRepository(CacheRepository repository) {
        this.repository = repository;
    }

    protected void beforeDownload(URI uri) throws IOException {
    }

    protected abstract void useCachedResult(Path var1) throws IOException;

    protected abstract EnumCheckETag shouldCheckETag();

    private Context getContext() throws IOException {
        return this.getContext(null, false, null);
    }

    protected abstract Context getContext(@Nullable HttpResponse<?> var1, boolean var2, String var3) throws IOException;

    /*
     * Exception decompiling
     */
    @Override
    public void execute() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void download(Context context, InputStream inputStream, long contentLength, ContentEncoding contentEncoding) throws IOException, InterruptedException {
        try (Context ignored = context;
             CounterInputStream counter = new CounterInputStream(inputStream);
             InputStream input = contentEncoding.wrap(counter);){
            int len;
            long lastDownloaded = 0L;
            byte[] buffer = new byte[8192];
            while (!this.isCancelled() && (len = input.read(buffer)) != -1) {
                context.write(buffer, 0, len);
                if (contentLength >= 0L) {
                    this.updateProgress(counter.downloaded, contentLength);
                }
                FetchTask.updateDownloadSpeed(counter.downloaded - lastDownloaded);
                lastDownloaded = counter.downloaded;
            }
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            FetchTask.updateDownloadSpeed(counter.downloaded - lastDownloaded);
            if (contentLength >= 0L && counter.downloaded != contentLength) {
                throw new IOException("Unexpected file size: " + counter.downloaded + ", expected: " + contentLength);
            }
            context.withResult(true);
        }
    }

    private void downloadHttp(URI uri, boolean checkETag) throws DownloadException, InterruptedException {
        if (checkETag) {
            try {
                Path cache = this.repository.getCachedRemoteFile(uri, true);
                this.useCachedResult(cache);
                Logger.LOG.info("Using cached file for " + String.valueOf(NetworkUtils.dropQuery(uri)));
                return;
            }
            catch (IOException cache) {
                // empty catch block
            }
        }
        ArrayList<Exception> exceptions = null;
        boolean useCachedResult = true;
        int retryLimit = this.retry;
        for (int retryTime = 0; retryTime < retryLimit; ++retryTime) {
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            ArrayList<URI> redirects = null;
            try {
                String bmclapiHash;
                HttpResponse<InputStream> response;
                block24: {
                    this.beforeDownload(uri);
                    this.updateProgress(0.0);
                    URI currentURI = uri;
                    LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                    headers.put("accept-encoding", "gzip");
                    if (useCachedResult && checkETag) {
                        headers.putAll(this.repository.injectConnection(uri));
                    }
                    while (true) {
                        Optional<Path> cache;
                        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(currentURI).timeout(Duration.ofMillis(8000L)).header("User-Agent", NetworkUtils.USER_AGENT);
                        headers.forEach(requestBuilder::header);
                        response = Holder.HTTP_CLIENT.send(requestBuilder.build(), BODY_HANDLER);
                        bmclapiHash = response.headers().firstValue("x-bmclapi-hash").orElse(null);
                        if (DigestUtils.isSha1Digest(bmclapiHash) && (cache = this.repository.checkExistentFile(null, "SHA-1", bmclapiHash)).isPresent()) {
                            this.useCachedResult(cache.get());
                            Logger.LOG.info("Using cached file for " + String.valueOf(NetworkUtils.dropQuery(uri)));
                            return;
                        }
                        int code = response.statusCode();
                        if (code < 300 || code > 308 || code == 306 || code == 304) break;
                        if (redirects == null) {
                            redirects = new ArrayList<URI>();
                        } else if (redirects.size() >= 20) {
                            throw new IOException("Too much redirects");
                        }
                        String location = response.headers().firstValue("Location").orElse(null);
                        if (StringUtils.isBlank(location)) {
                            throw new IOException("Redirected to an empty location");
                        }
                        URI target = currentURI.resolve(NetworkUtils.encodeLocation(location));
                        redirects.add(target);
                        if (!NetworkUtils.isHttpUri(target)) {
                            throw new IOException("Redirected to not http URI: " + String.valueOf(target));
                        }
                        currentURI = target;
                    }
                    int responseCode = response.statusCode();
                    if (useCachedResult && responseCode == 304) {
                        try {
                            Path cache = this.repository.getCachedRemoteFile(currentURI, false);
                            this.useCachedResult(cache);
                            Logger.LOG.info("Using cached file for " + String.valueOf(NetworkUtils.dropQuery(uri)));
                            return;
                        }
                        catch (CacheRepository.CacheExpiredException e) {
                            Logger.LOG.info("Cache expired for " + String.valueOf(NetworkUtils.dropQuery(uri)));
                            break block24;
                        }
                        catch (IOException e) {
                            Logger.LOG.warning("Unable to use cached file, redownload " + String.valueOf(NetworkUtils.dropQuery(uri)), e);
                            this.repository.removeRemoteEntry(currentURI);
                            useCachedResult = false;
                            ++retryLimit;
                            continue;
                        }
                    }
                    if (responseCode / 100 == 4) {
                        throw new FileNotFoundException(uri.toString());
                    }
                    if (responseCode / 100 != 2) {
                        throw new ResponseCodeException(uri, responseCode);
                    }
                }
                long contentLength = response.headers().firstValueAsLong("content-length").orElse(-1L);
                ContentEncoding contentEncoding = ContentEncoding.fromResponse(response);
                this.download(this.getContext(response, checkETag, bmclapiHash), response.body(), contentLength, contentEncoding);
                return;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (FileNotFoundException ex) {
                Logger.LOG.warning("Failed to download " + String.valueOf(uri) + ", not found" + (String)(redirects == null ? "" : ", redirects: " + String.valueOf(redirects)), ex);
                throw FetchTask.toDownloadException(uri, ex, exceptions);
            }
            catch (Exception ex) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(ex);
                Logger.LOG.warning("Failed to download " + String.valueOf(uri) + ", repeat times: " + retryTime + (String)(redirects == null ? "" : ", redirects: " + String.valueOf(redirects)), ex);
                if (retryTime >= retryLimit - 1) continue;
                Thread.sleep(200L);
            }
        }
        throw FetchTask.toDownloadException(uri, null, exceptions);
    }

    private void downloadNotHttp(URI uri) throws DownloadException, InterruptedException {
        ArrayList<Exception> exceptions = null;
        for (int retryTime = 0; retryTime < this.retry; ++retryTime) {
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            try {
                this.beforeDownload(uri);
                this.updateProgress(0.0);
                URLConnection conn = NetworkUtils.createConnection(uri);
                this.download(this.getContext(), conn.getInputStream(), conn.getContentLengthLong(), ContentEncoding.fromConnection(conn));
                return;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (FileNotFoundException ex) {
                Logger.LOG.warning("Failed to download " + String.valueOf(uri) + ", not found", ex);
                throw FetchTask.toDownloadException(uri, ex, exceptions);
            }
            catch (Exception ex) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(ex);
                Logger.LOG.warning("Failed to download " + String.valueOf(uri) + ", repeat times: " + retryTime, ex);
                continue;
            }
        }
        throw FetchTask.toDownloadException(uri, null, exceptions);
    }

    private static DownloadException toDownloadException(URI uri, @Nullable Exception last, @Nullable ArrayList<Exception> exceptions) {
        if (exceptions == null || exceptions.isEmpty()) {
            return new DownloadException(uri, (Throwable)(last != null ? last : new IOException("No exceptions")));
        }
        if (last == null) {
            last = exceptions.remove(exceptions.size() - 1);
        }
        for (Exception e : exceptions) {
            last.addSuppressed(e);
        }
        return new DownloadException(uri, (Throwable)last);
    }

    private static void updateDownloadSpeed(long speed) {
        downloadSpeed.addAndGet(speed);
    }

    public static void setDownloadExecutorConcurrency(int concurrency) {
        int prevDownloadExecutorConcurrency;
        int change = (concurrency = Math.max(concurrency, 1)) - (prevDownloadExecutorConcurrency = downloadExecutorConcurrency);
        if (change == 0) {
            return;
        }
        downloadExecutorConcurrency = concurrency;
        if (SEMAPHORE != null) {
            if (change > 0) {
                SEMAPHORE.release(change);
            } else {
                int permits = -change;
                if (!SEMAPHORE.tryAcquire(permits)) {
                    Schedulers.io().execute(() -> {
                        try {
                            for (int i = 0; i < permits; ++i) {
                                SEMAPHORE.acquire();
                            }
                        }
                        catch (InterruptedException e) {
                            throw new AssertionError("Unreachable", e);
                        }
                    });
                }
            }
        } else {
            ThreadPoolExecutor downloadExecutor = (ThreadPoolExecutor)DOWNLOAD_EXECUTOR;
            if (downloadExecutor.getMaximumPoolSize() <= concurrency) {
                downloadExecutor.setMaximumPoolSize(concurrency);
                downloadExecutor.setCorePoolSize(concurrency);
            } else {
                downloadExecutor.setCorePoolSize(concurrency);
                downloadExecutor.setMaximumPoolSize(concurrency);
            }
        }
    }

    public static int getDownloadExecutorConcurrency() {
        return downloadExecutorConcurrency;
    }

    public static void notifyInitialized() {
        initialized = true;
    }

    static {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SPEED_EVENT.fireEvent(new SpeedEvent(SPEED_EVENT, downloadSpeed.getAndSet(0L)));
            }
        }, 0L, 1000L);
        BODY_HANDLER = responseInfo -> {
            if (responseInfo.statusCode() / 100 == 2) {
                return HttpResponse.BodySubscribers.ofInputStream();
            }
            return HttpResponse.BodySubscribers.replacing(null);
        };
        downloadExecutorConcurrency = DEFAULT_CONCURRENCY = Math.min(Runtime.getRuntime().availableProcessors() * 4, 64);
        ExecutorService executorService = Schedulers.newVirtualThreadPerTaskExecutor("Download");
        if (executorService != null) {
            DOWNLOAD_EXECUTOR = executorService;
            SEMAPHORE = new Semaphore(DEFAULT_CONCURRENCY);
        } else {
            DOWNLOAD_EXECUTOR = Lang.threadPool("Download", true, downloadExecutorConcurrency, 10L, TimeUnit.SECONDS);
            SEMAPHORE = null;
        }
        initialized = false;
    }

    protected static abstract class Context
    implements Closeable {
        private boolean success;

        protected Context() {
        }

        public abstract void write(byte[] var1, int var2, int var3) throws IOException;

        public void withResult(boolean success) {
            this.success = success;
        }

        protected boolean isSuccess() {
            return this.success;
        }
    }

    protected static enum EnumCheckETag {
        CHECK_E_TAG,
        NOT_CHECK_E_TAG,
        CACHED;

    }

    private static final class CounterInputStream
    extends FilterInputStream {
        long downloaded;

        CounterInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                ++this.downloaded;
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n >= 0) {
                this.downloaded += (long)n;
            }
            return n;
        }
    }

    private static final class Holder {
        private static final HttpClient HTTP_CLIENT;

        private Holder() {
        }

        static {
            if (!initialized) {
                throw new AssertionError((Object)"FetchTask.Holder accessed before ProxyManager initialization.");
            }
            boolean useHttp2 = !"false".equalsIgnoreCase(System.getProperty("hmcl.http2"));
            HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(8000L)).version(useHttp2 ? HttpClient.Version.HTTP_2 : HttpClient.Version.HTTP_1_1).build();
        }
    }

    public static class SpeedEvent
    extends Event {
        private final long speed;

        public SpeedEvent(Object source, long speed) {
            super(source);
            this.speed = speed;
        }

        public long getSpeed() {
            return this.speed;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this).append("speed", this.speed).toString();
        }
    }
}

