/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.nio.file.Path;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public class FileSelector
extends HBox {
    private final StringProperty value = new SimpleStringProperty();
    private String chooserTitle = I18n.i18n("selector.choose_file");
    private boolean directory = false;
    private final ObservableList<FileChooser.ExtensionFilter> extensionFilters = FXCollections.observableArrayList();

    public String getValue() {
        return (String)this.value.get();
    }

    public StringProperty valueProperty() {
        return this.value;
    }

    public void setValue(String value) {
        this.value.set((Object)value);
    }

    public String getChooserTitle() {
        return this.chooserTitle;
    }

    public FileSelector setChooserTitle(String chooserTitle) {
        this.chooserTitle = chooserTitle;
        return this;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public FileSelector setDirectory(boolean directory) {
        this.directory = directory;
        return this;
    }

    public ObservableList<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public FileSelector() {
        JFXTextField customField = new JFXTextField();
        FXUtils.bindString(customField, (Property<String>)this.valueProperty());
        JFXButton selectButton = new JFXButton();
        selectButton.setGraphic((Node)SVG.FOLDER_OPEN.createIcon(15.0));
        selectButton.setOnAction(e -> {
            if (this.directory) {
                DirectoryChooser chooser = new DirectoryChooser();
                chooser.setTitle(this.chooserTitle);
                Path dir = FileUtils.toPath(chooser.showDialog((Window)Controllers.getStage()));
                if (dir != null) {
                    String path = FileUtils.getAbsolutePath(dir);
                    customField.setText(path);
                    this.value.setValue(path);
                }
            } else {
                FileChooser chooser = new FileChooser();
                chooser.getExtensionFilters().addAll(this.getExtensionFilters());
                chooser.setTitle(this.chooserTitle);
                Path file = FileUtils.toPath(chooser.showOpenDialog((Window)Controllers.getStage()));
                if (file != null) {
                    String path = FileUtils.getAbsolutePath(file);
                    customField.setText(path);
                    this.value.setValue(path);
                }
            }
        });
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(3.0);
        this.getChildren().addAll((Object[])new Node[]{customField, selectButton});
    }
}

