/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXSpinner;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;

public class SpinnerPane
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "spinner-pane";
    private ObjectProperty<Node> content;
    private BooleanProperty loading;
    private StringProperty failedReason;
    private ObjectProperty<EventHandler<Event>> onFailedAction;
    public static final EventType<Event> FAILED_ACTION = new EventType(Event.ANY, "FAILED_ACTION");

    public SpinnerPane() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public void showSpinner() {
        this.setLoading(true);
    }

    public void hideSpinner() {
        this.setFailedReason(null);
        this.setLoading(false);
    }

    private void updateContent() {
        javafx.scene.control.Skin skin = this.getSkin();
        if (skin instanceof Skin) {
            Skin skin2 = (Skin)skin;
            skin2.updateContent();
        }
    }

    public ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new ObjectPropertyBase<Node>(){

                public Object getBean() {
                    return SpinnerPane.this;
                }

                public String getName() {
                    return "content";
                }

                protected void invalidated() {
                    SpinnerPane.this.updateContent();
                }
            };
        }
        return this.content;
    }

    public Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public BooleanProperty loadingProperty() {
        if (this.loading == null) {
            this.loading = new BooleanPropertyBase(){

                public Object getBean() {
                    return SpinnerPane.this;
                }

                public String getName() {
                    return "loading";
                }

                protected void invalidated() {
                    SpinnerPane.this.updateContent();
                }
            };
        }
        return this.loading;
    }

    public boolean isLoading() {
        return this.loading != null && this.loading.get();
    }

    public void setLoading(boolean loading) {
        this.loadingProperty().set(loading);
    }

    public StringProperty failedReasonProperty() {
        if (this.failedReason == null) {
            this.failedReason = new StringPropertyBase(){

                public Object getBean() {
                    return SpinnerPane.this;
                }

                public String getName() {
                    return "failedReason";
                }

                protected void invalidated() {
                    SpinnerPane.this.updateContent();
                }
            };
        }
        return this.failedReason;
    }

    public String getFailedReason() {
        return this.failedReason != null ? (String)this.failedReason.get() : null;
    }

    public void setFailedReason(String failedReason) {
        this.failedReasonProperty().set((Object)failedReason);
    }

    public final ObjectProperty<EventHandler<Event>> onFailedActionProperty() {
        if (this.onFailedAction == null) {
            this.onFailedAction = new ObjectPropertyBase<EventHandler<Event>>(){

                public Object getBean() {
                    return SpinnerPane.this;
                }

                public String getName() {
                    return "onFailedAction";
                }

                protected void invalidated() {
                    SpinnerPane.this.setEventHandler(FAILED_ACTION, (EventHandler)this.get());
                }
            };
        }
        return this.onFailedAction;
    }

    public final EventHandler<Event> getOnFailedAction() {
        return this.onFailedAction != null ? (EventHandler)this.onFailedAction.get() : null;
    }

    public final void setOnFailedAction(EventHandler<Event> value) {
        this.onFailedActionProperty().set(value);
    }

    protected SkinBase<SpinnerPane> createDefaultSkin() {
        return new Skin(this);
    }

    private static final class Skin
    extends SkinBase<SpinnerPane> {
        private final TransitionPane root = new TransitionPane();
        private StackPane contentPane;
        private StackPane spinnerPane;
        private StackPane failedPane;
        private Label failedReasonLabel;

        Skin(SpinnerPane control) {
            super((Control)control);
            this.updateContent();
            this.getChildren().setAll((Object[])new Node[]{this.root});
        }

        void updateContent() {
            StackPane nextContent;
            SpinnerPane control = (SpinnerPane)this.getSkinnable();
            if (control.isLoading()) {
                if (this.spinnerPane == null) {
                    this.spinnerPane = new StackPane(new Node[]{new JFXSpinner()});
                    this.spinnerPane.getStyleClass().add((Object)"notice-pane");
                }
                nextContent = this.spinnerPane;
            } else if (control.getFailedReason() != null) {
                if (this.failedPane == null) {
                    this.failedReasonLabel = new Label();
                    this.failedPane = new StackPane(new Node[]{this.failedReasonLabel});
                    this.failedPane.getStyleClass().add((Object)"notice-pane");
                    FXUtils.onClicked((Node)this.failedPane, () -> control.fireEvent(new Event(FAILED_ACTION)));
                }
                this.failedReasonLabel.setText(control.getFailedReason());
                nextContent = this.failedPane;
            } else {
                Node content;
                if (this.contentPane == null) {
                    this.contentPane = new StackPane();
                }
                if ((content = control.getContent()) != null) {
                    this.contentPane.getChildren().setAll((Object[])new Node[]{content});
                } else {
                    this.contentPane.getChildren().clear();
                }
                nextContent = this.contentPane;
            }
            if (nextContent != this.failedPane && this.failedReasonLabel != null) {
                this.failedReasonLabel.setText(null);
            }
            this.root.setContent((Node)nextContent, ContainerAnimations.FADE);
        }
    }
}

