/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.validation.base.ValidatorBase;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.AbstractInstallersPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.i18n.I18n;

public class InstallersPage
extends AbstractInstallersPage {
    private boolean isNameModifiedByUser = false;

    public InstallersPage(WizardController controller, HMCLGameRepository repository, String gameVersion, DownloadProvider downloadProvider) {
        super(controller, gameVersion, downloadProvider);
        this.txtName.getValidators().addAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !repository.versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
        this.installable.bind((ObservableValue)Bindings.createBooleanBinding(this.txtName::validate, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.txtName.textProperty().addListener((obs, oldText, newText) -> {
            this.isNameModifiedByUser = true;
        });
    }

    @Override
    public String getTitle() {
        return ((RemoteVersion)this.controller.getSettings().get("game")).getGameVersion();
    }

    private String getVersion(String id) {
        return I18n.getDisplayVersion((RemoteVersion)this.controller.getSettings().get(id));
    }

    @Override
    protected void reload() {
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (this.controller.getSettings().containsKey(libraryId)) {
                library.versionProperty().set((Object)new InstallerItem.InstalledState(this.getVersion(libraryId), false, false));
                continue;
            }
            library.versionProperty().set(null);
        }
        if (!this.isNameModifiedByUser) {
            this.setTxtNameWithLoaders();
        }
    }

    @Override
    public void cleanup(SettingsMap settings) {
    }

    private static boolean checkName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onInstall() {
        String name = this.txtName.getText();
        if (!InstallersPage.checkName(name)) {
            Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("install.name.invalid"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.QUESTION).yesOrNo(() -> {
                this.controller.getSettings().put("name", name);
                this.controller.onFinish();
            }, () -> {}).build());
        } else {
            this.controller.getSettings().put("name", name);
            this.controller.onFinish();
        }
    }

    private void setTxtNameWithLoaders() {
        StringBuilder nameBuilder = new StringBuilder(this.getTitle());
        for (InstallerItem library : this.group.getLibraries()) {
            String loaderName;
            LibraryAnalyzer.LibraryType libraryType;
            String libraryId = library.getLibraryId().replace(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId(), "");
            if (!this.controller.getSettings().containsKey(libraryId) || (libraryType = LibraryAnalyzer.LibraryType.fromPatchId(libraryId)) == null) continue;
            switch (libraryType) {
                case FORGE: {
                    String string = "forge";
                    break;
                }
                case NEO_FORGE: {
                    String string = "neoforge";
                    break;
                }
                case CLEANROOM: {
                    String string = "cleanroom";
                    break;
                }
                case LEGACY_FABRIC: {
                    String string = "legacy_fabric";
                    break;
                }
                case FABRIC: {
                    String string = "fabric";
                    break;
                }
                case LITELOADER: {
                    String string = "liteloader";
                    break;
                }
                case QUILT: {
                    String string = "quilt";
                    break;
                }
                case OPTIFINE: {
                    String string = "optifine";
                    break;
                }
                default: {
                    String string = loaderName = null;
                }
            }
            if (loaderName == null) continue;
            nameBuilder.append('-').append(loaderName);
        }
        this.txtName.setText(nameBuilder.toString());
        this.isNameModifiedByUser = false;
    }
}

