/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.zip.ZipException;
import javafx.scene.Node;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.UnsupportedInstallationException;
import org.jackhuang.hmcl.download.VersionMismatchException;
import org.jackhuang.hmcl.download.game.GameAssetIndexDownloadTask;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.download.AdditionalInstallersPage;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateInstallerWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final DefaultDependencyManager dependencyManager;
    private final String gameVersion;
    private final Version version;
    private final String libraryId;
    private final String oldLibraryVersion;
    private final DownloadProvider downloadProvider;

    public UpdateInstallerWizardProvider(@NotNull Profile profile, @NotNull String gameVersion, @NotNull Version version, @NotNull String libraryId, @Nullable String oldLibraryVersion) {
        this.profile = profile;
        this.gameVersion = gameVersion;
        this.version = version;
        this.libraryId = libraryId;
        this.oldLibraryVersion = oldLibraryVersion;
        this.downloadProvider = DownloadProviders.getDownloadProvider();
        this.dependencyManager = profile.getDependency(this.downloadProvider);
    }

    @Override
    public void start(SettingsMap settings) {
    }

    @Override
    public Object finish(SettingsMap settings) {
        settings.put("title", I18n.i18n("install.change_version.process"));
        settings.put("success_message", I18n.i18n("install.success"));
        settings.put(WizardProvider.FailureCallback.KEY, (settings1, exception, next) -> UpdateInstallerWizardProvider.alertFailureMessage(exception, next));
        Task<Version> ret = Task.supplyAsync(() -> this.version);
        ArrayList<Task.StagesHint> hints = new ArrayList<Task.StagesHint>();
        for (Object value : settings.asStringMap().values()) {
            if (value instanceof RemoteVersion) {
                RemoteVersion remoteVersion = (RemoteVersion)value;
                ret = ret.thenComposeAsync(version -> this.dependencyManager.installLibraryAsync((Version)version, remoteVersion));
                hints.add(new Task.StagesHint(String.format("hmcl.install.%s:%s", remoteVersion.getLibraryId(), remoteVersion.getSelfVersion())));
                if (!"game".equals(remoteVersion.getLibraryId())) continue;
                hints.add(new Task.StagesHint("hmcl.install.libraries"));
                hints.add(new Task.StagesHint("hmcl.install.assets"));
                continue;
            }
            if (!(value instanceof RemoveVersionAction)) continue;
            RemoveVersionAction removeVersionAction = (RemoveVersionAction)value;
            ret = ret.thenComposeAsync(version -> this.dependencyManager.removeLibraryAsync((Version)version, removeVersionAction.libraryId));
        }
        return ret.thenComposeAsync(this.profile.getRepository()::saveAsync).thenComposeAsync(this.profile.getRepository().refreshVersionsAsync()).withStagesHints(hints);
    }

    @Override
    public Node createPage(WizardController controller, int step, SettingsMap settings) {
        switch (step) {
            case 0: {
                return new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer." + this.libraryId)), this.gameVersion, this.downloadProvider, this.libraryId, () -> {
                    if (this.oldLibraryVersion == null) {
                        controller.onFinish();
                    } else if ("game".equals(this.libraryId)) {
                        String newGameVersion = ((RemoteVersion)settings.get(this.libraryId)).getSelfVersion();
                        controller.onNext((Node)new AdditionalInstallersPage(newGameVersion, this.version, controller, this.profile.getRepository(), this.downloadProvider));
                    } else {
                        Controllers.confirm(I18n.i18n("install.change_version.confirm", I18n.i18n("install.installer." + this.libraryId), this.oldLibraryVersion, ((RemoteVersion)settings.get(this.libraryId)).getSelfVersion()), I18n.i18n("install.change_version"), controller::onFinish, controller::onCancel);
                    }
                });
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public boolean cancelIfCannotGoBack() {
        return true;
    }

    public static void alertFailureMessage(Exception exception, Runnable next) {
        if (exception instanceof LibraryDownloadException) {
            String message = I18n.i18n("launch.failed.download_library", ((LibraryDownloadException)exception).getLibrary().getName()) + "\n";
            if (exception.getCause() instanceof ResponseCodeException) {
                ResponseCodeException rce = (ResponseCodeException)exception.getCause();
                int responseCode = rce.getResponseCode();
                String uri = rce.getUri();
                message = responseCode == 404 ? message + I18n.i18n("download.code.404", uri) : message + I18n.i18n("download.failed", uri, responseCode);
            } else {
                message = message + StringUtils.getStackTrace(exception.getCause());
            }
            Controllers.dialog(message, I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR, next);
        } else if (exception instanceof DownloadException) {
            URI uri = ((DownloadException)exception).getUri();
            if (exception.getCause() instanceof SocketTimeoutException) {
                Controllers.dialog(I18n.i18n("install.failed.downloading.timeout", uri), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR, next);
            } else if (exception.getCause() instanceof ResponseCodeException) {
                ResponseCodeException responseCodeException = (ResponseCodeException)exception.getCause();
                if (I18n.hasKey("download.code." + responseCodeException.getResponseCode())) {
                    Controllers.dialog(I18n.i18n("download.code." + responseCodeException.getResponseCode(), uri), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR, next);
                } else {
                    Controllers.dialog(I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(exception.getCause()), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR, next);
                }
            } else {
                Controllers.dialog(I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(exception.getCause()), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR, next);
            }
        } else if (exception instanceof UnsupportedInstallationException) {
            switch (((UnsupportedInstallationException)exception).getReason()) {
                case 2: {
                    Controllers.dialog(I18n.i18n("install.failed.optifine_forge_1.17"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
                    break;
                }
                default: {
                    Controllers.dialog(I18n.i18n("install.failed.optifine_conflict"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
                    break;
                }
            }
        } else if (exception instanceof DefaultDependencyManager.UnsupportedLibraryInstallerException) {
            Controllers.dialog(I18n.i18n("install.failed.install_online"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
        } else if (exception instanceof ArtifactMalformedException || exception instanceof ZipException) {
            Controllers.dialog(I18n.i18n("install.failed.malformed"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
        } else if (exception instanceof GameAssetIndexDownloadTask.GameAssetIndexMalformedException) {
            Controllers.dialog(I18n.i18n("assets.index.malformed"), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
        } else if (exception instanceof VersionMismatchException) {
            VersionMismatchException e = (VersionMismatchException)exception;
            Controllers.dialog(I18n.i18n("install.failed.version_mismatch", e.getExpect(), e.getActual()), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
        } else if (!(exception instanceof CancellationException)) {
            Controllers.dialog(StringUtils.getStackTrace(exception), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR, next);
        }
    }

    public static class RemoveVersionAction {
        private final String libraryId;

        public RemoveVersionAction(String libraryId) {
            this.libraryId = libraryId;
        }
    }
}

