/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXSpinner;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.java.JavaDistribution;
import org.jackhuang.hmcl.download.java.JavaPackageType;
import org.jackhuang.hmcl.download.java.JavaRemoteVersion;
import org.jackhuang.hmcl.download.java.disco.DiscoFetchJavaListTask;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaDistribution;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaRemoteVersion;
import org.jackhuang.hmcl.download.java.disco.DiscoRemoteFileInfo;
import org.jackhuang.hmcl.download.java.disco.DiscoResult;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.DialogPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.main.JavaInstallPage;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Result;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;

public final class JavaDownloadDialog
extends StackPane {
    private final DownloadProvider downloadProvider;
    private final Platform platform;
    private final List<GameJavaVersion> supportedGameJavaVersions;
    private final EnumSet<DiscoJavaDistribution> distributions;

    public static Runnable showDialogAction(DownloadProvider downloadProvider) {
        Platform platform = Platform.SYSTEM_PLATFORM;
        List<GameJavaVersion> supportedVersions = GameJavaVersion.getSupportedVersions(platform);
        EnumSet<DiscoJavaDistribution> distributions = EnumSet.noneOf(DiscoJavaDistribution.class);
        for (DiscoJavaDistribution distribution : DiscoJavaDistribution.values()) {
            if (!distribution.isSupport(platform)) continue;
            distributions.add(distribution);
        }
        return supportedVersions.isEmpty() && distributions.isEmpty() ? null : () -> Controllers.dialog((Region)new JavaDownloadDialog(downloadProvider, platform, supportedVersions, distributions));
    }

    private JavaDownloadDialog(DownloadProvider downloadProvider, Platform platform, List<GameJavaVersion> supportedGameJavaVersions, EnumSet<DiscoJavaDistribution> distributions) {
        this.downloadProvider = downloadProvider;
        this.platform = platform;
        this.supportedGameJavaVersions = supportedGameJavaVersions;
        this.distributions = distributions;
        if (!supportedGameJavaVersions.isEmpty()) {
            this.getChildren().add((Object)new DownloadMojangJava());
        } else {
            this.getChildren().add((Object)new DownloadDiscoJava());
        }
    }

    private final class DownloadMojangJava
    extends DialogPane {
        private final List<JFXCheckBox> checkboxes = new ArrayList<JFXCheckBox>();

        DownloadMojangJava() {
            this.setTitle(I18n.i18n("java.download.title"));
            VBox vbox = new VBox(16.0);
            Label prompt = new Label(I18n.i18n("java.download.prompt"));
            vbox.getChildren().add((Object)prompt);
            this.setValid(false);
            InvalidationListener updateValidStatus = e -> {
                for (JFXCheckBox box : this.checkboxes) {
                    if (box.isDisabled() || !box.isSelected()) continue;
                    this.setValid(true);
                    return;
                }
                this.setValid(false);
            };
            for (GameJavaVersion version : JavaDownloadDialog.this.supportedGameJavaVersions) {
                JFXCheckBox button = new JFXCheckBox("Java " + version.majorVersion());
                button.setUserData(version);
                if (JavaManager.REPOSITORY.isInstalled(JavaDownloadDialog.this.platform, version)) {
                    button.setDisable(true);
                    button.setSelected(true);
                } else {
                    button.selectedProperty().addListener(updateValidStatus);
                }
                vbox.getChildren().add((Object)button);
                this.checkboxes.add(button);
            }
            this.setBody(new Node[]{vbox});
            if (!JavaDownloadDialog.this.distributions.isEmpty()) {
                JFXHyperlink more = new JFXHyperlink(I18n.i18n("java.download.more"));
                more.setOnAction(event -> JavaDownloadDialog.this.getChildren().setAll((Object[])new Node[]{new DownloadDiscoJava()}));
                this.setActions(new Node[]{this.warningLabel, more, this.acceptPane, this.cancelButton});
            } else {
                this.setActions(new Node[]{this.warningLabel, this.acceptPane, this.cancelButton});
            }
        }

        @Override
        protected void onAccept() {
            this.fireEvent(new DialogCloseEvent());
            ArrayList<GameJavaVersion> selectedVersions = new ArrayList<GameJavaVersion>();
            for (JFXCheckBox box : this.checkboxes) {
                if (box.isDisabled() || !box.isSelected()) continue;
                selectedVersions.add((GameJavaVersion)box.getUserData());
            }
            if (selectedVersions.isEmpty()) {
                return;
            }
            Task<Void> task = Task.allOf(selectedVersions.stream().map(javaVersion -> JavaManager.getDownloadJavaTask(JavaDownloadDialog.this.downloadProvider, JavaDownloadDialog.this.platform, javaVersion).wrapResult()).toList()).whenComplete(Schedulers.javafx(), (results, exception) -> {
                Throwable exceptionToDisplay;
                if (exception == null) {
                    List<Throwable> exceptions = results.stream().filter(Result::isFailure).map(Result::getException).map(Lang::resolveException).filter(it -> !(it instanceof CancellationException)).toList();
                    if (!exceptions.isEmpty()) {
                        if (exceptions.size() == 1) {
                            exceptionToDisplay = exceptions.get(0);
                        } else {
                            exceptionToDisplay = new IOException("Failed to download Java");
                            for (Throwable e : exceptions) {
                                exceptionToDisplay.addSuppressed(e);
                            }
                        }
                    } else {
                        exceptionToDisplay = null;
                    }
                } else {
                    exceptionToDisplay = exception;
                }
                if (exceptionToDisplay != null) {
                    Logger.LOG.warning("Failed to download java", exceptionToDisplay);
                    Controllers.dialog(DownloadProviders.localizeErrorMessage(exceptionToDisplay), I18n.i18n("install.failed"));
                }
            });
            Controllers.taskDialog(task, I18n.i18n("download.java.process"), TaskCancellationAction.NORMAL);
        }
    }

    private final class DownloadDiscoJava
    extends JFXDialogLayout {
        private final JFXComboBox<DiscoJavaDistribution> distributionBox;
        private final JFXComboBox<DiscoJavaRemoteVersion> remoteVersionBox;
        private final JFXComboBox<JavaPackageType> packageTypeBox;
        private final Label warningLabel = new Label();
        private final JFXButton downloadButton;
        private final StackPane downloadButtonPane = new StackPane();
        private final DownloadProvider downloadProvider = DownloadProviders.getDownloadProvider();
        private final Map<DiscoJavaDistribution, DiscoJavaVersionList> javaVersionLists = new HashMap<DiscoJavaDistribution, DiscoJavaVersionList>();
        private final ObjectProperty<DiscoJavaVersionList> currentJavaVersionList = new SimpleObjectProperty();

        DownloadDiscoJava() {
            assert (!JavaDownloadDialog.this.distributions.isEmpty());
            this.distributionBox = new JFXComboBox();
            this.distributionBox.setConverter(FXUtils.stringConverter(JavaDistribution::getDisplayName));
            this.remoteVersionBox = new JFXComboBox();
            this.remoteVersionBox.setConverter(FXUtils.stringConverter(JavaRemoteVersion::getDistributionVersion));
            this.packageTypeBox = new JFXComboBox(FXCollections.observableArrayList());
            this.downloadButton = new JFXButton(I18n.i18n("download"));
            this.downloadButton.setOnAction(e -> this.onDownload());
            this.downloadButton.getStyleClass().add((Object)"dialog-accept");
            this.downloadButton.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)this.remoteVersionBox.getSelectionModel().selectedItemProperty()));
            this.downloadButtonPane.getChildren().setAll((Object[])new Node[]{this.downloadButton});
            JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
            cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            cancelButton.getStyleClass().add((Object)"dialog-cancel");
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
            GridPane body = new GridPane();
            body.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
            body.setVgap(8.0);
            body.setHgap(16.0);
            body.addRow(0, new Node[]{new Label(I18n.i18n("java.download.distribution")), this.distributionBox});
            body.addRow(1, new Node[]{new Label(I18n.i18n("java.download.version")), this.remoteVersionBox});
            body.addRow(2, new Node[]{new Label(I18n.i18n("java.download.packageType")), this.packageTypeBox});
            this.distributionBox.setItems(FXCollections.observableList(new ArrayList<DiscoJavaDistribution>(JavaDownloadDialog.this.distributions)));
            FXUtils.onChange(this.packageTypeBox.getSelectionModel().selectedItemProperty(), packageType -> {
                DiscoJavaRemoteVersion version;
                int i;
                ObservableList<DiscoJavaRemoteVersion> versions;
                if (packageType == null || this.currentJavaVersionList.get() == null || (versions = ((DiscoJavaVersionList)this.currentJavaVersionList.get()).versions.get(packageType)) == null) {
                    this.remoteVersionBox.setItems(null);
                    return;
                }
                DiscoJavaRemoteVersion oldVersion = (DiscoJavaRemoteVersion)this.remoteVersionBox.getSelectionModel().getSelectedItem();
                this.remoteVersionBox.setItems(versions);
                if (oldVersion != null) {
                    for (i = 0; i < versions.size(); ++i) {
                        version = (DiscoJavaRemoteVersion)versions.get(i);
                        if (!Objects.equals(version.getDistributionVersion(), oldVersion.getDistributionVersion())) continue;
                        this.remoteVersionBox.getSelectionModel().select(i);
                        return;
                    }
                    for (i = 0; i < versions.size(); ++i) {
                        version = (DiscoJavaRemoteVersion)versions.get(i);
                        if (version.getJdkVersion() != oldVersion.getJdkVersion()) continue;
                        this.remoteVersionBox.getSelectionModel().select(i);
                        return;
                    }
                }
                for (i = 0; i < versions.size(); ++i) {
                    version = (DiscoJavaRemoteVersion)versions.get(i);
                    if (version.getJdkVersion() != GameJavaVersion.LATEST.majorVersion()) continue;
                    this.remoteVersionBox.getSelectionModel().select(i);
                    return;
                }
                for (i = 0; i < versions.size(); ++i) {
                    version = (DiscoJavaRemoteVersion)versions.get(i);
                    if (!version.isLTS()) continue;
                    this.remoteVersionBox.getSelectionModel().select(i);
                    return;
                }
                this.remoteVersionBox.getSelectionModel().selectFirst();
            });
            Consumer<DiscoJavaVersionList> updateListStatus = list -> {
                this.remoteVersionBox.setItems(null);
                this.packageTypeBox.getItems().clear();
                this.remoteVersionBox.setDisable(true);
                this.packageTypeBox.setDisable(true);
                this.warningLabel.setText(null);
                if (list == null || list.versions != null && list.versions.isEmpty()) {
                    this.downloadButtonPane.getChildren().setAll((Object[])new Node[]{this.downloadButton});
                } else if (list.status == DiscoJavaVersionList.Status.LOADING) {
                    this.downloadButtonPane.getChildren().setAll((Object[])new Node[]{new JFXSpinner()});
                } else {
                    this.downloadButtonPane.getChildren().setAll((Object[])new Node[]{this.downloadButton});
                    if (list.status == DiscoJavaVersionList.Status.SUCCESS) {
                        this.packageTypeBox.getItems().setAll(list.versions.keySet());
                        this.packageTypeBox.getSelectionModel().selectFirst();
                        this.remoteVersionBox.setDisable(false);
                        this.packageTypeBox.setDisable(false);
                    } else {
                        this.warningLabel.setText(I18n.i18n("java.download.load_list.failed"));
                    }
                }
            };
            this.currentJavaVersionList.addListener((observable, oldValue, newValue) -> {
                if (oldValue != null) {
                    oldValue.listener = null;
                }
                if (newValue != null) {
                    updateListStatus.accept((DiscoJavaVersionList)newValue);
                    if (newValue.status == DiscoJavaVersionList.Status.LOADING) {
                        newValue.listener = updateListStatus;
                    }
                } else {
                    this.currentJavaVersionList.set(null);
                    updateListStatus.accept(null);
                }
            });
            FXUtils.onChange(this.distributionBox.getSelectionModel().selectedItemProperty(), it -> this.currentJavaVersionList.set((Object)this.getJavaVersionList((DiscoJavaDistribution)it)));
            this.setHeading(new Node[]{new Label(I18n.i18n("java.download.title"))});
            this.setBody(new Node[]{body});
            this.setActions(new Node[]{this.warningLabel, this.downloadButtonPane, cancelButton});
            if (JavaDownloadDialog.this.platform.getOperatingSystem() == OperatingSystem.LINUX && JavaDownloadDialog.this.platform.getArchitecture() == Architecture.RISCV64) {
                JFXHyperlink hyperlink = new JFXHyperlink(I18n.i18n("java.download.banshanjdk-8"));
                hyperlink.setExternalLink("https://www.zthread.cn/#product");
                this.getActions().add(0, (Object)hyperlink);
            }
        }

        private void onDownload() {
            this.fireEvent(new DialogCloseEvent());
            DiscoJavaDistribution distribution = (DiscoJavaDistribution)this.distributionBox.getSelectionModel().getSelectedItem();
            DiscoJavaRemoteVersion version = (DiscoJavaRemoteVersion)this.remoteVersionBox.getSelectionModel().getSelectedItem();
            JavaPackageType packageType = (JavaPackageType)((Object)this.packageTypeBox.getSelectionModel().getSelectedItem());
            if (version == null) {
                return;
            }
            Controllers.taskDialog(new GetTask(this.downloadProvider.injectURLWithCandidates(version.getLinks().getPkgInfoUri())).setExecutor(Schedulers.io()).thenComposeAsync(json -> {
                Task<FileDownloadTask.IntegrityCheck> getIntegrityCheck;
                DiscoResult<DiscoRemoteFileInfo> result = JsonUtils.fromNonNullJson(json, DiscoResult.typeOf(DiscoRemoteFileInfo.class));
                if (result.getResult().size() != 1) {
                    throw new IOException("Illegal result: " + json);
                }
                DiscoRemoteFileInfo fileInfo = result.getResult().get(0);
                if (!fileInfo.getChecksumType().equals("sha1") && !fileInfo.getChecksumType().equals("sha256")) {
                    throw new IOException("Unsupported checksum type: " + fileInfo.getChecksumType());
                }
                if (StringUtils.isBlank(fileInfo.getDirectDownloadUri())) {
                    throw new IOException("Missing download URI: " + json);
                }
                Path targetFile = Files.createTempFile("hmcl-java-", "." + version.getArchiveType(), new FileAttribute[0]);
                targetFile.toFile().deleteOnExit();
                if (StringUtils.isNotBlank(fileInfo.getChecksum())) {
                    getIntegrityCheck = Task.completed(new FileDownloadTask.IntegrityCheck(fileInfo.getChecksumType(), fileInfo.getChecksum()));
                } else if (StringUtils.isNotBlank(fileInfo.getChecksumUri())) {
                    getIntegrityCheck = new GetTask(this.downloadProvider.injectURLWithCandidates(fileInfo.getChecksumUri())).thenApplyAsync(checksum -> {
                        int idx = (checksum = checksum.trim()).indexOf(32);
                        if (idx > 0) {
                            checksum = checksum.substring(0, idx);
                        }
                        return new FileDownloadTask.IntegrityCheck(fileInfo.getChecksumType(), (String)checksum);
                    });
                } else {
                    throw new IOException("Unable to get checksum for file");
                }
                return getIntegrityCheck.thenComposeAsync(integrityCheck -> new FileDownloadTask(this.downloadProvider.injectURLWithCandidates(fileInfo.getDirectDownloadUri()), targetFile, (FileDownloadTask.IntegrityCheck)integrityCheck).setName(fileInfo.getFileName())).thenSupplyAsync(() -> targetFile);
            }).whenComplete(Schedulers.javafx(), (result, exception) -> {
                if (exception == null) {
                    String javaVersion = version.getJavaVersion();
                    JavaInfo info = new JavaInfo(JavaDownloadDialog.this.platform, javaVersion, distribution.getVendor());
                    LinkedHashMap<String, Object> updateInfo = new LinkedHashMap<String, Object>();
                    updateInfo.put("type", "disco");
                    updateInfo.put("info", version);
                    int idx = javaVersion.indexOf(43);
                    if (idx > 0) {
                        javaVersion = javaVersion.substring(0, idx);
                    }
                    String defaultName = distribution.getApiParameter() + "-" + javaVersion + "-" + packageType.name().toLowerCase(Locale.ROOT);
                    Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new JavaInstallPage(controller::onFinish, info, version, (Map<String, Object>)updateInfo, defaultName, (Path)result)));
                } else {
                    Logger.LOG.warning("Failed to download java", exception);
                    Throwable resolvedException = Lang.resolveException(exception);
                    if (!(resolvedException instanceof CancellationException)) {
                        Controllers.dialog(DownloadProviders.localizeErrorMessage(resolvedException), I18n.i18n("install.failed"));
                    }
                }
            }), I18n.i18n("java.download"), TaskCancellationAction.NORMAL);
        }

        private DiscoJavaVersionList getJavaVersionList(DiscoJavaDistribution distribution) {
            if (distribution == null) {
                return null;
            }
            return this.javaVersionLists.computeIfAbsent(distribution, it -> {
                DiscoJavaVersionList versionList = new DiscoJavaVersionList((DiscoJavaDistribution)it);
                new DiscoFetchJavaListTask(this.downloadProvider, (DiscoJavaDistribution)it, JavaDownloadDialog.this.platform).setExecutor(Schedulers.io()).thenApplyAsync(versions -> {
                    EnumMap<JavaPackageType, ObservableList> result = new EnumMap<JavaPackageType, ObservableList>(JavaPackageType.class);
                    if (versions.isEmpty()) {
                        return result;
                    }
                    for (Map.Entry entry : versions.entrySet()) {
                        for (DiscoJavaRemoteVersion version : ((TreeMap)entry.getValue()).values()) {
                            if (!version.isLTS() && version.getJdkVersion() != ((Integer)((TreeMap)entry.getValue()).lastKey()).intValue() && version.getJdkVersion() != 16) continue;
                            result.computeIfAbsent((JavaPackageType)((Object)((Object)((Object)entry.getKey()))), ignored -> FXCollections.observableArrayList()).add((Object)version);
                        }
                    }
                    for (List l : result.values()) {
                        Collections.reverse(l);
                    }
                    return result;
                }).whenComplete(Schedulers.javafx(), (result, exception) -> {
                    if (exception == null) {
                        versionList.status = DiscoJavaVersionList.Status.SUCCESS;
                        versionList.versions = result;
                    } else {
                        Logger.LOG.warning("Failed to load java list", exception);
                        versionList.status = DiscoJavaVersionList.Status.FAILED;
                    }
                    versionList.invalidate();
                }).start();
                return versionList;
            });
        }
    }

    private static final class DiscoJavaVersionList {
        final DiscoJavaDistribution distribution;
        Status status = Status.LOADING;
        EnumMap<JavaPackageType, ObservableList<DiscoJavaRemoteVersion>> versions;
        Consumer<DiscoJavaVersionList> listener;

        DiscoJavaVersionList(DiscoJavaDistribution distribution) {
            this.distribution = distribution;
        }

        void invalidate() {
            if (this.listener != null) {
                this.listener.accept(this);
            }
        }

        static enum Status {
            LOADING,
            SUCCESS,
            FAILED;

        }
    }
}

