/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.ImageContainer;
import org.jackhuang.hmcl.util.i18n.I18n;

public class GameAdvancedListItem
extends AdvancedListItem {
    private final ImageContainer imageContainer;
    private final WeakListenerHolder holder = new WeakListenerHolder();
    private Profile profile;
    private Consumer<Event> onVersionIconChangedListener;

    public GameAdvancedListItem() {
        this.imageContainer = new ImageContainer(32.0);
        this.imageContainer.setMouseTransparent(true);
        AdvancedListItem.setAlignment((Node)this.imageContainer, Pos.CENTER);
        this.setLeftGraphic((Node)this.imageContainer);
        this.holder.add(FXUtils.onWeakChangeAndOperate(Profiles.selectedVersionProperty(), this::loadVersion));
    }

    private void loadVersion(String version) {
        if (Profiles.getSelectedProfile() != this.profile) {
            this.profile = Profiles.getSelectedProfile();
            if (this.profile != null) {
                this.onVersionIconChangedListener = this.profile.getRepository().onVersionIconChanged.registerWeak(event -> this.loadVersion(Profiles.getSelectedVersion()));
            }
        }
        if (version != null && Profiles.getSelectedProfile() != null && Profiles.getSelectedProfile().getRepository().hasVersion(version)) {
            this.setTitle(I18n.i18n("version.manage.manage"));
            this.setSubtitle(version);
            this.imageContainer.setImage(Profiles.getSelectedProfile().getRepository().getVersionIconImage(version));
        } else {
            this.setTitle(I18n.i18n("version.empty"));
            this.setSubtitle(I18n.i18n("version.empty.add"));
            this.imageContainer.setImage(VersionIconType.DEFAULT.getIcon());
        }
    }
}

