/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextField;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.animation.PauseTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.profile.ProfileListItem;
import org.jackhuang.hmcl.ui.profile.ProfilePage;
import org.jackhuang.hmcl.ui.versions.GameListCell;
import org.jackhuang.hmcl.ui.versions.GameListItem;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class GameListPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("version.manage")));
    private final ListProperty<Profile> profiles = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObservableList<ProfileListItem> profileListItems = MappedObservableList.create(this.profilesProperty(), profile -> {
        ProfileListItem item = new ProfileListItem((Profile)profile);
        FXUtils.setLimitWidth((Region)item, 200.0);
        return item;
    });
    private final ObjectProperty<Profile> selectedProfile = ExtendedProperties.createSelectedItemPropertyFor(this.profileListItems, Profile.class);

    public GameListPage() {
        ScrollPane pane = new ScrollPane();
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        AdvancedListItem addProfileItem = new AdvancedListItem();
        addProfileItem.getStyleClass().add((Object)"navigation-drawer-item");
        addProfileItem.setTitle(I18n.i18n("profile.new"));
        addProfileItem.setLeftIcon(SVG.ADD_CIRCLE);
        addProfileItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)new ProfilePage(null))));
        pane.setFitToWidth(true);
        VBox wrapper = new VBox();
        wrapper.getStyleClass().add((Object)"advanced-list-box-content");
        VBox box = new VBox();
        box.setFillWidth(true);
        Bindings.bindContent((List)box.getChildren(), this.profileListItems);
        wrapper.getChildren().setAll((Object[])new Node[]{box, addProfileItem});
        pane.setContent((Node)wrapper);
        AdvancedListBox bottomLeftCornerList = new AdvancedListBox().addNavigationDrawerItem(I18n.i18n("install.new_game"), SVG.ADD_CIRCLE, Versions::addNewGame).addNavigationDrawerItem(I18n.i18n("install.modpack"), SVG.PACKAGE2, Versions::importModpack).addNavigationDrawerItem(I18n.i18n("settings.type.global.manage"), SVG.SETTINGS, this::modifyGlobalGameSettings);
        FXUtils.setLimitHeight((Region)bottomLeftCornerList, 144.0);
        this.setLeft(new Node[]{pane, bottomLeftCornerList});
        this.setCenter(new Node[]{new GameList()});
    }

    public ObjectProperty<Profile> selectedProfileProperty() {
        return this.selectedProfile;
    }

    public ObservableList<Profile> getProfiles() {
        return (ObservableList)this.profiles.get();
    }

    public ListProperty<Profile> profilesProperty() {
        return this.profiles;
    }

    public void setProfiles(ObservableList<Profile> profiles) {
        this.profiles.set(profiles);
    }

    public void modifyGlobalGameSettings() {
        Versions.modifyGlobalSettings(Profiles.getSelectedProfile());
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    private static class GameList
    extends ListPageBase<GameListItem> {
        private final WeakListenerHolder listenerHolder = new WeakListenerHolder();
        private final ObservableList<GameListItem> sourceList = FXCollections.observableArrayList();
        private final FilteredList<GameListItem> filteredList = new FilteredList(this.sourceList);

        public GameList() {
            this.setItems(this.filteredList);
            Profiles.registerVersionsListener(this::loadVersions);
            this.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getDownloadPage())));
        }

        private void loadVersions(Profile profile) {
            this.listenerHolder.clear();
            this.setLoading(true);
            this.setFailedReason(null);
            List<GameListItem> versionItems = profile.getRepository().getDisplayVersions().map(instance -> new GameListItem(profile, instance.getId())).toList();
            this.sourceList.setAll(versionItems);
            if (versionItems.isEmpty()) {
                this.setFailedReason(I18n.i18n("version.empty.hint"));
            }
            this.setLoading(false);
        }

        private Predicate<GameListItem> createPredicate(String searchText) {
            if (searchText == null || searchText.isEmpty()) {
                return item -> true;
            }
            if (searchText.startsWith("regex:")) {
                String regex = searchText.substring("regex:".length());
                try {
                    Pattern pattern = Pattern.compile(regex, 2);
                    return item -> pattern.matcher(item.id).find();
                }
                catch (PatternSyntaxException e) {
                    return item -> false;
                }
            }
            return item -> item.id.toLowerCase(Locale.ROOT).contains(searchText.toLowerCase(Locale.ROOT));
        }

        public void refreshList() {
            Profiles.getSelectedProfile().getRepository().refreshVersionsAsync().start();
        }

        protected Skin<?> createDefaultSkin() {
            return new GameListSkin(this);
        }

        private static class GameListSkin
        extends SkinBase<GameList> {
            private final TransitionPane toolbarPane;
            private final HBox searchBar;
            private final HBox toolbarNormal;
            private final JFXTextField searchField;

            public GameListSkin(GameList skinnable) {
                super((Control)skinnable);
                StackPane pane = new StackPane();
                pane.setPadding(new Insets(10.0));
                pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
                ComponentList root = new ComponentList();
                root.getStyleClass().add((Object)"no-padding");
                JFXListView listView = new JFXListView();
                this.toolbarPane = new TransitionPane();
                this.searchBar = new HBox();
                this.toolbarNormal = new HBox();
                this.searchBar.setAlignment(Pos.CENTER);
                this.searchBar.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                this.searchField = new JFXTextField();
                this.searchField.setPromptText(I18n.i18n("search"));
                HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
                PauseTransition pause = new PauseTransition(Duration.millis((double)100.0));
                pause.setOnFinished(e -> skinnable.filteredList.setPredicate(skinnable.createPredicate(this.searchField.getText())));
                this.searchField.textProperty().addListener((observable, oldValue, newValue) -> {
                    pause.setRate(1.0);
                    pause.playFromStart();
                });
                JFXButton closeSearchBar = ToolbarListPageSkin.createToolbarButton2(null, SVG.CLOSE, () -> {
                    this.changeToolbar(this.toolbarNormal);
                    this.searchField.clear();
                });
                FXUtils.onEscPressed((Node)this.searchField, () -> ((JFXButton)closeSearchBar).fire());
                this.searchBar.getChildren().setAll((Object[])new Node[]{this.searchField, closeSearchBar});
                Object[] objectArray = new Node[2];
                objectArray[0] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refreshList);
                objectArray[1] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("search"), SVG.SEARCH, () -> this.changeToolbar(this.searchBar));
                this.toolbarNormal.getChildren().setAll(objectArray);
                this.toolbarPane.setContent((Node)this.toolbarNormal, ContainerAnimations.FADE);
                root.getContent().add((Object)this.toolbarPane);
                SpinnerPane center = new SpinnerPane();
                ComponentList.setVgrow((Node)center, Priority.ALWAYS);
                center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
                center.failedReasonProperty().bind((ObservableValue)skinnable.failedReasonProperty());
                listView.setCellFactory(x -> new GameListCell());
                listView.setItems(skinnable.getItems());
                FXUtils.ignoreEvent(listView, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
                center.setContent((Node)listView);
                root.getContent().add((Object)center);
                pane.getChildren().setAll((Object[])new Node[]{root});
                this.getChildren().setAll((Object[])new Node[]{pane});
            }

            private void changeToolbar(HBox newToolbar) {
                Node oldToolbar = this.toolbarPane.getCurrentNode();
                if (newToolbar != oldToolbar) {
                    this.toolbarPane.setContent((Node)newToolbar, ContainerAnimations.FADE);
                    if (newToolbar == this.searchBar) {
                        FXUtils.runInFX(() -> ((JFXTextField)this.searchField).requestFocus());
                    }
                }
            }
        }
    }
}

