/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.jackhuang.hmcl.countly.CrashReport;
import org.jackhuang.hmcl.ui.CrashWindow;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class CrashReporter
implements Thread.UncaughtExceptionHandler {
    private final boolean showCrashWindow;

    private boolean checkThrowable(Throwable e) {
        String s = StringUtils.getStackTrace(e);
        for (Pair<String, String> entry : Hole.SOURCE) {
            if (!s.contains(entry.getKey())) continue;
            if (StringUtils.isNotBlank(entry.getValue())) {
                String info = entry.getValue();
                Logger.LOG.error(info);
                try {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, info, new ButtonType[0]);
                    alert.setTitle(I18n.i18n("message.info"));
                    alert.setHeaderText(I18n.i18n("message.info"));
                    alert.showAndWait();
                }
                catch (Throwable t) {
                    Logger.LOG.error("Unable to show message", t);
                }
            }
            return false;
        }
        return true;
    }

    public CrashReporter(boolean showCrashWindow) {
        this.showCrashWindow = showCrashWindow;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Logger.LOG.error("Uncaught exception in thread " + t.getName(), e);
        try {
            CrashReport report = new CrashReport(t, e);
            if (!report.shouldBeReport()) {
                return;
            }
            Logger.LOG.error(report.getDisplayText());
            Platform.runLater(() -> {
                if (this.checkThrowable(e) && this.showCrashWindow) {
                    new CrashWindow(report).show();
                }
            });
        }
        catch (Throwable handlingException) {
            Logger.LOG.error("Unable to handle uncaught exception", handlingException);
        }
        FileSaver.shutdown();
        Logger.LOG.shutdown();
    }

    private static final class Hole {
        static final Pair<String, String>[] SOURCE = new Pair[]{Pair.pair("Location is not set", I18n.i18n("crash.NoClassDefFound")), Pair.pair("UnsatisfiedLinkError", I18n.i18n("crash.user_fault")), Pair.pair("java.time.zone.ZoneRulesException: Unable to load TZDB time-zone rules", I18n.i18n("crash.user_fault")), Pair.pair("java.lang.NoClassDefFoundError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("org.jackhuang.hmcl.util.ResourceNotFoundError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("java.lang.VerifyError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("java.lang.NoSuchMethodError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("java.lang.NoSuchFieldError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("javax.imageio.IIOException", I18n.i18n("crash.NoClassDefFound")), Pair.pair("netscape.javascript.JSException", I18n.i18n("crash.NoClassDefFound")), Pair.pair("java.lang.IncompatibleClassChangeError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("java.lang.ClassFormatError", I18n.i18n("crash.NoClassDefFound")), Pair.pair("com.sun.javafx.css.StyleManager.findMatchingStyles", I18n.i18n("launcher.update_java")), Pair.pair("NoSuchAlgorithmException", "Has your operating system been installed completely or is a ghost system?")};

        private Hole() {
        }
    }
}

