/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Result<T> {
    private final T value;
    private final Throwable exception;

    public static <T> Result<T> success(T value) {
        return new Result<T>(value, null);
    }

    public static <T> Result<T> failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new Result<Object>(null, exception);
    }

    private Result(T value, Throwable exception) {
        this.value = value;
        this.exception = exception;
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public boolean isFailure() {
        return this.exception != null;
    }

    public T get() throws Throwable {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    @Nullable
    public T getOrNull() {
        return this.exception == null ? (T)this.value : null;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.exception);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Result)) return false;
        Result other = (Result)obj;
        if (!Objects.equals(this.value, other.value)) return false;
        if (!Objects.equals(this.exception, other.exception)) return false;
        return true;
    }
}

