/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;

public class JFXNodesList
extends VBox {
    private final HashMap<Node, Callback<Boolean, Collection<KeyValue>>> animationsMap = new HashMap();
    private boolean expanded = false;
    private final Timeline animateTimeline = new Timeline();

    public JFXNodesList() {
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-nodes-list");
    }

    public void addAnimatedNode(Region node) {
        this.addAnimatedNode(node, null);
    }

    public void addAnimatedNode(Region node, Callback<Boolean, Collection<KeyValue>> animationCallBack) {
        if (node instanceof JFXNodesList) {
            StackPane container = new StackPane(new Node[]{node});
            container.setPickOnBounds(false);
            this.addAnimatedNode((Region)container, animationCallBack);
            return;
        }
        node.setVisible(false);
        node.minWidthProperty().bind((ObservableValue)node.prefWidthProperty());
        node.minHeightProperty().bind((ObservableValue)node.prefHeightProperty());
        if (this.getChildren().size() > 0) {
            this.initNode((Node)node);
        } else {
            if (node instanceof Button) {
                ((Button)node).setOnAction(action -> this.animateList());
            } else {
                node.setOnMouseClicked(click -> this.animateList());
            }
            node.getStyleClass().add((Object)"trigger-node");
        }
        if (this.getChildren().size() == 0) {
            node.setVisible(true);
            this.minHeightProperty().bind((ObservableValue)node.prefHeightProperty());
            this.maxHeightProperty().bind((ObservableValue)node.prefHeightProperty());
            this.minWidthProperty().bind((ObservableValue)node.prefWidthProperty());
            this.maxWidthProperty().bind((ObservableValue)node.prefWidthProperty());
        }
        this.getChildren().add((Object)node);
        this.rotateProperty().addListener((o, oldVal, newVal) -> node.setRotate(newVal.doubleValue() % 180.0 == 0.0 ? newVal.doubleValue() : -newVal.doubleValue()));
        if (animationCallBack == null && this.getChildren().size() != 1) {
            animationCallBack = expanded -> this.initDefaultAnimation(node, (boolean)expanded);
        } else if (animationCallBack == null && this.getChildren().size() == 1) {
            animationCallBack = expanded -> new ArrayList();
        }
        this.animationsMap.put((Node)node, animationCallBack);
    }

    public void animateList() {
        boolean bl = this.expanded = !this.expanded;
        if (this.animateTimeline.getStatus() == Animation.Status.RUNNING) {
            this.animateTimeline.stop();
        }
        this.animateTimeline.getKeyFrames().clear();
        double duration = 120.0 / (double)this.getChildren().size();
        if (this.expanded) {
            this.getChildren().forEach(child -> child.setVisible(true));
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            Node child2 = (Node)this.getChildren().get(i);
            Collection keyValues = (Collection)this.animationsMap.get(child2).call((Object)this.expanded);
            this.animateTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)((double)i * duration)), keyValues.toArray(new KeyValue[keyValues.size()])));
        }
        Collection keyValues = (Collection)this.animationsMap.get(this.getChildren().get(0)).call((Object)this.expanded);
        this.animateTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)160.0), keyValues.toArray(new KeyValue[keyValues.size()])));
        if (!this.expanded) {
            this.animateTimeline.setOnFinished(finish -> {
                for (int i = 1; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setVisible(false);
                }
            });
        } else {
            this.animateTimeline.setOnFinished(null);
        }
        this.animateTimeline.play();
    }

    protected void initNode(Node node) {
        node.setScaleX(0.0);
        node.setScaleY(0.0);
        node.getStyleClass().add((Object)"sub-node");
    }

    private ArrayList<KeyValue> initDefaultAnimation(Region region, boolean expanded) {
        ArrayList<KeyValue> defaultAnimationValues = new ArrayList<KeyValue>();
        defaultAnimationValues.add(new KeyValue((WritableValue)region.scaleXProperty(), (Object)(expanded ? 1 : 0), Interpolator.EASE_BOTH));
        defaultAnimationValues.add(new KeyValue((WritableValue)region.scaleYProperty(), (Object)(expanded ? 1 : 0), Interpolator.EASE_BOTH));
        return defaultAnimationValues;
    }
}

