/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDecorator;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.skins.JFXCustomColorPicker;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.JFXFillTransition;
import com.sun.javafx.util.Utils;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.jackhuang.hmcl.setting.StyleSheets;

public class JFXCustomColorPickerDialog
extends StackPane {
    private final Stage dialog = new Stage();
    private final AtomicInteger concurrencyController = new AtomicInteger(-1);
    private final ObjectProperty<Color> currentColorProperty = new SimpleObjectProperty((Object)Color.WHITE);
    private final ObjectProperty<Color> customColorProperty = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private Runnable onSave;
    private final Scene customScene;
    private final JFXCustomColorPicker curvedColorPicker;
    private ParallelTransition paraTransition;
    private final JFXDecorator pickerDecorator;
    private boolean systemChange = false;
    private boolean userChange = false;
    private boolean initOnce = true;
    private final Runnable initRun;
    private InvalidationListener positionAdjuster = new InvalidationListener(){

        public void invalidated(Observable ignored) {
            if (Double.isNaN(JFXCustomColorPickerDialog.this.dialog.getWidth()) || Double.isNaN(JFXCustomColorPickerDialog.this.dialog.getHeight())) {
                return;
            }
            JFXCustomColorPickerDialog.this.dialog.widthProperty().removeListener(JFXCustomColorPickerDialog.this.positionAdjuster);
            JFXCustomColorPickerDialog.this.dialog.heightProperty().removeListener(JFXCustomColorPickerDialog.this.positionAdjuster);
            JFXCustomColorPickerDialog.this.fixPosition();
        }
    };

    public JFXCustomColorPickerDialog(Window owner) {
        this.getStyleClass().add((Object)"custom-color-dialog");
        if (owner != null) {
            this.dialog.initOwner(owner);
        }
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.TRANSPARENT);
        this.dialog.setResizable(false);
        this.pickerDecorator = new JFXDecorator(this.dialog, (Node)this, false, false, false);
        this.pickerDecorator.setOnCloseButtonAction(this::updateColor);
        this.pickerDecorator.setPickOnBounds(false);
        this.customScene = new Scene((Parent)this.pickerDecorator, (Paint)Color.TRANSPARENT);
        StyleSheets.init(this.customScene);
        this.curvedColorPicker = new JFXCustomColorPicker();
        StackPane pane = new StackPane(new Node[]{this.curvedColorPicker});
        pane.setPadding(new Insets(18.0));
        VBox container = new VBox();
        container.getChildren().add((Object)pane);
        JFXTabPane tabs = new JFXTabPane();
        JFXTextField rgbField = new JFXTextField();
        JFXTextField hsbField = new JFXTextField();
        JFXTextField hexField = new JFXTextField();
        rgbField.getStyleClass().add((Object)"custom-color-field");
        rgbField.setPromptText("RGB Color");
        rgbField.textProperty().addListener((o, oldVal, newVal) -> this.updateColorFromUserInput((String)newVal));
        hsbField.getStyleClass().add((Object)"custom-color-field");
        hsbField.setPromptText("HSB Color");
        hsbField.textProperty().addListener((o, oldVal, newVal) -> this.updateColorFromUserInput((String)newVal));
        hexField.getStyleClass().add((Object)"custom-color-field");
        hexField.setPromptText("#HEX Color");
        hexField.textProperty().addListener((o, oldVal, newVal) -> this.updateColorFromUserInput((String)newVal));
        StackPane tabContent = new StackPane();
        tabContent.getChildren().add((Object)rgbField);
        tabContent.setMinHeight(100.0);
        Tab rgbTab = new Tab("RGB");
        rgbTab.setContent((Node)tabContent);
        Tab hsbTab = new Tab("HSB");
        hsbTab.setContent((Node)hsbField);
        Tab hexTab = new Tab("HEX");
        hexTab.setContent((Node)hexField);
        tabs.getTabs().add((Object)hexTab);
        tabs.getTabs().add((Object)rgbTab);
        tabs.getTabs().add((Object)hsbTab);
        this.curvedColorPicker.selectedPath.addListener((o, oldVal, newVal) -> {
            if (this.paraTransition != null) {
                this.paraTransition.stop();
            }
            Region tabsHeader = (Region)tabs.lookup(".tab-header-background");
            pane.backgroundProperty().unbind();
            tabsHeader.backgroundProperty().unbind();
            JFXFillTransition fillTransition = new JFXFillTransition(Duration.millis((double)240.0), (Region)pane, (Color)oldVal.getFill(), (Color)newVal.getFill());
            JFXFillTransition tabsFillTransition = new JFXFillTransition(Duration.millis((double)240.0), tabsHeader, (Color)oldVal.getFill(), (Color)newVal.getFill());
            this.paraTransition = new ParallelTransition(new Animation[]{fillTransition, tabsFillTransition});
            this.paraTransition.setOnFinished(finish -> {
                tabsHeader.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(newVal.getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{newVal.fillProperty()}));
                pane.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(newVal.getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{newVal.fillProperty()}));
            });
            this.paraTransition.play();
        });
        this.initRun = () -> {
            pane.backgroundProperty().addListener((o, oldVal, newVal) -> {
                if (this.concurrencyController.getAndSet(1) == -1) {
                    Color fontColor = ((Color)((BackgroundFill)newVal.getFills().get(0)).getFill()).grayscale().getRed() > 0.5 ? Color.valueOf((String)"rgba(40, 40, 40, 0.87)") : Color.valueOf((String)"rgba(255, 255, 255, 0.87)");
                    this.pickerDecorator.lookupAll(".jfx-decorator-button").forEach(button -> {
                        ((JFXButton)((Object)((Object)((Object)button)))).setRipplerFill((Paint)fontColor);
                        ((SVGGlyph)((JFXButton)((Object)((Object)((Object)button)))).getGraphic()).setFill((Paint)fontColor);
                    });
                    Color newColor = (Color)((BackgroundFill)newVal.getFills().get(0)).getFill();
                    String hex = String.format("#%02X%02X%02X", (int)(newColor.getRed() * 255.0), (int)(newColor.getGreen() * 255.0), (int)(newColor.getBlue() * 255.0));
                    String rgb = String.format("rgba(%d, %d, %d, 1)", (int)(newColor.getRed() * 255.0), (int)(newColor.getGreen() * 255.0), (int)(newColor.getBlue() * 255.0));
                    String hsb = String.format("hsl(%d, %d%%, %d%%)", (int)newColor.getHue(), (int)(newColor.getSaturation() * 100.0), (int)(newColor.getBrightness() * 100.0));
                    if (!this.userChange) {
                        this.systemChange = true;
                        rgbField.setText(rgb);
                        hsbField.setText(hsb);
                        hexField.setText(hex);
                        this.systemChange = false;
                    }
                    this.concurrencyController.getAndSet(-1);
                }
            });
            Platform.runLater(() -> {
                pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()), CornerRadii.EMPTY, Insets.EMPTY)}));
                ((Region)tabs.lookup(".tab-header-background")).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()), CornerRadii.EMPTY, Insets.EMPTY)}));
                Region tabsHeader = (Region)tabs.lookup(".tab-header-background");
                pane.backgroundProperty().unbind();
                tabsHeader.backgroundProperty().unbind();
                tabsHeader.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(((JFXCustomColorPicker.RecentColorPath)((Object)((Object)((Object)((Object)this.curvedColorPicker.selectedPath.get()))))).getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{((JFXCustomColorPicker.RecentColorPath)((Object)((Object)((Object)this.curvedColorPicker.selectedPath.get())))).fillProperty()}));
                pane.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(((JFXCustomColorPicker.RecentColorPath)((Object)((Object)((Object)((Object)this.curvedColorPicker.selectedPath.get()))))).getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{((JFXCustomColorPicker.RecentColorPath)((Object)((Object)((Object)this.curvedColorPicker.selectedPath.get())))).fillProperty()}));
                rgbField.focusColorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((BackgroundFill)pane.getBackground().getFills().get(0)).getFill(), (Observable[])new Observable[]{pane.backgroundProperty()}));
                hsbField.focusColorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((BackgroundFill)pane.getBackground().getFills().get(0)).getFill(), (Observable[])new Observable[]{pane.backgroundProperty()}));
                hexField.focusColorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((BackgroundFill)pane.getBackground().getFills().get(0)).getFill(), (Observable[])new Observable[]{pane.backgroundProperty()}));
                ((Pane)this.pickerDecorator.lookup(".jfx-decorator-buttons-container")).backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(((BackgroundFill)pane.getBackground().getFills().get(0)).getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{pane.backgroundProperty()}));
                ((Pane)this.pickerDecorator.lookup(".jfx-decorator-content-container")).borderProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Border(new BorderStroke[]{new BorderStroke(((BackgroundFill)pane.getBackground().getFills().get(0)).getFill(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))}), (Observable[])new Observable[]{pane.backgroundProperty()}));
            });
        };
        container.getChildren().add((Object)tabs);
        this.getChildren().add((Object)container);
        this.setPadding(new Insets(0.0));
        this.dialog.setScene(this.customScene);
        EventHandler keyEventListener = key -> {
            switch (key.getCode()) {
                case ESCAPE: {
                    this.close();
                    break;
                }
                case ENTER: {
                    this.updateColor();
                    break;
                }
            }
        };
        this.dialog.addEventHandler(KeyEvent.ANY, keyEventListener);
    }

    private void updateColor() {
        this.close();
        this.customColorProperty.set((Object)this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()));
        this.onSave.run();
    }

    private void updateColorFromUserInput(String colorWebString) {
        if (!this.systemChange) {
            this.userChange = true;
            try {
                this.curvedColorPicker.setColor(Color.valueOf((String)colorWebString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.userChange = false;
        }
    }

    private void close() {
        this.dialog.setScene(null);
        this.dialog.close();
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColorProperty.set((Object)currentColor);
    }

    Color getCurrentColor() {
        return (Color)this.currentColorProperty.get();
    }

    ObjectProperty<Color> customColorProperty() {
        return this.customColorProperty;
    }

    void setCustomColor(Color color) {
        this.customColorProperty.set((Object)color);
    }

    Color getCustomColor() {
        return (Color)this.customColorProperty.get();
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable onSave) {
        this.onSave = onSave;
    }

    public void setOnHidden(EventHandler<WindowEvent> onHidden) {
        this.dialog.setOnHidden(onHidden);
    }

    public void show() {
        this.dialog.setOpacity(0.0);
        if (this.dialog.getOwner() != null) {
            this.dialog.widthProperty().addListener(this.positionAdjuster);
            this.dialog.heightProperty().addListener(this.positionAdjuster);
            this.positionAdjuster.invalidated(null);
        }
        if (this.dialog.getScene() == null) {
            this.dialog.setScene(this.customScene);
        }
        this.curvedColorPicker.preAnimate();
        this.dialog.show();
        if (this.initOnce) {
            this.initRun.run();
            this.initOnce = false;
        }
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), new KeyValue[]{new KeyValue((WritableValue)this.dialog.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
        timeline.setOnFinished(finish -> this.curvedColorPicker.animate());
        timeline.play();
    }

    private void fixPosition() {
        Window w = this.dialog.getOwner();
        Screen s = Utils.getScreen((Object)w);
        Rectangle2D sb = s.getBounds();
        double xR = w.getX() + w.getWidth();
        double xL = w.getX() - this.dialog.getWidth();
        double x = sb.getMaxX() >= xR + this.dialog.getWidth() ? xR : (sb.getMinX() <= xL ? xL : Math.max(sb.getMinX(), sb.getMaxX() - this.dialog.getWidth()));
        double y = Math.max(sb.getMinY(), Math.min(sb.getMaxY() - this.dialog.getHeight(), w.getY()));
        this.dialog.setX(x);
        this.dialog.setY(y);
    }

    public void layoutChildren() {
        super.layoutChildren();
        if (this.dialog.getMinWidth() > 0.0 && this.dialog.getMinHeight() > 0.0) {
            return;
        }
        double minWidth = Math.max(0.0, this.computeMinWidth(this.getHeight()) + (this.dialog.getWidth() - this.customScene.getWidth()));
        double minHeight = Math.max(0.0, this.computeMinHeight(this.getWidth()) + (this.dialog.getHeight() - this.customScene.getHeight()));
        this.dialog.setMinWidth(minWidth);
        this.dialog.setMinHeight(minHeight);
    }
}

