/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.SliderSkin;
import com.jfoenix.controls.JFXSlider;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSliderSkin
extends SliderSkin {
    private Paint thumbColor = Color.valueOf((String)"#0F9D58");
    private Paint trackColor = Color.valueOf((String)"#CCCCCC");
    private Text sliderValue;
    private StackPane coloredTrack;
    private StackPane thumb;
    private StackPane track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
    private StackPane animatedThumb;
    private Timeline timeline;
    private double indicatorRotation;
    private double horizontalRotation;
    private double shifting;
    private boolean isValid = false;
    private boolean internalChange = false;

    public JFXSliderSkin(JFXSlider slider) {
        super(slider);
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.track.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.trackColor, new CornerRadii(5.0), Insets.EMPTY)}));
        this.thumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.thumbColor, new CornerRadii(20.0), Insets.EMPTY)}));
        this.track.setPrefHeight(2.0);
        this.track.setPrefWidth(2.0);
        this.coloredTrack = new StackPane();
        this.coloredTrack.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            BackgroundFill trackBackgroundFill = (BackgroundFill)this.track.getBackground().getFills().get(0);
            return new Background(new BackgroundFill[]{new BackgroundFill(((BackgroundFill)this.thumb.getBackground().getFills().get(0)).getFill(), trackBackgroundFill.getRadii(), trackBackgroundFill.getInsets())});
        }, (Observable[])new Observable[]{this.track.backgroundProperty(), this.thumb.backgroundProperty()}));
        this.coloredTrack.setMouseTransparent(true);
        this.sliderValue = new Text();
        this.sliderValue.setStroke((Paint)Color.WHITE);
        this.sliderValue.setFont(new Font(10.0));
        this.sliderValue.getStyleClass().setAll((Object[])new String[]{"slider-value"});
        this.animatedThumb = new StackPane();
        this.animatedThumb.getStyleClass().add((Object)"animated-thumb");
        this.animatedThumb.getChildren().add((Object)this.sliderValue);
        this.animatedThumb.setMouseTransparent(true);
        this.animatedThumb.setPrefSize(30.0, 30.0);
        this.animatedThumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.thumbColor, new CornerRadii(50.0, 50.0, 50.0, 0.0, true), null)}));
        this.animatedThumb.setScaleX(0.0);
        this.animatedThumb.setScaleY(0.0);
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.coloredTrack);
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.animatedThumb);
        this.registerChangeListener2((ObservableValue<?>)slider.valueFactoryProperty(), "VALUE_FACTORY", this::refreshSliderValueBinding);
        this.initListeners();
    }

    private void refreshSliderValueBinding() {
        this.sliderValue.textProperty().unbind();
        if (((JFXSlider)this.getSkinnable()).getValueFactory() != null) {
            this.sliderValue.textProperty().bind((ObservableValue)((JFXSlider)this.getSkinnable()).getValueFactory().call((Object)((JFXSlider)this.getSkinnable())));
        } else {
            this.sliderValue.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((Slider)this.getSkinnable()).getLabelFormatter() != null) {
                    return ((Slider)this.getSkinnable()).getLabelFormatter().toString((Object)((Slider)this.getSkinnable()).getValue());
                }
                return Math.round(((Slider)this.getSkinnable()).getValue()) + "";
            }, (Observable[])new Observable[]{((Slider)this.getSkinnable()).valueProperty()}));
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double layoutY;
        double layoutX;
        double height;
        double width;
        boolean horizontal;
        super.layoutChildren(x, y, w, h);
        if (!this.isValid) {
            this.initializeVariables();
            this.initAnimation(((Slider)this.getSkinnable()).getOrientation());
            this.isValid = true;
        }
        double prefWidth = this.animatedThumb.prefWidth(-1.0);
        this.animatedThumb.resize(prefWidth, this.animatedThumb.prefHeight(prefWidth));
        boolean bl = horizontal = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        if (horizontal) {
            width = this.thumb.getLayoutX() - this.snappedLeftInset();
            height = this.track.getHeight();
            layoutX = this.track.getLayoutX();
            layoutY = this.track.getLayoutY();
            this.animatedThumb.setLayoutX(this.thumb.getLayoutX() + this.thumb.getWidth() / 2.0 - this.animatedThumb.getWidth() / 2.0);
        } else {
            height = this.track.getLayoutBounds().getMaxY() + this.track.getLayoutY() - this.thumb.getLayoutY() - this.snappedBottomInset();
            width = this.track.getWidth();
            layoutX = this.track.getLayoutX();
            layoutY = this.thumb.getLayoutY();
            this.animatedThumb.setLayoutY(this.thumb.getLayoutY() + this.thumb.getHeight() / 2.0 - this.animatedThumb.getHeight() / 2.0);
        }
        this.coloredTrack.resizeRelocate(layoutX, layoutY, width, height);
    }

    private void initializeVariables() {
        this.shifting = 30.0 + this.thumb.getWidth();
        if (((Slider)this.getSkinnable()).getOrientation() != Orientation.HORIZONTAL) {
            this.horizontalRotation = -90.0;
        }
        if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() != JFXSlider.IndicatorPosition.LEFT) {
            this.indicatorRotation = 180.0;
            this.shifting = -this.shifting;
        }
        double rotationAngle = 45.0;
        this.sliderValue.setRotate(45.0 + this.indicatorRotation + 3.0 * this.horizontalRotation);
        this.animatedThumb.setRotate(-45.0 + this.indicatorRotation + this.horizontalRotation);
        this.thumb.backgroundProperty().addListener((o, oldVal, newVal) -> {
            if (this.animatedThumb.getBackground() != null) {
                this.animatedThumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((BackgroundFill)newVal.getFills().get(0)).getFill(), ((BackgroundFill)this.animatedThumb.getBackground().getFills().get(0)).getRadii(), ((BackgroundFill)this.animatedThumb.getBackground().getFills().get(0)).getInsets())}));
            } else {
                this.animatedThumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((BackgroundFill)newVal.getFills().get(0)).getFill(), new CornerRadii(50.0, 50.0, 50.0, 0.0, true), null)}));
            }
        });
    }

    private void initListeners() {
        ((Slider)this.getSkinnable()).setOnMousePressed(me -> {
            if (!me.isConsumed()) {
                me.consume();
                this.track.fireEvent(me);
            }
        });
        ((Slider)this.getSkinnable()).setOnMouseReleased(me -> {
            if (!me.isConsumed()) {
                me.consume();
                this.track.fireEvent(me);
            }
        });
        ((Slider)this.getSkinnable()).setOnMouseDragged(me -> {
            if (!me.isConsumed()) {
                me.consume();
                this.track.fireEvent(me);
            }
        });
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.track.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.track.backgroundProperty().addListener((o, oldVal, newVal) -> {
            if (!this.internalChange && newVal != null) {
                this.trackColor = ((BackgroundFill)newVal.getFills().get(0)).getFill();
            }
        });
        this.thumb.backgroundProperty().addListener((o, oldVal, newVal) -> {
            if (!this.internalChange && newVal != null) {
                this.thumbColor = ((BackgroundFill)newVal.getFills().get(0)).getFill();
                if (((Slider)this.getSkinnable()).getValue() == ((Slider)this.getSkinnable()).getMin()) {
                    this.internalChange = true;
                    this.thumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.trackColor, new CornerRadii(20.0), Insets.EMPTY)}));
                    this.internalChange = false;
                }
            }
        });
        this.refreshSliderValueBinding();
        ((Slider)this.getSkinnable()).valueProperty().addListener((o, oldVal, newVal) -> {
            this.internalChange = true;
            if (((Slider)this.getSkinnable()).getMin() == newVal.doubleValue()) {
                this.thumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.trackColor, new CornerRadii(20.0), Insets.EMPTY)}));
                this.animatedThumb.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"min"), true);
            } else if (oldVal.doubleValue() == ((Slider)this.getSkinnable()).getMin()) {
                this.thumb.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.thumbColor, new CornerRadii(20.0), Insets.EMPTY)}));
                this.animatedThumb.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"min"), false);
            }
            this.internalChange = false;
        });
        ((Slider)this.getSkinnable()).orientationProperty().addListener((o, oldVal, newVal) -> this.initAnimation((Orientation)newVal));
        this.animatedThumb.layoutBoundsProperty().addListener((o, oldVal, newVal) -> this.initAnimation(((Slider)this.getSkinnable()).getOrientation()));
    }

    private void initAnimation(Orientation orientation) {
        DoubleProperty layoutProperty;
        double thumbNewPos;
        double thumbPos;
        if (orientation == Orientation.HORIZONTAL) {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutY() - this.thumb.getHeight();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                thumbPos = this.thumb.getLayoutY() - this.animatedThumb.getHeight() / 2.0;
                thumbNewPos = this.thumb.getLayoutY() - this.animatedThumb.getHeight() - this.thumb.getHeight();
            }
            layoutProperty = this.animatedThumb.translateYProperty();
        } else {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutX() - this.thumb.getWidth();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                thumbPos = this.thumb.getLayoutX() - this.animatedThumb.getWidth() / 2.0;
                thumbNewPos = this.thumb.getLayoutX() - this.animatedThumb.getWidth() - this.thumb.getWidth();
            }
            layoutProperty = this.animatedThumb.translateXProperty();
        }
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)layoutProperty, (Object)thumbPos, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)layoutProperty, (Object)thumbNewPos, Interpolator.EASE_BOTH)})});
    }
}

