/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.java.disco;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.java.JavaPackageType;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaDistribution;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaRemoteVersion;
import org.jackhuang.hmcl.download.java.disco.DiscoResult;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class DiscoFetchJavaListTask
extends Task<EnumMap<JavaPackageType, TreeMap<Integer, DiscoJavaRemoteVersion>>> {
    public static final String API_ROOT = System.getProperty("hmcl.discoapi.override", "https://api.foojay.io/disco/v3.0");
    private final DiscoJavaDistribution distribution;
    private final String archiveType;
    private final Task<String> fetchPackagesTask;

    public DiscoFetchJavaListTask(DownloadProvider downloadProvider, DiscoJavaDistribution distribution, Platform platform) {
        this.distribution = distribution;
        this.archiveType = platform.getOperatingSystem() == OperatingSystem.WINDOWS ? "zip" : "tar.gz";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("distribution", distribution.getApiParameter());
        params.put("operating_system", platform.getOperatingSystem().getCheckedName());
        params.put("architecture", platform.getArchitecture().getCheckedName());
        params.put("archive_type", this.archiveType);
        params.put("directly_downloadable", "true");
        if (platform.getOperatingSystem() == OperatingSystem.LINUX) {
            params.put("lib_c_type", "glibc");
        }
        this.fetchPackagesTask = new GetTask(downloadProvider.injectURLWithCandidates(NetworkUtils.withQuery(API_ROOT + "/packages", params)));
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.fetchPackagesTask);
    }

    @Override
    public void execute() throws Exception {
        String json = this.fetchPackagesTask.getResult();
        List<DiscoJavaRemoteVersion> list = JsonUtils.fromNonNullJson(json, DiscoResult.typeOf(DiscoJavaRemoteVersion.class)).getResult();
        EnumMap<JavaPackageType, TreeMap> result = new EnumMap<JavaPackageType, TreeMap>(JavaPackageType.class);
        for (DiscoJavaRemoteVersion version : list) {
            int jdkVersion;
            JavaPackageType packageType;
            TreeMap map;
            DiscoJavaRemoteVersion oldVersion;
            if (!this.distribution.getApiParameter().equals(version.getDistribution()) || !version.isDirectlyDownloadable() || !this.archiveType.equals(version.getArchiveType()) || !this.distribution.testVersion(version) || (oldVersion = (DiscoJavaRemoteVersion)(map = result.computeIfAbsent(packageType = JavaPackageType.of("jdk".equals(version.getPackageType()), version.isJavaFXBundled()), ignored -> new TreeMap())).get(jdkVersion = version.getJdkVersion())) != null && VersionNumber.compare(version.getDistributionVersion(), oldVersion.getDistributionVersion()) <= 0) continue;
            map.put(jdkVersion, version);
        }
        this.setResult(result);
    }
}

