/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modinfo;

import com.google.gson.JsonParseException;
import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.logging.Logger;

@Immutable
public final class ForgeNewModMetadata {
    private final String modLoader;
    private final String loaderVersion;
    private final String logoFile;
    private final String license;
    private final List<Mod> mods;

    public ForgeNewModMetadata(String modLoader, String loaderVersion, String logoFile, String license, List<Mod> mods) {
        this.modLoader = modLoader;
        this.loaderVersion = loaderVersion;
        this.logoFile = logoFile;
        this.license = license;
        this.mods = mods;
    }

    public String getModLoader() {
        return this.modLoader;
    }

    public String getLoaderVersion() {
        return this.loaderVersion;
    }

    public String getLogoFile() {
        return this.logoFile;
    }

    public String getLicense() {
        return this.license;
    }

    public List<Mod> getMods() {
        return this.mods;
    }

    public static LocalModFile fromForgeFile(ModManager modManager, Path modFile, FileSystem fs) throws IOException {
        return ForgeNewModMetadata.fromFile(modManager, modFile, fs, ModLoaderType.FORGE);
    }

    public static LocalModFile fromNeoForgeFile(ModManager modManager, Path modFile, FileSystem fs) throws IOException {
        return ForgeNewModMetadata.fromFile(modManager, modFile, fs, ModLoaderType.NEO_FORGED);
    }

    private static LocalModFile fromFile(ModManager modManager, Path modFile, FileSystem fs, ModLoaderType modLoaderType) throws IOException {
        if (modLoaderType != ModLoaderType.FORGE && modLoaderType != ModLoaderType.NEO_FORGED) {
            throw new IOException("Invalid mod loader: " + String.valueOf((Object)modLoaderType));
        }
        if (modLoaderType == ModLoaderType.NEO_FORGED) {
            try {
                return ForgeNewModMetadata.fromFile0("META-INF/neoforge.mods.toml", modLoaderType, modManager, modFile, fs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return ForgeNewModMetadata.fromFile0("META-INF/mods.toml", modLoaderType, modManager, modFile, fs);
        }
        catch (Exception exception) {
            try {
                return ForgeNewModMetadata.fromEmbeddedMod(modManager, modFile, fs, modLoaderType);
            }
            catch (Exception exception2) {
                throw new IOException("File " + String.valueOf(modFile) + " is not a Forge 1.13+ or NeoForge mod.");
            }
        }
    }

    private static LocalModFile fromFile0(String tomlPath, ModLoaderType modLoaderType, ModManager modManager, Path modFile, FileSystem fs) throws IOException, JsonParseException {
        Path modToml = fs.getPath(tomlPath, new String[0]);
        if (Files.notExists(modToml, new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(modFile) + " is not a Forge 1.13+ or NeoForge mod.");
        }
        Toml toml = new Toml().read(Files.readString(modToml));
        ForgeNewModMetadata metadata = toml.to(ForgeNewModMetadata.class);
        if (metadata == null || metadata.getMods().isEmpty()) {
            throw new IOException("Mod " + String.valueOf(modFile) + " `mods.toml` is malformed..");
        }
        Mod mod = metadata.getMods().get(0);
        Path manifestMF = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
        String jarVersion = "";
        if (Files.exists(manifestMF, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(manifestMF, new OpenOption[0]);){
                Manifest manifest = new Manifest(is);
                jarVersion = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to parse MANIFEST.MF in file " + String.valueOf(modFile));
            }
        }
        ModLoaderType type = ForgeNewModMetadata.analyzeLoader(toml, mod.getModId(), modLoaderType);
        return new LocalModFile(modManager, modManager.getLocalMod(mod.getModId(), type), modFile, mod.getDisplayName(), new LocalModFile.Description(mod.getDescription()), mod.getAuthors(), jarVersion == null ? mod.getVersion() : mod.getVersion().replace("${file.jarVersion}", jarVersion), "", mod.getDisplayURL(), metadata.getLogoFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LocalModFile fromEmbeddedMod(ModManager modManager, Path modFile, FileSystem fs, ModLoaderType modLoaderType) throws IOException {
        Manifest manifest;
        Path manifestFile = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
        if (!Files.isRegularFile(manifestFile, new LinkOption[0])) {
            throw new IOException("Missing  MANIFEST.MF in file " + String.valueOf(manifestFile));
        }
        try (InputStream input = Files.newInputStream(manifestFile, new OpenOption[0]);){
            manifest = new Manifest(input);
        }
        List<Object> embeddedModFiles = List.of();
        String embeddedDependenciesMod = manifest.getMainAttributes().getValue("Embedded-Dependencies-Mod");
        if (embeddedDependenciesMod != null) {
            Path embeddedModFile = fs.getPath(embeddedDependenciesMod, new String[0]);
            if (!Files.isRegularFile(embeddedModFile, new LinkOption[0])) {
                Logger.LOG.warning("Missing embedded-dependencies-mod: " + String.valueOf(embeddedModFile));
                throw new IOException();
            }
            embeddedModFiles = List.of(embeddedModFile);
        } else {
            Path jarInJarMetadata = fs.getPath("META-INF/jarjar/metadata.json", new String[0]);
            if (Files.isRegularFile(jarInJarMetadata, new LinkOption[0])) {
                JarInJarMetadata metadata = JsonUtils.fromJsonFile(jarInJarMetadata, JarInJarMetadata.class);
                if (metadata == null) {
                    throw new IOException("Invalid metadata file: " + String.valueOf(jarInJarMetadata));
                }
                metadata.validate();
                embeddedModFiles = new ArrayList();
                for (EmbeddedJarMetadata jar : metadata.jars) {
                    Path path = fs.getPath(jar.path, new String[0]);
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        embeddedModFiles.add(path);
                        continue;
                    }
                    Logger.LOG.warning("Missing embedded-dependencies-mod: " + String.valueOf(path));
                }
            }
        }
        if (embeddedModFiles.isEmpty()) {
            throw new IOException("Missing embedded mods");
        }
        Path tempFile = Files.createTempFile("hmcl-", ".zip", new FileAttribute[0]);
        try {
            for (Path path : embeddedModFiles) {
                LocalModFile localModFile;
                Files.copy(path, tempFile, StandardCopyOption.REPLACE_EXISTING);
                FileSystem embeddedFs = CompressingUtils.createReadOnlyZipFileSystem(tempFile);
                try {
                    localModFile = ForgeNewModMetadata.fromFile(modManager, modFile, embeddedFs, modLoaderType);
                    if (embeddedFs == null) return localModFile;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (embeddedFs == null) throw throwable;
                            try {
                                embeddedFs.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        throw new IOException();
                    }
                }
                embeddedFs.close();
                return localModFile;
            }
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    private static ModLoaderType analyzeLoader(Toml toml, String modID, ModLoaderType loader) throws IOException {
        List dependencies = toml.getList("dependencies." + modID);
        if (dependencies == null) {
            try {
                dependencies = toml.getList("dependencies");
            }
            catch (ClassCastException e) {
                try {
                    Toml table = toml.getTable("dependencies");
                    if (table == null) {
                        return loader;
                    }
                    dependencies = table.getList(modID);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (dependencies == null) {
                return loader;
            }
        }
        ModLoaderType result = null;
        block12: for (HashMap dependency : dependencies) {
            switch ((String)dependency.get("modId")) {
                case "forge": {
                    result = ModLoaderType.FORGE;
                    break block12;
                }
                case "neoforge": {
                    result = ModLoaderType.NEO_FORGED;
                    break block12;
                }
                default: {
                    continue block12;
                }
            }
        }
        if (result == loader) {
            return result;
        }
        if (result != null) {
            throw new IOException("Loader mismatch");
        }
        Logger.LOG.warning("Cannot determine the mod loader for mod " + modID + ", expected " + String.valueOf((Object)loader));
        return loader;
    }

    public static class Mod {
        private final String modId;
        private final String version;
        private final String displayName;
        private final String side;
        private final String displayURL;
        private final String authors;
        private final String description;

        public Mod() {
            this("", "", "", "", "", "", "");
        }

        public Mod(String modId, String version, String displayName, String side, String displayURL, String authors, String description) {
            this.modId = modId;
            this.version = version;
            this.displayName = displayName;
            this.side = side;
            this.displayURL = displayURL;
            this.authors = authors;
            this.description = description;
        }

        public String getModId() {
            return this.modId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getSide() {
            return this.side;
        }

        public String getDisplayURL() {
            return this.displayURL;
        }

        public String getAuthors() {
            return this.authors;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private record JarInJarMetadata(List<EmbeddedJarMetadata> jars) implements Validation
    {
        @Override
        public void validate() throws JsonParseException {
            Validation.requireNonNull(this.jars, "jars");
            for (EmbeddedJarMetadata jar : this.jars) {
                jar.validate();
            }
        }
    }

    private record EmbeddedJarMetadata(String path, boolean isObfuscated) implements Validation
    {
        @Override
        public void validate() throws JsonParseException {
            Validation.requireNonNull(this.path, "path");
        }
    }
}

