/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import java.util.concurrent.atomic.AtomicBoolean;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public final class CacheMemento {
    private boolean cache;
    private boolean cacheShape;
    private boolean snapToPixel;
    private CacheHint cacheHint = CacheHint.DEFAULT;
    private final Node node;
    private final AtomicBoolean isCached = new AtomicBoolean(false);

    public CacheMemento(Node node) {
        this.node = node;
    }

    public void cache() {
        if (!this.isCached.getAndSet(true)) {
            this.cache = this.node.isCache();
            this.cacheHint = this.node.getCacheHint();
            this.node.setCache(true);
            this.node.setCacheHint(CacheHint.SPEED);
            Node node = this.node;
            if (node instanceof Region) {
                Region region = (Region)node;
                this.cacheShape = region.isCacheShape();
                this.snapToPixel = region.isSnapToPixel();
                region.setCacheShape(true);
                region.setSnapToPixel(true);
            }
        }
    }

    public void restore() {
        if (this.isCached.getAndSet(false)) {
            this.node.setCache(this.cache);
            this.node.setCacheHint(this.cacheHint);
            Node node = this.node;
            if (node instanceof Region) {
                Region region = (Region)node;
                region.setCacheShape(this.cacheShape);
                region.setSnapToPixel(this.snapToPixel);
            }
        }
    }
}

