/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.quantize;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.glavo.monetfx.internal.quantize.Quantizer;
import org.glavo.monetfx.internal.quantize.QuantizerMap;
import org.glavo.monetfx.internal.quantize.QuantizerResult;
import org.glavo.monetfx.internal.utils.ColorUtils;

public final class QuantizerWu
implements Quantizer {
    int[] weights;
    int[] momentsR;
    int[] momentsG;
    int[] momentsB;
    double[] moments;
    Box[] cubes;
    private static final int INDEX_BITS = 5;
    private static final int INDEX_COUNT = 33;
    private static final int TOTAL_SIZE = 35937;

    @Override
    public QuantizerResult quantize(int[] pixels, int colorCount) {
        QuantizerResult mapResult = new QuantizerMap().quantize(pixels, colorCount);
        this.constructHistogram(mapResult.colorToCount);
        this.createMoments();
        CreateBoxesResult createBoxesResult = this.createBoxes(colorCount);
        List<Integer> colors = this.createResult(createBoxesResult.resultCount);
        LinkedHashMap<Integer, Integer> resultMap = new LinkedHashMap<Integer, Integer>();
        for (int color : colors) {
            resultMap.put(color, 0);
        }
        return new QuantizerResult(resultMap);
    }

    static int getIndex(int r, int g, int b) {
        return (r << 10) + (r << 6) + r + (g << 5) + g + b;
    }

    void constructHistogram(Map<Integer, Integer> pixels) {
        this.weights = new int[35937];
        this.momentsR = new int[35937];
        this.momentsG = new int[35937];
        this.momentsB = new int[35937];
        this.moments = new double[35937];
        for (Map.Entry<Integer, Integer> pair : pixels.entrySet()) {
            int index;
            int pixel = pair.getKey();
            int count = pair.getValue();
            int red = ColorUtils.redFromArgb(pixel);
            int green = ColorUtils.greenFromArgb(pixel);
            int blue = ColorUtils.blueFromArgb(pixel);
            int bitsToRemove = 3;
            int iR = (red >> bitsToRemove) + 1;
            int iG = (green >> bitsToRemove) + 1;
            int iB = (blue >> bitsToRemove) + 1;
            int n = index = QuantizerWu.getIndex(iR, iG, iB);
            this.weights[n] = this.weights[n] + count;
            int n2 = index;
            this.momentsR[n2] = this.momentsR[n2] + red * count;
            int n3 = index;
            this.momentsG[n3] = this.momentsG[n3] + green * count;
            int n4 = index;
            this.momentsB[n4] = this.momentsB[n4] + blue * count;
            int n5 = index;
            this.moments[n5] = this.moments[n5] + (double)(count * (red * red + green * green + blue * blue));
        }
    }

    void createMoments() {
        for (int r = 1; r < 33; ++r) {
            int[] area = new int[33];
            int[] areaR = new int[33];
            int[] areaG = new int[33];
            int[] areaB = new int[33];
            double[] area2 = new double[33];
            for (int g = 1; g < 33; ++g) {
                int line = 0;
                int lineR = 0;
                int lineG = 0;
                int lineB = 0;
                double line2 = 0.0;
                for (int b = 1; b < 33; ++b) {
                    int index = QuantizerWu.getIndex(r, g, b);
                    line += this.weights[index];
                    lineR += this.momentsR[index];
                    lineG += this.momentsG[index];
                    lineB += this.momentsB[index];
                    line2 += this.moments[index];
                    int n = b;
                    area[n] = area[n] + line;
                    int n2 = b;
                    areaR[n2] = areaR[n2] + lineR;
                    int n3 = b;
                    areaG[n3] = areaG[n3] + lineG;
                    int n4 = b;
                    areaB[n4] = areaB[n4] + lineB;
                    int n5 = b;
                    area2[n5] = area2[n5] + line2;
                    int previousIndex = QuantizerWu.getIndex(r - 1, g, b);
                    this.weights[index] = this.weights[previousIndex] + area[b];
                    this.momentsR[index] = this.momentsR[previousIndex] + areaR[b];
                    this.momentsG[index] = this.momentsG[previousIndex] + areaG[b];
                    this.momentsB[index] = this.momentsB[previousIndex] + areaB[b];
                    this.moments[index] = this.moments[previousIndex] + area2[b];
                }
            }
        }
    }

    CreateBoxesResult createBoxes(int maxColorCount) {
        this.cubes = new Box[maxColorCount];
        for (int i = 0; i < maxColorCount; ++i) {
            this.cubes[i] = new Box();
        }
        double[] volumeVariance = new double[maxColorCount];
        Box firstBox = this.cubes[0];
        firstBox.r1 = 32;
        firstBox.g1 = 32;
        firstBox.b1 = 32;
        int generatedColorCount = maxColorCount;
        int next = 0;
        for (int i = 1; i < maxColorCount; ++i) {
            if (this.cut(this.cubes[next], this.cubes[i]).booleanValue()) {
                volumeVariance[next] = this.cubes[next].vol > 1 ? this.variance(this.cubes[next]) : 0.0;
                volumeVariance[i] = this.cubes[i].vol > 1 ? this.variance(this.cubes[i]) : 0.0;
            } else {
                volumeVariance[next] = 0.0;
                --i;
            }
            next = 0;
            double temp = volumeVariance[0];
            for (int j = 1; j <= i; ++j) {
                if (!(volumeVariance[j] > temp)) continue;
                temp = volumeVariance[j];
                next = j;
            }
            if (!(temp <= 0.0)) continue;
            generatedColorCount = i + 1;
            break;
        }
        return new CreateBoxesResult(maxColorCount, generatedColorCount);
    }

    List<Integer> createResult(int colorCount) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < colorCount; ++i) {
            Box cube = this.cubes[i];
            int weight = QuantizerWu.volume(cube, this.weights);
            if (weight <= 0) continue;
            int r = QuantizerWu.volume(cube, this.momentsR) / weight;
            int g = QuantizerWu.volume(cube, this.momentsG) / weight;
            int b = QuantizerWu.volume(cube, this.momentsB) / weight;
            int color = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            colors.add(color);
        }
        return colors;
    }

    double variance(Box cube) {
        int dr = QuantizerWu.volume(cube, this.momentsR);
        int dg = QuantizerWu.volume(cube, this.momentsG);
        int db = QuantizerWu.volume(cube, this.momentsB);
        double xx = this.moments[QuantizerWu.getIndex(cube.r1, cube.g1, cube.b1)] - this.moments[QuantizerWu.getIndex(cube.r1, cube.g1, cube.b0)] - this.moments[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b1)] + this.moments[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b0)] - this.moments[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b1)] + this.moments[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b0)] + this.moments[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b1)] - this.moments[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b0)];
        int hypotenuse = dr * dr + dg * dg + db * db;
        int volume = QuantizerWu.volume(cube, this.weights);
        return xx - (double)hypotenuse / (double)volume;
    }

    Boolean cut(Box one, Box two) {
        Direction cutDirection;
        int wholeR = QuantizerWu.volume(one, this.momentsR);
        int wholeG = QuantizerWu.volume(one, this.momentsG);
        int wholeB = QuantizerWu.volume(one, this.momentsB);
        int wholeW = QuantizerWu.volume(one, this.weights);
        MaximizeResult maxRResult = this.maximize(one, Direction.RED, one.r0 + 1, one.r1, wholeR, wholeG, wholeB, wholeW);
        MaximizeResult maxGResult = this.maximize(one, Direction.GREEN, one.g0 + 1, one.g1, wholeR, wholeG, wholeB, wholeW);
        MaximizeResult maxBResult = this.maximize(one, Direction.BLUE, one.b0 + 1, one.b1, wholeR, wholeG, wholeB, wholeW);
        double maxR = maxRResult.maximum;
        double maxG = maxGResult.maximum;
        double maxB = maxBResult.maximum;
        if (maxR >= maxG && maxR >= maxB) {
            if (maxRResult.cutLocation < 0) {
                return false;
            }
            cutDirection = Direction.RED;
        } else {
            cutDirection = maxG >= maxR && maxG >= maxB ? Direction.GREEN : Direction.BLUE;
        }
        two.r1 = one.r1;
        two.g1 = one.g1;
        two.b1 = one.b1;
        switch (cutDirection.ordinal()) {
            case 0: {
                two.r0 = one.r1 = maxRResult.cutLocation;
                two.g0 = one.g0;
                two.b0 = one.b0;
                break;
            }
            case 1: {
                one.g1 = maxGResult.cutLocation;
                two.r0 = one.r0;
                two.g0 = one.g1;
                two.b0 = one.b0;
                break;
            }
            case 2: {
                one.b1 = maxBResult.cutLocation;
                two.r0 = one.r0;
                two.g0 = one.g0;
                two.b0 = one.b1;
            }
        }
        one.vol = (one.r1 - one.r0) * (one.g1 - one.g0) * (one.b1 - one.b0);
        two.vol = (two.r1 - two.r0) * (two.g1 - two.g0) * (two.b1 - two.b0);
        return true;
    }

    MaximizeResult maximize(Box cube, Direction direction, int first, int last, int wholeR, int wholeG, int wholeB, int wholeW) {
        int bottomR = QuantizerWu.bottom(cube, direction, this.momentsR);
        int bottomG = QuantizerWu.bottom(cube, direction, this.momentsG);
        int bottomB = QuantizerWu.bottom(cube, direction, this.momentsB);
        int bottomW = QuantizerWu.bottom(cube, direction, this.weights);
        double max = 0.0;
        int cut = -1;
        int halfR = 0;
        int halfG = 0;
        int halfB = 0;
        int halfW = 0;
        for (int i = first; i < last; ++i) {
            halfR = bottomR + QuantizerWu.top(cube, direction, i, this.momentsR);
            halfG = bottomG + QuantizerWu.top(cube, direction, i, this.momentsG);
            halfB = bottomB + QuantizerWu.top(cube, direction, i, this.momentsB);
            halfW = bottomW + QuantizerWu.top(cube, direction, i, this.weights);
            if (halfW == 0) continue;
            double tempNumerator = halfR * halfR + halfG * halfG + halfB * halfB;
            double tempDenominator = halfW;
            double temp = tempNumerator / tempDenominator;
            halfR = wholeR - halfR;
            halfG = wholeG - halfG;
            halfB = wholeB - halfB;
            if ((halfW = wholeW - halfW) == 0 || !((temp += (tempNumerator = (double)(halfR * halfR + halfG * halfG + halfB * halfB)) / (tempDenominator = (double)halfW)) > max)) continue;
            max = temp;
            cut = i;
        }
        return new MaximizeResult(cut, max);
    }

    static int volume(Box cube, int[] moment) {
        return moment[QuantizerWu.getIndex(cube.r1, cube.g1, cube.b1)] - moment[QuantizerWu.getIndex(cube.r1, cube.g1, cube.b0)] - moment[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b1)] + moment[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b0)] - moment[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b1)] + moment[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b0)] + moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b1)] - moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b0)];
    }

    static int bottom(Box cube, Direction direction, int[] moment) {
        switch (direction.ordinal()) {
            case 0: {
                return -moment[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b1)] + moment[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b0)] + moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b1)] - moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b0)];
            }
            case 1: {
                return -moment[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b1)] + moment[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b0)] + moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b1)] - moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b0)];
            }
            case 2: {
                return -moment[QuantizerWu.getIndex(cube.r1, cube.g1, cube.b0)] + moment[QuantizerWu.getIndex(cube.r1, cube.g0, cube.b0)] + moment[QuantizerWu.getIndex(cube.r0, cube.g1, cube.b0)] - moment[QuantizerWu.getIndex(cube.r0, cube.g0, cube.b0)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)direction));
    }

    static int top(Box cube, Direction direction, int position, int[] moment) {
        switch (direction.ordinal()) {
            case 0: {
                return moment[QuantizerWu.getIndex(position, cube.g1, cube.b1)] - moment[QuantizerWu.getIndex(position, cube.g1, cube.b0)] - moment[QuantizerWu.getIndex(position, cube.g0, cube.b1)] + moment[QuantizerWu.getIndex(position, cube.g0, cube.b0)];
            }
            case 1: {
                return moment[QuantizerWu.getIndex(cube.r1, position, cube.b1)] - moment[QuantizerWu.getIndex(cube.r1, position, cube.b0)] - moment[QuantizerWu.getIndex(cube.r0, position, cube.b1)] + moment[QuantizerWu.getIndex(cube.r0, position, cube.b0)];
            }
            case 2: {
                return moment[QuantizerWu.getIndex(cube.r1, cube.g1, position)] - moment[QuantizerWu.getIndex(cube.r1, cube.g0, position)] - moment[QuantizerWu.getIndex(cube.r0, cube.g1, position)] + moment[QuantizerWu.getIndex(cube.r0, cube.g0, position)];
            }
        }
        throw new IllegalArgumentException("unexpected direction " + (Object)((Object)direction));
    }

    private static final class CreateBoxesResult {
        int requestedCount;
        int resultCount;

        CreateBoxesResult(int requestedCount, int resultCount) {
            this.requestedCount = requestedCount;
            this.resultCount = resultCount;
        }
    }

    private static final class Box {
        int r0 = 0;
        int r1 = 0;
        int g0 = 0;
        int g1 = 0;
        int b0 = 0;
        int b1 = 0;
        int vol = 0;

        private Box() {
        }
    }

    private static enum Direction {
        RED,
        GREEN,
        BLUE;

    }

    private static final class MaximizeResult {
        int cutLocation;
        double maximum;

        MaximizeResult(int cut, double max) {
            this.cutLocation = cut;
            this.maximum = max;
        }
    }
}

