/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.score;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.glavo.monetfx.internal.hct.Hct;
import org.glavo.monetfx.internal.utils.MathUtils;

public final class Score {
    private static final double TARGET_CHROMA = 48.0;
    private static final double WEIGHT_PROPORTION = 0.7;
    private static final double WEIGHT_CHROMA_ABOVE = 0.3;
    private static final double WEIGHT_CHROMA_BELOW = 0.1;
    private static final double CUTOFF_CHROMA = 5.0;
    private static final double CUTOFF_EXCITED_PROPORTION = 0.01;
    private static final Comparator<ScoredHCT> SCORED_COMPARATOR = (entry1, entry2) -> Double.compare(entry2.score, entry1.score);

    private Score() {
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation, int desired, int fallbackColorArgb) {
        return Score.score(colorsToPopulation, desired, fallbackColorArgb, true);
    }

    public static List<Integer> score(Map<Integer, Integer> colorsToPopulation, int desired, int fallbackColorArgb, boolean filter) {
        ArrayList<Hct> colorsHct = new ArrayList<Hct>();
        int[] huePopulation = new int[360];
        double populationSum = 0.0;
        for (Map.Entry<Integer, Integer> entry : colorsToPopulation.entrySet()) {
            int hue;
            Hct hct = Hct.fromInt(entry.getKey());
            colorsHct.add(hct);
            int n = hue = (int)Math.floor(hct.getHue());
            huePopulation[n] = huePopulation[n] + entry.getValue();
            populationSum += (double)entry.getValue().intValue();
        }
        double[] hueExcitedProportions = new double[360];
        for (int hue = 0; hue < 360; ++hue) {
            double proportion = (double)huePopulation[hue] / populationSum;
            for (int i = hue - 14; i < hue + 16; ++i) {
                int neighborHue;
                int n = neighborHue = MathUtils.sanitizeDegreesInt(i);
                hueExcitedProportions[n] = hueExcitedProportions[n] + proportion;
            }
        }
        ArrayList<ScoredHCT> scoredHcts = new ArrayList<ScoredHCT>();
        for (Hct hct : colorsHct) {
            int hue = MathUtils.sanitizeDegreesInt((int)Math.round(hct.getHue()));
            double proportion = hueExcitedProportions[hue];
            if (filter && (hct.getChroma() < 5.0 || proportion <= 0.01)) continue;
            double proportionScore = proportion * 100.0 * 0.7;
            double chromaWeight = hct.getChroma() < 48.0 ? 0.1 : 0.3;
            double chromaScore = (hct.getChroma() - 48.0) * chromaWeight;
            double score = proportionScore + chromaScore;
            scoredHcts.add(new ScoredHCT(hct, score));
        }
        scoredHcts.sort(SCORED_COMPARATOR);
        ArrayList<Hct> chosenColors = new ArrayList<Hct>();
        for (int differenceDegrees = 90; differenceDegrees >= 15; --differenceDegrees) {
            chosenColors.clear();
            for (ScoredHCT entry : scoredHcts) {
                Hct hct = entry.hct;
                boolean hasDuplicateHue = false;
                for (Hct chosenHct : chosenColors) {
                    if (!(MathUtils.differenceDegrees(hct.getHue(), chosenHct.getHue()) < (double)differenceDegrees)) continue;
                    hasDuplicateHue = true;
                    break;
                }
                if (!hasDuplicateHue) {
                    chosenColors.add(hct);
                }
                if (chosenColors.size() < desired) continue;
                break;
            }
            if (chosenColors.size() >= desired) break;
        }
        ArrayList<Integer> colors = new ArrayList<Integer>();
        if (chosenColors.isEmpty()) {
            colors.add(fallbackColorArgb);
        }
        for (Hct chosenHct : chosenColors) {
            colors.add(chosenHct.toInt());
        }
        return colors;
    }

    private static class ScoredHCT {
        public final Hct hct;
        public final double score;

        public ScoredHCT(Hct hct, double score) {
            this.hct = hct;
            this.score = score;
        }
    }
}

