/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import com.google.gson.annotations.SerializedName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.auth.offline.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureModel;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.Nullable;

public class Skin {
    private final Type type;
    private final String cslApi;
    private final TextureModel textureModel;
    private final String localSkinPath;
    private final String localCapePath;

    public Skin(Type type, String cslApi, TextureModel textureModel, String localSkinPath, String localCapePath) {
        this.type = type;
        this.cslApi = cslApi;
        this.textureModel = textureModel;
        this.localSkinPath = localSkinPath;
        this.localCapePath = localCapePath;
    }

    public Type getType() {
        return this.type;
    }

    public String getCslApi() {
        return this.cslApi;
    }

    public TextureModel getTextureModel() {
        return this.textureModel == null ? TextureModel.WIDE : this.textureModel;
    }

    public String getLocalSkinPath() {
        return this.localSkinPath;
    }

    public String getLocalCapePath() {
        return this.localCapePath;
    }

    public Task<LoadedSkin> load(String username) {
        switch (this.type.ordinal()) {
            case 0: {
                return Task.supplyAsync(() -> null);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                TextureModel model = this.textureModel != null ? this.textureModel : (this.type == Type.ALEX ? TextureModel.SLIM : TextureModel.WIDE);
                String resource = (model == TextureModel.SLIM ? "/assets/img/skin/slim/" : "/assets/img/skin/wide/") + this.type.name().toLowerCase(Locale.ROOT) + ".png";
                return Task.supplyAsync(() -> new LoadedSkin(model, Texture.loadTexture(new Image(resource)), null));
            }
            case 10: {
                return Task.supplyAsync(() -> {
                    Texture skin = null;
                    Texture cape = null;
                    Optional<Path> skinPath = FileUtils.tryGetPath(this.localSkinPath, new String[0]);
                    Optional<Path> capePath = FileUtils.tryGetPath(this.localCapePath, new String[0]);
                    if (skinPath.isPresent()) {
                        skin = Texture.loadTexture(Files.newInputStream(skinPath.get(), new OpenOption[0]));
                    }
                    if (capePath.isPresent()) {
                        cape = Texture.loadTexture(Files.newInputStream(capePath.get(), new OpenOption[0]));
                    }
                    return new LoadedSkin(this.getTextureModel(), skin, cape);
                });
            }
            case 11: 
            case 12: {
                String realCslApi = this.type == Type.LITTLE_SKIN ? "https://littleskin.cn/csl" : NetworkUtils.addHttpsIfMissing(StringUtils.removeSuffix(Lang.requireNonNullElse(this.cslApi, ""), "/"));
                return Task.composeAsync(() -> new GetTask(String.format("%s/%s.json", realCslApi, username))).thenComposeAsync(json -> {
                    SkinJson result = JsonUtils.GSON.fromJson((String)json, SkinJson.class);
                    if (!result.hasSkin()) {
                        return Task.supplyAsync(() -> null);
                    }
                    Task[] taskArray = new Task[3];
                    taskArray[0] = Task.supplyAsync(result::getModel);
                    taskArray[1] = result.getHash() == null ? Task.supplyAsync(() -> null) : new FetchBytesTask(String.format("%s/textures/%s", realCslApi, result.getHash()));
                    taskArray[2] = result.getCapeHash() == null ? Task.supplyAsync(() -> null) : new FetchBytesTask(String.format("%s/textures/%s", realCslApi, result.getCapeHash()));
                    return Task.allOf(taskArray);
                }).thenApplyAsync(result -> {
                    if (result == null) {
                        return null;
                    }
                    Texture skin = result.get(1) != null ? Texture.loadTexture((InputStream)result.get(1)) : null;
                    Texture cape = result.get(2) != null ? Texture.loadTexture((InputStream)result.get(2)) : null;
                    return new LoadedSkin((TextureModel)((Object)((Object)result.get(0))), skin, cape);
                });
            }
        }
        throw new UnsupportedOperationException();
    }

    public Map<?, ?> toStorage() {
        return Lang.mapOf(Pair.pair("type", this.type.name().toLowerCase(Locale.ROOT)), Pair.pair("cslApi", this.cslApi), Pair.pair("textureModel", this.getTextureModel().modelName), Pair.pair("localSkinPath", this.localSkinPath), Pair.pair("localCapePath", this.localCapePath));
    }

    public static Skin fromStorage(Map<?, ?> storage) {
        if (storage == null) {
            return null;
        }
        Type type = Lang.tryCast(storage.get("type"), String.class).flatMap(t -> Optional.ofNullable(Type.fromStorage(t))).orElse(Type.DEFAULT);
        String cslApi = Lang.tryCast(storage.get("cslApi"), String.class).orElse(null);
        String textureModel = Lang.tryCast(storage.get("textureModel"), String.class).orElse("default");
        String localSkinPath = Lang.tryCast(storage.get("localSkinPath"), String.class).orElse(null);
        String localCapePath = Lang.tryCast(storage.get("localCapePath"), String.class).orElse(null);
        return new Skin(type, cslApi, "slim".equals(textureModel) ? TextureModel.SLIM : TextureModel.WIDE, localSkinPath, localCapePath);
    }

    public static enum Type {
        DEFAULT,
        ALEX,
        ARI,
        EFE,
        KAI,
        MAKENA,
        NOOR,
        STEVE,
        SUNNY,
        ZURI,
        LOCAL_FILE,
        LITTLE_SKIN,
        CUSTOM_SKIN_LOADER_API,
        YGGDRASIL_API;


        public static Type fromStorage(String type) {
            switch (type) {
                case "default": {
                    return DEFAULT;
                }
                case "alex": {
                    return ALEX;
                }
                case "ari": {
                    return ARI;
                }
                case "efe": {
                    return EFE;
                }
                case "kai": {
                    return KAI;
                }
                case "makena": {
                    return MAKENA;
                }
                case "noor": {
                    return NOOR;
                }
                case "steve": {
                    return STEVE;
                }
                case "sunny": {
                    return SUNNY;
                }
                case "zuri": {
                    return ZURI;
                }
                case "local_file": {
                    return LOCAL_FILE;
                }
                case "little_skin": {
                    return LITTLE_SKIN;
                }
                case "custom_skin_loader_api": {
                    return CUSTOM_SKIN_LOADER_API;
                }
                case "yggdrasil_api": {
                    return YGGDRASIL_API;
                }
            }
            return null;
        }
    }

    public static class LoadedSkin {
        private final TextureModel model;
        private final Texture skin;
        private final Texture cape;

        public LoadedSkin(TextureModel model, Texture skin, Texture cape) {
            this.model = model;
            this.skin = skin;
            this.cape = cape;
        }

        public TextureModel getModel() {
            return this.model;
        }

        public Texture getSkin() {
            return this.skin;
        }

        public Texture getCape() {
            return this.cape;
        }
    }

    private static class SkinJson {
        private final String username;
        private final String skin;
        private final String cape;
        private final String elytra;
        @SerializedName(value="textures", alternate={"skins"})
        private final TextureJson textures;

        public SkinJson(String username, String skin, String cape, String elytra, TextureJson textures) {
            this.username = username;
            this.skin = skin;
            this.cape = cape;
            this.elytra = elytra;
            this.textures = textures;
        }

        public boolean hasSkin() {
            return StringUtils.isNotBlank(this.username);
        }

        @Nullable
        public TextureModel getModel() {
            if (this.textures != null && this.textures.slim != null) {
                return TextureModel.SLIM;
            }
            if (this.textures != null && this.textures.defaultSkin != null) {
                return TextureModel.WIDE;
            }
            return null;
        }

        public String getAlexModelHash() {
            if (this.textures != null && this.textures.slim != null) {
                return this.textures.slim;
            }
            return null;
        }

        public String getSteveModelHash() {
            if (this.textures != null && this.textures.defaultSkin != null) {
                return this.textures.defaultSkin;
            }
            return this.skin;
        }

        public String getHash() {
            TextureModel model = this.getModel();
            if (model == TextureModel.SLIM) {
                return this.getAlexModelHash();
            }
            if (model == TextureModel.WIDE) {
                return this.getSteveModelHash();
            }
            return null;
        }

        public String getCapeHash() {
            if (this.textures != null && this.textures.cape != null) {
                return this.textures.cape;
            }
            return this.cape;
        }

        public static class TextureJson {
            @SerializedName(value="default")
            private final String defaultSkin;
            private final String slim;
            private final String cape;
            private final String elytra;

            public TextureJson(String defaultSkin, String slim, String cape, String elytra) {
                this.defaultSkin = defaultSkin;
                this.slim = slim;
                this.cape = cape;
                this.elytra = elytra;
            }
        }
    }

    private static class FetchBytesTask
    extends FetchTask<InputStream> {
        public FetchBytesTask(String uri) {
            super(List.of(NetworkUtils.toURI(uri)));
        }

        @Override
        protected void useCachedResult(Path cachedFile) throws IOException {
            this.setResult(Files.newInputStream(cachedFile, new OpenOption[0]));
        }

        @Override
        protected FetchTask.EnumCheckETag shouldCheckETag() {
            return FetchTask.EnumCheckETag.CHECK_E_TAG;
        }

        @Override
        protected FetchTask.Context getContext(final HttpResponse<?> response, final boolean checkETag, String bmclapiHash) throws IOException {
            return new FetchTask.Context(){
                final ByteArrayOutputStream baos = new ByteArrayOutputStream();

                @Override
                public void write(byte[] buffer, int offset, int len) {
                    this.baos.write(buffer, offset, len);
                }

                @Override
                public void close() throws IOException {
                    if (!this.isSuccess()) {
                        return;
                    }
                    this.setResult(new ByteArrayInputStream(this.baos.toByteArray()));
                    if (checkETag) {
                        repository.cacheBytes(response, this.baos.toByteArray());
                    }
                }
            };
        }
    }
}

