/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.cleanroom.CleanroomVersionList;
import org.jackhuang.hmcl.download.fabric.FabricAPIVersionList;
import org.jackhuang.hmcl.download.fabric.FabricVersionList;
import org.jackhuang.hmcl.download.forge.ForgeBMCLVersionList;
import org.jackhuang.hmcl.download.game.GameVersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderBMCLVersionList;
import org.jackhuang.hmcl.download.neoforge.NeoForgeBMCLVersionList;
import org.jackhuang.hmcl.download.optifine.OptiFineBMCLVersionList;
import org.jackhuang.hmcl.download.quilt.QuiltAPIVersionList;
import org.jackhuang.hmcl.download.quilt.QuiltVersionList;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class BMCLAPIDownloadProvider
implements DownloadProvider {
    private final String apiRoot;
    private final GameVersionList game;
    private final FabricVersionList fabric;
    private final FabricAPIVersionList fabricApi;
    private final ForgeBMCLVersionList forge;
    private final CleanroomVersionList cleanroom;
    private final NeoForgeBMCLVersionList neoforge;
    private final LiteLoaderBMCLVersionList liteLoader;
    private final OptiFineBMCLVersionList optifine;
    private final QuiltVersionList quilt;
    private final QuiltAPIVersionList quiltApi;
    private final List<Pair<String, String>> replacement;

    public BMCLAPIDownloadProvider(String apiRoot) {
        this.apiRoot = apiRoot;
        this.game = new GameVersionList(this);
        this.fabric = new FabricVersionList(this);
        this.fabricApi = new FabricAPIVersionList(this);
        this.forge = new ForgeBMCLVersionList(apiRoot);
        this.cleanroom = new CleanroomVersionList(this);
        this.neoforge = new NeoForgeBMCLVersionList(apiRoot);
        this.liteLoader = new LiteLoaderBMCLVersionList(this);
        this.optifine = new OptiFineBMCLVersionList(apiRoot);
        this.quilt = new QuiltVersionList(this);
        this.quiltApi = new QuiltAPIVersionList(this);
        this.replacement = Arrays.asList(Pair.pair("https://bmclapi2.bangbang93.com", apiRoot), Pair.pair("https://launchermeta.mojang.com", apiRoot), Pair.pair("https://piston-meta.mojang.com", apiRoot), Pair.pair("https://piston-data.mojang.com", apiRoot), Pair.pair("https://launcher.mojang.com", apiRoot), Pair.pair("https://libraries.minecraft.net", apiRoot + "/libraries"), Pair.pair("http://files.minecraftforge.net/maven", apiRoot + "/maven"), Pair.pair("https://files.minecraftforge.net/maven", apiRoot + "/maven"), Pair.pair("https://maven.minecraftforge.net", apiRoot + "/maven"), Pair.pair("https://maven.neoforged.net/releases/", apiRoot + "/maven/"), Pair.pair("http://dl.liteloader.com/versions/versions.json", apiRoot + "/maven/com/mumfrey/liteloader/versions.json"), Pair.pair("http://dl.liteloader.com/versions", apiRoot + "/maven"), Pair.pair("https://meta.fabricmc.net", apiRoot + "/fabric-meta"), Pair.pair("https://maven.fabricmc.net", apiRoot + "/maven"), Pair.pair("https://authlib-injector.yushi.moe", apiRoot + "/mirrors/authlib-injector"), Pair.pair("https://repo1.maven.org/maven2", "https://mirrors.cloud.tencent.com/nexus/repository/maven-public"), Pair.pair("https://repo.maven.apache.org/maven2", "https://mirrors.cloud.tencent.com/nexus/repository/maven-public"), Pair.pair("https://hmcl.glavo.site/metadata/cleanroom", "https://alist.8mi.tech/d/mirror/HMCL-Metadata/Auto/cleanroom"), Pair.pair("https://hmcl.glavo.site/metadata/fmllibs", "https://alist.8mi.tech/d/mirror/HMCL-Metadata/Auto/fmllibs"), Pair.pair("https://zkitefly.github.io/unlisted-versions-of-minecraft", "https://alist.8mi.tech/d/mirror/unlisted-versions-of-minecraft/Auto"));
    }

    public String getApiRoot() {
        return this.apiRoot;
    }

    @Override
    public List<URI> getVersionListURLs() {
        return List.of(URI.create(this.apiRoot + "/mc/game/version_manifest.json"));
    }

    @Override
    public List<URI> getAssetObjectCandidates(String assetObjectLocation) {
        return List.of(NetworkUtils.toURI(this.apiRoot + "/assets/" + assetObjectLocation));
    }

    @Override
    public VersionList<?> getVersionListById(String id) {
        switch (id) {
            case "game": {
                return this.game;
            }
            case "fabric": {
                return this.fabric;
            }
            case "fabric-api": {
                return this.fabricApi;
            }
            case "forge": {
                return this.forge;
            }
            case "cleanroom": {
                return this.cleanroom;
            }
            case "neoforge": {
                return this.neoforge;
            }
            case "liteloader": {
                return this.liteLoader;
            }
            case "optifine": {
                return this.optifine;
            }
            case "quilt": {
                return this.quilt;
            }
            case "quilt-api": {
                return this.quiltApi;
            }
        }
        throw new IllegalArgumentException("Unrecognized version list id: " + id);
    }

    @Override
    public String injectURL(String baseURL) {
        for (Pair<String, String> pair : this.replacement) {
            if (!baseURL.startsWith(pair.getKey())) continue;
            return pair.getValue() + baseURL.substring(pair.getKey().length());
        }
        return baseURL;
    }

    @Override
    public int getConcurrency() {
        return Math.max(Runtime.getRuntime().availableProcessors() * 2, 6);
    }
}

