/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.curse.CurseAddon;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseManifest;
import org.jackhuang.hmcl.mod.curse.CurseManifestFile;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class CurseCompletionTask
extends Task<Void> {
    private final DefaultDependencyManager dependency;
    private final DefaultGameRepository repository;
    private final ModManager modManager;
    private final String version;
    private CurseManifest manifest;
    private List<Task<?>> dependencies;
    private final AtomicBoolean allNameKnown = new AtomicBoolean(true);
    private final AtomicInteger finished = new AtomicInteger(0);
    private final AtomicBoolean notFound = new AtomicBoolean(false);

    public CurseCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        this(dependencyManager, version, null);
    }

    public CurseCompletionTask(DefaultDependencyManager dependencyManager, String version, CurseManifest manifest) {
        this.dependency = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.modManager = this.repository.getModManager(version);
        this.version = version;
        this.manifest = manifest;
        if (manifest == null) {
            try {
                Path manifestFile = this.repository.getVersionRoot(version).resolve("manifest.json");
                if (Files.exists(manifestFile, new LinkOption[0])) {
                    this.manifest = JsonUtils.fromJsonFile(manifestFile, CurseManifest.class);
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Unable to read CurseForge modpack manifest.json", e);
            }
        }
        this.setStage("hmcl.modpack.download");
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        if (this.manifest == null) {
            return;
        }
        Path root = this.repository.getVersionRoot(this.version);
        CurseManifest newManifest = this.manifest.setFiles(this.manifest.getFiles().parallelStream().map(file -> {
            this.updateProgress(this.finished.incrementAndGet(), this.manifest.getFiles().size());
            if (StringUtils.isBlank(file.getFileName()) || file.getUrl() == null) {
                try {
                    RemoteMod.File remoteFile = CurseForgeRemoteModRepository.MODS.getModFile(Integer.toString(file.getProjectID()), Integer.toString(file.getFileID()));
                    return file.withFileName(remoteFile.getFilename()).withURL(remoteFile.getUrl());
                }
                catch (FileNotFoundException fof) {
                    Logger.LOG.warning("Could not query api.curseforge.com for deleted mods: " + file.getProjectID() + ", " + file.getFileID(), fof);
                    this.notFound.set(true);
                    return file;
                }
                catch (JsonParseException | IOException e) {
                    Logger.LOG.warning("Unable to fetch the file name projectID=" + file.getProjectID() + ", fileID=" + file.getFileID(), e);
                    this.allNameKnown.set(false);
                    return file;
                }
            }
            return file;
        }).collect(Collectors.toList()));
        JsonUtils.writeToJsonFile(root.resolve("manifest.json"), newManifest);
        Path versionRoot = this.repository.getVersionRoot(this.modManager.getInstanceId());
        Path resourcePacksRoot = versionRoot.resolve("resourcepacks");
        Path shaderPacksRoot = versionRoot.resolve("shaderpacks");
        this.finished.set(0);
        this.dependencies = ((Stream)newManifest.getFiles().stream().parallel()).filter(f -> f.getFileName() != null).flatMap(f -> {
            try {
                Path path = this.guessFilePath((CurseManifestFile)f, resourcePacksRoot, shaderPacksRoot);
                if (path == null) {
                    Stream stream = Stream.empty();
                    return stream;
                }
                FileDownloadTask task = new FileDownloadTask(f.getUrl(), path);
                task.setCacheRepository(this.dependency.getCacheRepository());
                task.setCaching(true);
                Stream stream = Stream.of(task.withCounter("hmcl.modpack.download"));
                return stream;
            }
            catch (IOException e) {
                Logger.LOG.warning("Could not query api.curseforge.com for mod: " + f.getProjectID() + ", " + f.getFileID(), e);
                Stream stream = Stream.empty();
                return stream;
            }
            finally {
                this.updateProgress(this.finished.incrementAndGet(), newManifest.getFiles().size());
            }
        }).collect(Collectors.toList());
        if (!this.dependencies.isEmpty()) {
            this.getProperties().put("total", this.dependencies.size());
            this.notifyPropertiesChanged();
        }
    }

    private Path guessFilePath(CurseManifestFile file, Path resourcePacksRoot, Path shaderPacksRoot) throws IOException {
        RemoteMod mod = CurseForgeRemoteModRepository.MODS.getModById(Integer.toString(file.getProjectID()));
        int classID = ((CurseAddon)mod.getData()).getClassId();
        String fileName = file.getFileName();
        return switch (classID) {
            case 12, 6552 -> {
                Path res = (classID == 12 ? resourcePacksRoot : shaderPacksRoot).resolve(fileName);
                if (Files.exists(res, new LinkOption[0])) {
                    yield null;
                }
                yield res;
            }
            default -> this.modManager.hasSimpleMod(fileName) ? null : this.modManager.getSimpleModPath(fileName);
        };
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (this.notFound.get()) {
            throw new ModpackCompletionException(new FileNotFoundException());
        }
        if (!this.allNameKnown.get() || !this.isDependenciesSucceeded()) {
            throw new ModpackCompletionException();
        }
    }
}

