/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.ContentEncoding;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NetworkUtils {
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String NAME_VALUE_SEPARATOR = "=";
    public static final int TIME_OUT = 8000;
    static final Pattern CHARSET_REGEX = Pattern.compile("\\s*(charset)\\s*=\\s*['|\"]?(?<charset>[^\"^';,]+)['|\"]?");

    private NetworkUtils() {
    }

    public static boolean isLoopbackAddress(URI uri) {
        String host = uri.getHost();
        if (StringUtils.isBlank(host)) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isHttpUri(URI uri) {
        return "http".equals(uri.getScheme()) || "https".equals(uri.getScheme());
    }

    public static String addHttpsIfMissing(String url) {
        if (Pattern.compile("^(?<scheme>[a-zA-Z][a-zA-Z0-9+.-]*)://").matcher(url).find()) {
            return url;
        }
        if (url.startsWith("//")) {
            return "https:" + url;
        }
        return "https://" + url;
    }

    public static String withQuery(String baseUrl, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(baseUrl);
        boolean first = true;
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (param.getValue() == null) continue;
            if (first) {
                if (!baseUrl.isEmpty()) {
                    sb.append('?');
                }
                first = false;
            } else {
                sb.append(PARAMETER_SEPARATOR);
            }
            sb.append(NetworkUtils.encodeURL(param.getKey()));
            sb.append(NAME_VALUE_SEPARATOR);
            sb.append(NetworkUtils.encodeURL(param.getValue()));
        }
        return sb.toString();
    }

    public static List<URI> withQuery(List<URI> list, Map<String, String> params) {
        return list.stream().map(uri -> URI.create(NetworkUtils.withQuery(uri.toString(), params))).collect(Collectors.toList());
    }

    public static List<Pair<String, String>> parseQuery(URI uri) {
        return NetworkUtils.parseQuery(uri.getRawQuery());
    }

    public static List<Pair<String, String>> parseQuery(String queryParameterString) {
        if (queryParameterString == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        try (Scanner scanner = new Scanner(queryParameterString);){
            scanner.useDelimiter(PARAMETER_SEPARATOR);
            while (scanner.hasNext()) {
                String[] nameValue = scanner.next().split(NAME_VALUE_SEPARATOR);
                if (nameValue.length == 0 || nameValue.length > 2) {
                    throw new IllegalArgumentException("bad query string");
                }
                String name = NetworkUtils.decodeURL(nameValue[0]);
                String value = nameValue.length == 2 ? NetworkUtils.decodeURL(nameValue[1]) : null;
                result.add(Pair.pair(name, value));
            }
        }
        return result;
    }

    public static URI dropQuery(URI u) {
        if (u.getRawQuery() == null && u.getRawFragment() == null) {
            return u;
        }
        try {
            return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Unreachable", e);
        }
    }

    public static URLConnection createConnection(URI uri) throws IOException {
        URLConnection connection;
        try {
            connection = uri.toURL().openConnection();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IOException(e);
        }
        connection.setConnectTimeout(8000);
        connection.setReadTimeout(8000);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestProperty("Accept-Language", Locale.getDefault().toLanguageTag());
            httpConnection.setInstanceFollowRedirects(false);
        }
        return connection;
    }

    public static HttpURLConnection createHttpConnection(String url) throws IOException {
        return (HttpURLConnection)NetworkUtils.createConnection(NetworkUtils.toURI(url));
    }

    public static HttpURLConnection createHttpConnection(URI url) throws IOException {
        return (HttpURLConnection)NetworkUtils.createConnection(url);
    }

    private static void encodeCodePoint(StringBuilder builder, int codePoint) {
        builder.append(NetworkUtils.encodeURL(Character.toString(codePoint)));
    }

    public static String encodeLocation(String location) {
        char ch;
        int i;
        boolean left = true;
        for (i = 0; i < location.length() && (ch = location.charAt(i)) != ' ' && ch != '[' && ch != ']' && ch != '{' && ch != '}' && ch < '\u0080'; ++i) {
            if (ch != '?') continue;
            left = false;
        }
        if (i == location.length()) {
            return location;
        }
        StringBuilder builder = new StringBuilder(location.length() + 10);
        builder.append(location, 0, i);
        while (i < location.length()) {
            char ch2 = location.charAt(i);
            if (ch2 == ' ') {
                if (left) {
                    builder.append("%20");
                } else {
                    builder.append('+');
                }
            } else if (ch2 == '?') {
                left = false;
                builder.append('?');
            } else if (ch2 >= '\u0080' || left && (ch2 == '[' || ch2 == ']' || ch2 == '{' || ch2 == '}')) {
                if (Character.isSurrogate(ch2)) {
                    char ch22;
                    if (Character.isHighSurrogate(ch2) && i < location.length() - 1 && Character.isLowSurrogate(ch22 = location.charAt(i + 1))) {
                        int codePoint = Character.toCodePoint(ch2, ch22);
                        NetworkUtils.encodeCodePoint(builder, codePoint);
                        ++i;
                    } else {
                        NetworkUtils.encodeCodePoint(builder, 65533);
                    }
                } else {
                    NetworkUtils.encodeCodePoint(builder, ch2);
                }
            } else {
                builder.append(ch2);
            }
            ++i;
        }
        return builder.toString();
    }

    public static HttpURLConnection resolveConnection(HttpURLConnection conn) throws IOException {
        boolean useCache = conn.getUseCaches();
        int redirect = 0;
        while (true) {
            conn.setUseCaches(useCache);
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(8000);
            conn.setInstanceFollowRedirects(false);
            Map<String, List<String>> properties = conn.getRequestProperties();
            String method = conn.getRequestMethod();
            int code = conn.getResponseCode();
            if (code < 300 || code > 308 || code == 306 || code == 304) break;
            String newURL = conn.getHeaderField("Location");
            conn.disconnect();
            if (redirect > 20) {
                throw new IOException("Too much redirects");
            }
            HttpURLConnection redirected = (HttpURLConnection)new URL(conn.getURL(), NetworkUtils.encodeLocation(newURL)).openConnection();
            properties.forEach((key, value) -> value.forEach(element -> redirected.addRequestProperty((String)key, (String)element)));
            redirected.setRequestMethod(method);
            conn = redirected;
            ++redirect;
        }
        return conn;
    }

    public static String doGet(String uri) throws IOException {
        return NetworkUtils.doGet(NetworkUtils.toURI(uri));
    }

    public static String doGet(URI uri) throws IOException {
        URLConnection connection = NetworkUtils.createConnection(uri);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            connection = NetworkUtils.resolveConnection(httpURLConnection);
        }
        return NetworkUtils.readFullyAsString(connection);
    }

    public static String doGet(List<URI> uris) throws IOException {
        ArrayList<IOException> exceptions = null;
        for (URI uri : uris) {
            try {
                return NetworkUtils.doGet(uri);
            }
            catch (IOException e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<IOException>(1);
                }
                exceptions.add(e);
            }
        }
        if (exceptions == null) {
            throw new IOException("No candidate URL");
        }
        if (exceptions.size() == 1) {
            throw (IOException)exceptions.get(0);
        }
        IOException exception = new IOException("Failed to doGet");
        for (IOException e : exceptions) {
            exception.addSuppressed(e);
        }
        throw exception;
    }

    public static String doPost(URI uri, String post) throws IOException {
        return NetworkUtils.doPost(uri, post, "application/x-www-form-urlencoded");
    }

    public static String doPost(URI u, Map<String, String> params) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey()).append(NAME_VALUE_SEPARATOR).append(e.getValue()).append(PARAMETER_SEPARATOR);
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return NetworkUtils.doPost(u, sb.toString());
    }

    public static String doPost(URI uri, String post, String contentType) throws IOException {
        byte[] bytes = post.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection con = NetworkUtils.createHttpConnection(uri);
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        con.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        try (OutputStream os = con.getOutputStream();){
            os.write(bytes);
        }
        return NetworkUtils.readFullyAsString(con);
    }

    public static Charset getCharsetFromContentType(String contentType) {
        if (contentType == null || contentType.isBlank()) {
            return StandardCharsets.UTF_8;
        }
        Matcher matcher = CHARSET_REGEX.matcher(contentType);
        if (matcher.find()) {
            String charsetName = matcher.group("charset");
            try {
                return Charset.forName(charsetName);
            }
            catch (Throwable e) {
                Logger.LOG.warning("Bad charset name: " + charsetName + ", using UTF-8 instead", e);
            }
        }
        return StandardCharsets.UTF_8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFullyAsString(URLConnection con) throws IOException {
        try {
            String string;
            ContentEncoding contentEncoding = ContentEncoding.fromConnection(con);
            Charset charset = NetworkUtils.getCharsetFromContentType(con.getHeaderField("Content-Type"));
            InputStream stdout = con.getInputStream();
            try {
                string = IOUtils.readFullyAsString(contentEncoding.wrap(stdout), charset);
                if (stdout == null) return string;
            }
            catch (Throwable throwable) {
                try {
                    if (stdout == null) throw throwable;
                    try {
                        stdout.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String string2;
                    block18: {
                        if (!(con instanceof HttpURLConnection)) throw e;
                        try (InputStream stderr = ((HttpURLConnection)con).getErrorStream();){
                            if (stderr == null) {
                                throw e;
                            }
                            string2 = IOUtils.readFullyAsString(contentEncoding.wrap(stderr), charset);
                            if (stderr == null) break block18;
                        }
                    }
                    if (!(con instanceof HttpURLConnection)) return string2;
                    ((HttpURLConnection)con).disconnect();
                    return string2;
                }
            }
            stdout.close();
            return string;
        }
        finally {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
        }
    }

    public static String detectFileName(URI uri) throws IOException {
        HttpURLConnection conn = NetworkUtils.resolveConnection(NetworkUtils.createHttpConnection(uri));
        int code = conn.getResponseCode();
        if (code / 100 == 4) {
            throw new FileNotFoundException();
        }
        if (code / 100 != 2) {
            throw new ResponseCodeException(uri, conn.getResponseCode());
        }
        String disposition = conn.getHeaderField("Content-Disposition");
        if (disposition == null || !disposition.contains("filename=")) {
            String u = conn.getURL().toString();
            return NetworkUtils.decodeURL(StringUtils.substringAfterLast(u, '/'));
        }
        return NetworkUtils.decodeURL(StringUtils.removeSurrounding(StringUtils.substringAfter(disposition, "filename="), "\""));
    }

    public static String encodeURL(String toEncode) {
        return URLEncoder.encode(toEncode, StandardCharsets.UTF_8);
    }

    public static String decodeURL(String toDecode) {
        return URLDecoder.decode(toDecode, StandardCharsets.UTF_8);
    }

    @NotNull
    public static URI toURI(@NotNull String uri) {
        try {
            return new URI(NetworkUtils.encodeLocation(uri));
        }
        catch (URISyntaxException e) {
            return URI.create(uri);
        }
    }

    @NotNull
    public static URI toURI(@NotNull URL url) {
        return NetworkUtils.toURI(url.toExternalForm());
    }

    @Nullable
    public static URI toURIOrNull(String uri) {
        if (StringUtils.isNotBlank(uri)) {
            try {
                return NetworkUtils.toURI(uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

